/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.startup;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.config.BookmarkConfig;
import mezz.jei.config.EditModeConfig;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IngredientFilterConfig;
import mezz.jei.config.JEIClientConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.config.ModIdFormattingConfig;
import mezz.jei.config.WorldConfig;
import mezz.jei.config.sorting.IngredientTypeSortingConfig;
import mezz.jei.config.sorting.ModNameSortingConfig;
import mezz.jei.config.sorting.RecipeCategorySortingConfig;
import mezz.jei.events.EventBusHelper;
import mezz.jei.events.PlayerJoinedWorldEvent;
import mezz.jei.gui.textures.Textures;
import mezz.jei.ingredients.ForgeModIdHelper;
import mezz.jei.ingredients.IIngredientSorter;
import mezz.jei.ingredients.IngredientSorter;
import mezz.jei.startup.JeiReloadListener;
import mezz.jei.startup.JeiStarter;
import mezz.jei.startup.NetworkHandler;
import mezz.jei.util.AnnotatedInstanceUtil;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientLifecycleHandler {
    final Logger LOGGER = LogManager.getLogger();
    final JeiStarter starter = new JeiStarter();
    final Textures textures;
    final IClientConfig clientConfig;
    final BookmarkConfig bookmarkConfig;
    final ModIdFormattingConfig modIdFormattingConfig;
    final IngredientFilterConfig ingredientFilterConfig;
    final WorldConfig worldConfig;
    final IModIdHelper modIdHelper;
    final IEditModeConfig editModeConfig;
    final RecipeCategorySortingConfig recipeCategorySortingConfig;
    final IIngredientSorter ingredientSorter;
    final List<IModPlugin> plugins;

    public ClientLifecycleHandler(NetworkHandler networkHandler, Textures textures) {
        File jeiConfigurationDir = new File(FMLPaths.CONFIGDIR.get().toFile(), "jei");
        if (!jeiConfigurationDir.exists()) {
            try {
                if (!jeiConfigurationDir.mkdir()) {
                    throw new RuntimeException("Could not create config directory " + jeiConfigurationDir);
                }
            }
            catch (SecurityException e) {
                throw new RuntimeException("Could not create config directory " + jeiConfigurationDir, e);
            }
        }
        this.clientConfig = JEIClientConfig.clientConfig;
        this.ingredientFilterConfig = JEIClientConfig.filterConfig;
        this.modIdFormattingConfig = JEIClientConfig.modNameFormat;
        this.modIdHelper = new ForgeModIdHelper(this.clientConfig, this.modIdFormattingConfig);
        this.bookmarkConfig = new BookmarkConfig(jeiConfigurationDir);
        this.worldConfig = new WorldConfig(jeiConfigurationDir);
        this.editModeConfig = new EditModeConfig(jeiConfigurationDir);
        this.recipeCategorySortingConfig = new RecipeCategorySortingConfig(new File(jeiConfigurationDir, "recipe-category-sort-order.ini"));
        ModNameSortingConfig ingredientModNameSortingConfig = new ModNameSortingConfig(new File(jeiConfigurationDir, "ingredient-list-mod-sort-order.ini"));
        IngredientTypeSortingConfig ingredientTypeSortingConfig = new IngredientTypeSortingConfig(new File(jeiConfigurationDir, "ingredient-list-type-sort-order.ini"));
        this.ingredientSorter = new IngredientSorter(this.clientConfig, ingredientModNameSortingConfig, ingredientTypeSortingConfig);
        ErrorUtil.setModIdHelper(this.modIdHelper);
        ErrorUtil.setWorldConfig(this.worldConfig);
        KeyBindings.init();
        EventBusHelper.addListener(this, WorldEvent.Save.class, event -> this.worldConfig.onWorldSave());
        EventBusHelper.addListener(this, AddReloadListenerEvent.class, event -> this.reloadListenerSetup());
        EventBusHelper.addListener(this, ClientPlayerNetworkEvent.LoggedOutEvent.class, event -> {
            for (ServerType type : ServerType.values()) {
                type.hasRan = false;
            }
        });
        for (ServerType type : ServerType.values()) {
            EventBusHelper.addListener(this, type.listenerClass, event -> {
                if (type.shouldRun()) {
                    this.setupJEI();
                }
            });
        }
        this.plugins = AnnotatedInstanceUtil.getModPlugins();
        networkHandler.createClientPacketHandler(this.worldConfig);
        this.textures = textures;
    }

    private void reloadListenerSetup() {
        IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
        if (!(resourceManager instanceof IReloadableResourceManager)) {
            return;
        }
        if (Internal.getReloadListener() == null) {
            JeiReloadListener reloadListener = new JeiReloadListener(this);
            Internal.setReloadListener(reloadListener);
        } else {
            Internal.getReloadListener().update(this);
        }
        ((IReloadableResourceManager)resourceManager).func_219534_a((IFutureReloadListener)Internal.getReloadListener());
    }

    public void setupJEI() {
        ClientPlayNetHandler connection = Minecraft.func_71410_x().func_147114_u();
        if (connection != null) {
            NetworkManager networkManager = connection.func_147298_b();
            this.worldConfig.syncWorldConfig(networkManager);
        }
        this.modIdFormattingConfig.checkForModNameFormatOverride();
        this.startJEI();
        EventBusHelper.post(new PlayerJoinedWorldEvent());
    }

    public void startJEI() {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            Preconditions.checkNotNull((Object)this.textures);
            this.starter.start(this.plugins, this.textures, this.clientConfig, this.editModeConfig, this.ingredientFilterConfig, this.worldConfig, this.bookmarkConfig, this.modIdHelper, this.recipeCategorySortingConfig, this.ingredientSorter);
        }
    }

    private static enum ServerType {
        VANILLA(TagsUpdatedEvent.VanillaTagTypes.class),
        MODDED(TagsUpdatedEvent.CustomTagTypes.class),
        INTEGRATED_OR_POST_RELOAD(RecipesUpdatedEvent.class);

        public boolean hasRan;
        public final Class<? extends Event> listenerClass;

        private ServerType(Class<? extends Event> listenerClass) {
            this.listenerClass = listenerClass;
        }

        public boolean shouldRun() {
            ClientPlayNetHandler connection = Minecraft.func_71410_x().func_147114_u();
            boolean isIntegrated = Minecraft.func_71410_x().func_71387_A();
            if (connection == null || isIntegrated) {
                this.hasRan = true;
                return this == INTEGRATED_OR_POST_RELOAD;
            }
            if (this == INTEGRATED_OR_POST_RELOAD) {
                if (this.hasRan) {
                    return true;
                }
                this.hasRan = true;
                return false;
            }
            if (this.hasRan) {
                return false;
            }
            this.hasRan = true;
            boolean isVanilla = NetworkHooks.isVanillaConnection((NetworkManager)connection.func_147298_b());
            return isVanilla == (this == VANILLA);
        }
    }
}

