/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.util.ErrorUtil;

public final class Focus<V>
implements IFocus<V> {
    private final IFocus.Mode mode;
    private final V value;

    public Focus(IFocus.Mode mode, V value) {
        ErrorUtil.checkNotNull(mode, "focus mode");
        ErrorUtil.checkIsValidIngredient(value, "focus value");
        this.mode = mode;
        IIngredientHelper<V> ingredientHelper = Internal.getIngredientManager().getIngredientHelper(value);
        this.value = ingredientHelper.copyIngredient(value);
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public IFocus.Mode getMode() {
        return this.mode;
    }

    public static <V> Focus<V> check(IFocus<V> focus) {
        if (focus instanceof Focus) {
            return (Focus)focus;
        }
        ErrorUtil.checkNotNull(focus, "focus");
        return new Focus<V>(focus.getMode(), focus.getValue());
    }

    @Nullable
    public static <V> Focus<V> checkNullable(@Nullable IFocus<V> focus) {
        if (focus == null) {
            return null;
        }
        return Focus.check(focus);
    }

    @Nullable
    public static <V> Focus<V> cast(@Nullable Focus<?> focus, IIngredientType<V> ingredientType) {
        Class<V> ingredientClass;
        if (focus != null && (ingredientClass = ingredientType.getIngredientClass()).isInstance(focus.getValue())) {
            return focus;
        }
        return null;
    }
}

