/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mezz.jei.config.IJEIConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModIdFormattingConfig
implements IJEIConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_NAME_FORMAT_CODE = "%MODNAME%";
    public static final String defaultModNameFormatFriendly = "blue italic";
    private String modNameFormatFriendly = "blue italic";
    public String modNameFormat = ModIdFormattingConfig.parseFriendlyModNameFormat("blue italic");
    @Nullable
    private String modNameFormatOverride;
    public final ForgeConfigSpec.ConfigValue<String> modNameFormatConfig;

    public ModIdFormattingConfig(ForgeConfigSpec.Builder builder) {
        builder.push("modname");
        builder.comment(new String[]{"Formatting for mod name tooltip", "Use these formatting keys:", "black, dark_blue, dark_green, dark_aqua, dark_red, dark_purple, gold, gray, dark_gray, blue, green, aqua, red, light_purple, yellow, white", "obfuscated, bold, strikethrough, underline, italic"});
        this.modNameFormatConfig = builder.define("ModNameFormat", (Object)defaultModNameFormatFriendly);
        builder.pop();
    }

    @Override
    public void reload() {
        this.modNameFormatFriendly = (String)this.modNameFormatConfig.get();
        this.updateModNameFormat();
    }

    public String getModNameFormat() {
        String override = this.modNameFormatOverride;
        if (override != null) {
            return override;
        }
        return this.modNameFormat;
    }

    public boolean isModNameFormatOverrideActive() {
        return this.modNameFormatOverride != null;
    }

    public void checkForModNameFormatOverride() {
        String modNameFormatOverride = ModIdFormattingConfig.detectModNameTooltipFormatting();
        if (!Objects.equals(this.modNameFormatOverride, modNameFormatOverride)) {
            this.modNameFormatOverride = modNameFormatOverride;
            this.updateModNameFormat();
        }
    }

    private void updateModNameFormat() {
        this.modNameFormat = ModIdFormattingConfig.parseFriendlyModNameFormat(this.modNameFormatFriendly);
    }

    private static String parseFriendlyModNameFormat(String formatWithEnumNames) {
        String[] strings;
        if (formatWithEnumNames.isEmpty()) {
            return "";
        }
        StringBuilder format = new StringBuilder();
        for (String string : strings = formatWithEnumNames.split(" ")) {
            TextFormatting valueByName = TextFormatting.func_96300_b((String)string);
            if (valueByName != null) {
                format.append(valueByName);
                continue;
            }
            LOGGER.error("Invalid format: {}", (Object)string);
        }
        return format.toString();
    }

    @Nullable
    private static String detectModNameTooltipFormatting() {
        try {
            ItemStack itemStack = new ItemStack((IItemProvider)Items.field_151034_e);
            Minecraft minecraft = Minecraft.func_71410_x();
            assert (minecraft != null);
            ClientPlayerEntity player = minecraft.field_71439_g;
            List tooltip = new ArrayList<StringTextComponent>();
            tooltip.add(new StringTextComponent("JEI Tooltip Testing for mod name formatting"));
            ItemTooltipEvent tooltipEvent = ForgeEventFactory.onItemTooltip((ItemStack)itemStack, (PlayerEntity)player, tooltip, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            tooltip = tooltipEvent.getToolTip();
            if (tooltip.size() > 1) {
                for (int lineNum = 1; lineNum < tooltip.size(); ++lineNum) {
                    String withoutFormatting;
                    ITextComponent line = (ITextComponent)tooltip.get(lineNum);
                    String lineString = line.getString();
                    if (!lineString.contains("Minecraft") || (withoutFormatting = TextFormatting.func_110646_a((String)lineString)) == null) continue;
                    if (lineString.equals(withoutFormatting)) {
                        return "";
                    }
                    if (!lineString.contains(withoutFormatting)) continue;
                    return StringUtils.replaceOnce((String)lineString, (String)"Minecraft", (String)MOD_NAME_FORMAT_CODE);
                }
            }
        }
        catch (LinkageError | RuntimeException e) {
            LOGGER.error("Error while Testing for mod name formatting", e);
        }
        return null;
    }
}

