/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import java.util.Optional;
import java.util.function.BiFunction;
import mezz.jei.config.ClientConfig;
import mezz.jei.config.IngredientFilterConfig;
import mezz.jei.config.ModIdFormattingConfig;
import mezz.jei.events.EventBusHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;

public class JEIClientConfig {
    private static final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    public static final ClientConfig clientConfig = new ClientConfig(builder);
    public static final IngredientFilterConfig filterConfig = new IngredientFilterConfig(builder);
    public static final ModIdFormattingConfig modNameFormat = new ModIdFormattingConfig(builder);
    private static final ForgeConfigSpec config = builder.build();

    public static void register(IEventBus modEventBus) {
        EventBusHelper.addListener(JEIClientConfig.class, modEventBus, ModConfig.ModConfigEvent.class, JEIClientConfig::reload);
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, config);
    }

    public static void reload(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getSpec() != config) {
            return;
        }
        clientConfig.reload();
        modNameFormat.reload();
    }

    public static void openSettings() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71439_g == null) {
            return;
        }
        ModContainer jeiContainer = (ModContainer)ModList.get().getModContainerById("jei").get();
        Optional configGuiFactory = jeiContainer.getCustomExtension(ExtensionPoint.CONFIGGUIFACTORY);
        if (configGuiFactory.isPresent()) {
            mc.func_147108_a((Screen)((BiFunction)configGuiFactory.get()).apply(mc, mc.field_71462_r));
        } else {
            ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/configured");
            Style style = Style.field_240709_b_.setUnderlined(Boolean.valueOf(true)).func_240715_a_(clickEvent);
            TranslationTextComponent textComponent = new TranslationTextComponent("jei.message.configured");
            IFormattableTextComponent message = textComponent.func_230530_a_(style);
            mc.field_71439_g.func_146105_b((ITextComponent)message, false);
        }
    }
}

