/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import journeymap.client.Constants;
import journeymap.client.properties.ClientCategory;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.DraggableListPane;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.ResetButton;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.client.ui.minimap.Selectable;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.OptionSlotFactory;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.common.properties.PropertiesBase;
import journeymap.common.properties.catagory.Category;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IReorderingProcessor;

public class MinimapOptions
extends JmUI {
    protected Button buttonClose;
    protected Map<Category, List<SlotMetadata>> toolbars;
    protected DraggableListPane<CategorySlot> minimapPositionPane;
    private final MiniMapProperties miniMapProperties;
    private final MiniMap minimap;
    private final journeymap.client.ui.minimap.Effect effect;
    private Selectable selected;
    private Selectable notSelected;
    private Map<Effect, EffectInstance> activeEffects;
    private Map<Category, PropertiesBase> slotMap = Maps.newHashMap();
    private static final Map<Effect, EffectInstance> FAKE_EFFECT_MAP;

    public MinimapOptions(Screen returnDisplay, MiniMapProperties miniMapProperties) {
        super(Constants.getString("jm.common.minimap_options.title"), returnDisplay);
        this.miniMapProperties = miniMapProperties;
        UIManager.INSTANCE.switchMiniMapPreset(miniMapProperties.getId());
        this.minimap = UIManager.INSTANCE.getMiniMap();
        this.slotMap.put(ClientCategory.MinimapPosition, miniMapProperties);
        this.activeEffects = Maps.newHashMap((Map)Minecraft.func_71410_x().field_71439_g.func_193076_bZ());
        Minecraft.func_71410_x().field_71439_g.func_193076_bZ().clear();
        this.effect = journeymap.client.ui.minimap.Effect.getInstance();
    }

    @Override
    public void func_231158_b_(Minecraft minecraft, int width, int height) {
        super.setRenderBottomBar(true);
        super.func_231158_b_(minecraft, width, height);
        ((Object)((Object)this)).getClass();
        this.minimapPositionPane = new DraggableListPane(this, this.field_230706_i_, 0, 0, 20, 35);
        List<CategorySlot> slotList = OptionSlotFactory.getOptionSlots(this.getToolbars(this.minimapPositionPane), this.slotMap, false, true);
        this.minimapPositionPane.setAlignTop(false);
        this.minimapPositionPane.func_244605_b(false);
        this.minimapPositionPane.func_244606_c(false);
        this.minimapPositionPane.setSlots(slotList);
        this.minimapPositionPane.updateSlots();
        this.buttonClose = (Button)this.func_230480_a_((Widget)new Button(Constants.getString("jm.common.close"), button -> this.closeAndReturn()));
        this.buttonClose.fitWidth(minecraft.field_71466_p);
        this.buttonClose.setX(minecraft.func_228018_at_().func_198107_o() / 2 - this.buttonClose.func_230998_h_() / 2);
        this.buttonClose.setY(minecraft.func_228018_at_().func_198087_p() - 25);
    }

    protected Map<Category, List<SlotMetadata>> getToolbars(ScrollListPane<CategorySlot> pane) {
        if (this.toolbars == null) {
            this.toolbars = new HashMap<Category, List<SlotMetadata>>();
            for (Category category : ClientCategory.values) {
                String name = Constants.getString("jm.config.reset");
                String tooltip = Constants.getString("jm.config.reset.tooltip");
                SlotMetadata toolbarSlotMetadata = new SlotMetadata(new ResetButton(category, button -> this.resetOptions(category, pane)), name, tooltip);
                this.toolbars.put(category, Arrays.asList(toolbarSlotMetadata));
            }
        }
        return this.toolbars;
    }

    protected void resetOptions(Category category, ScrollListPane<CategorySlot> pane) {
        HashSet<PropertiesBase> updatedProperties = new HashSet<PropertiesBase>();
        for (CategorySlot categorySlot : pane.getRootSlots()) {
            if (!category.equals(categorySlot.getCategory())) continue;
            for (SlotMetadata slotMetadata : categorySlot.getAllChildMetadata()) {
                slotMetadata.resetToDefaultValue();
                if (!slotMetadata.hasConfigField()) continue;
                PropertiesBase properties = slotMetadata.getProperties();
                if (properties instanceof MiniMapProperties) {
                    this.miniMapProperties.effectTranslateX.setToDefault();
                    this.miniMapProperties.effectTranslateY.setToDefault();
                    this.miniMapProperties.positionX.set(Float.valueOf(0.82f));
                    this.miniMapProperties.positionY.set(Float.valueOf(0.05f));
                }
                this.miniMapProperties.effectTranslateX.set((Object)0);
                if (properties == null) continue;
                updatedProperties.add(properties);
            }
        }
        for (PropertiesBase properties : updatedProperties) {
            properties.save();
        }
        this.minimapPositionPane.updateSlots();
    }

    @Override
    public void func_230430_a_(MatrixStack pStack, int x, int y, float partialTicks) {
        this.minimap.drawMap(pStack, true);
        this.renderEffectBox(pStack);
        List lastTooltip = this.minimapPositionPane.lastTooltip;
        long lastTooltipTime = this.minimapPositionPane.lastTooltipTime;
        this.minimapPositionPane.lastTooltip = null;
        this.minimapPositionPane.func_230430_a_(pStack, x, y, partialTicks);
        this.minimap.updateDisplayVars(true);
        super.func_230430_a_(pStack, x, y, partialTicks);
        this.renderTooltip(pStack, x, lastTooltipTime, lastTooltip);
        this.field_230706_i_.field_71439_g.func_193076_bZ().putAll(FAKE_EFFECT_MAP);
    }

    private void renderTooltip(MatrixStack pStack, int x, long lastTooltipTime, List<IReorderingProcessor> lastTooltip) {
        if (this.minimapPositionPane.lastTooltip != null && !this.minimapPositionPane.lastTooltip.equals(lastTooltip)) {
            this.minimapPositionPane.lastTooltipTime = lastTooltipTime;
            if (System.currentTimeMillis() - this.minimapPositionPane.lastTooltipTime > this.minimapPositionPane.hoverDelay) {
                Button button = this.minimapPositionPane.lastTooltipMetadata.getButton();
                this.func_238654_b_(pStack, this.minimapPositionPane.lastTooltip, x, button.getBottomY() + 15);
            }
        }
    }

    private void renderEffectBox(MatrixStack pStack) {
        if (this.selected != null && this.notSelected != null) {
            this.selected.renderBorder(pStack, -16711936);
            this.notSelected.renderBorder(pStack, -65536);
        } else {
            this.minimap.renderBorder(pStack, -65536);
            this.effect.renderBorder(pStack, -65536);
        }
        DrawUtil.zLevel = 0.0;
    }

    @Override
    protected void closeAndReturn() {
        this.removeTempEffects();
        super.closeAndReturn();
    }

    @Override
    public void close() {
        this.removeTempEffects();
        super.close();
    }

    public void func_231175_as__() {
        this.removeTempEffects();
        super.func_231175_as__();
    }

    private void removeTempEffects() {
        this.field_230706_i_.field_71439_g.func_193076_bZ().clear();
        this.field_230706_i_.field_71439_g.func_193076_bZ().putAll(this.activeEffects);
    }

    @Override
    protected void layoutButtons(MatrixStack mStack) {
        if (this.field_230710_m_.isEmpty()) {
            this.func_231160_c_();
        }
    }

    @Override
    public void func_230446_a_(MatrixStack mStack) {
    }

    public boolean func_231044_a_(double pMouseX, double pMouseY, int pButton) {
        if (this.minimapPositionPane.func_231044_a_(pMouseX, pMouseY, pButton)) {
            this.minimap.updateDisplayVars(true);
        } else {
            if (this.minimap.mouseClicked(pMouseX, pMouseY, pButton)) {
                this.selected = this.minimap;
                this.notSelected = this.effect;
                return true;
            }
            if (this.effect.mouseClicked(pMouseX, pMouseY, pButton)) {
                this.selected = this.effect;
                this.notSelected = this.minimap;
                return true;
            }
        }
        return super.func_231044_a_(pMouseX, pMouseY, pButton);
    }

    public boolean func_231043_a_(double x, double y, double scroll) {
        this.minimapPositionPane.func_231043_a_(x, y, scroll);
        return super.func_231043_a_(x, y, scroll);
    }

    public boolean func_231045_a_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (!this.minimapPositionPane.func_231045_a_(pMouseX, pMouseY, pButton, pDragX, pDragY) && this.selected != null && this.selected.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY)) {
            return true;
        }
        return super.func_231045_a_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    @Override
    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        this.minimapPositionPane.func_231048_c_(mouseX, mouseY, mouseButton);
        this.minimap.mouseReleased(mouseX, mouseY, mouseButton);
        this.effect.mouseReleased(mouseX, mouseY, mouseButton);
        return super.func_231048_c_(mouseX, mouseY, mouseButton);
    }

    public void func_231023_e_() {
        if (this.selected != null) {
            this.selected.tick();
        }
    }

    static {
        ArrayList fakeEffect = Lists.newArrayList((Object[])new EffectInstance[]{new EffectInstance(Effects.field_76431_k), new EffectInstance(Effects.field_76440_q), new EffectInstance(Effects.field_76436_u), new EffectInstance(Effects.field_76428_l), new EffectInstance(Effects.field_76429_m), new EffectInstance(Effects.field_76427_o), new EffectInstance(Effects.field_76441_p)});
        FAKE_EFFECT_MAP = fakeEffect.stream().collect(Collectors.toMap(EffectInstance::func_188419_a, e -> e));
    }
}

