/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.sync;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.registry.RegistryManager;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.api.accessors.CardSets;
import com.pixelmonmod.tcg.api.card.set.CardSet;
import com.pixelmonmod.tcg.api.util.helper.NetworkHelper;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SyncCardSetsPacket
extends AbstractTCGPacket {
    private List<CardSet> cardSets;

    public SyncCardSetsPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    private SyncCardSetsPacket(List<CardSet> cardSets) {
        this();
        this.cardSets = cardSets;
    }

    public static void sync(ServerPlayerEntity player) {
        List<CardSet> cardSets = CardSets.getAll();
        int groups = Math.max(1, cardSets.size() / 5);
        int size = cardSets.size() / groups;
        for (int group = 0; group < groups; ++group) {
            int i;
            ArrayList sublist = Lists.newArrayList();
            if (group + 1 == groups) {
                for (i = size * group; i < cardSets.size(); ++i) {
                    sublist.add(cardSets.get(i));
                }
            } else {
                for (i = size * group; i < size * (group + 1); ++i) {
                    sublist.add(cardSets.get(i));
                }
            }
            NetworkHelper.sendPacket(player, new SyncCardSetsPacket(sublist));
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.cardSets = Lists.newArrayList();
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            String json = buffer.func_218666_n() + buffer.func_218666_n();
            this.cardSets.add((CardSet)CardSets.GSON.fromJson(json, CardSet.class));
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.cardSets.size());
        for (CardSet cardSet : this.cardSets) {
            int length = cardSet.getJson().length() / 2;
            String firstHalf = cardSet.getJson().substring(0, length);
            String secondHalf = cardSet.getJson().substring(length);
            buffer.func_180714_a(firstHalf);
            buffer.func_180714_a(secondHalf);
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        RegistryManager.invalidateRegistry(CardSet.class);
        for (CardSet cardSet : this.cardSets) {
            CardSets.register(cardSet);
        }
    }
}

