/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.packets.battles;

import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class CardSelectorToServerPacket
extends AbstractTCGPacket {
    private BlockPos blockPos;
    private boolean isOpened;
    private boolean[] isSelected;

    public CardSelectorToServerPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public CardSelectorToServerPacket(BlockPos blockPos, boolean isOpened, boolean[] isSelected) {
        this();
        this.blockPos = blockPos;
        this.isOpened = isOpened;
        this.isSelected = isSelected;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.blockPos);
        buffer.writeBoolean(this.isOpened);
        buffer.writeBoolean(this.isSelected != null);
        if (this.isSelected != null) {
            buffer.writeInt(this.isSelected.length);
            for (boolean anIsSelected : this.isSelected) {
                buffer.writeBoolean(anIsSelected);
            }
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.blockPos = buffer.func_179259_c();
        this.isOpened = buffer.readBoolean();
        if (buffer.readBoolean()) {
            this.isSelected = new boolean[buffer.readInt()];
            for (int i = 0; i < this.isSelected.length; ++i) {
                this.isSelected[i] = buffer.readBoolean();
            }
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity e = context.getSender();
        ServerWorld w = e.func_71121_q();
        BattleOwnedTileEntityController b = (BattleOwnedTileEntityController)w.func_175625_s(this.blockPos);
        b.setCardSelection((PlayerEntity)e, this.isOpened, this.isSelected);
    }
}

