/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.trainer;

import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.util.helper.LogicHelper;
import com.pixelmonmod.tcg.api.util.helper.SelectorHelper;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.attack.enums.CoinSide;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import java.util.ArrayList;
import java.util.List;

public class PokeBall
extends BaseTrainerEffect {
    @Override
    public boolean canPlay(GameClientState client) {
        return true;
    }

    @Override
    public CardSelectorState getSelectorState(TrainerCardState trainer, GameServerState server) {
        if (server.getCoinFlip().getResults().get(0) == CoinSide.Head) {
            PlayerServerState me = server.getPlayer(server.getCurrentTurn());
            return SelectorHelper.generateSelectorForSelectPokemonFromDeck(me, 1, null);
        }
        return null;
    }

    @Override
    public CardSelectorState getOpponentRevealingSelectorState(TrainerCardState trainer, GameServerState server) {
        if (server.getCoinFlip().getResults().get(0) == CoinSide.Head && trainer.getParameters().size() > 0) {
            PlayerServerState me = server.getPlayer(server.getCurrentTurn());
            CardSelectorState selector = new CardSelectorState(0, 0, CardSelectorDisplay.Reveal, false);
            selector.getCardList().add(new CardWithLocation(trainer.getParameters().get(0), true, BoardLocation.Deck, 0));
            return selector;
        }
        return null;
    }

    @Override
    public List<CoinSide> flipCoin() {
        ArrayList<CoinSide> result = new ArrayList<CoinSide>();
        result.add(CoinSide.getRandom());
        return result;
    }

    @Override
    public boolean canApply(TrainerCardState trainer, GameServerState server) {
        return server.getCoinFlip().getResults().get(0) == CoinSide.Tail || trainer.getParameters().size() == 1;
    }

    @Override
    public void apply(TrainerCardState trainer, GameServerState server) {
        if (server.getCoinFlip().getResults().get(0) == CoinSide.Head) {
            ImmutableCard card = trainer.getParameters().get(0).getData();
            PlayerServerState me = server.getPlayer(server.getCurrentTurn());
            me.getDeck().remove(card);
            me.getHand().add(card);
            LogicHelper.shuffleCardList(me.getDeck());
        }
    }

    @Override
    public boolean canSkipSelector() {
        return false;
    }

    @Override
    public void applySkipSelector(TrainerCardState trainer, PokemonCardState pokemon, GameServerState server, BoardLocation b, int p) {
    }
}

