/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.power;

import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.power.BasePowerEffect;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;

public class SpecialDelivery
extends BasePowerEffect {
    public SpecialDelivery() {
        super("SpecialDelivery");
    }

    @Override
    public boolean isEnabled(PokemonCardState pokemon, GameClientState client) {
        if (!super.isEnabled(pokemon, client)) {
            return false;
        }
        if (client.getMe().getDeckSize() < 1) {
            return false;
        }
        return pokemon.getParameters().isEmpty();
    }

    @Override
    public CardSelectorState getSelectorState(PokemonCardState pokemon, GameServerState server) {
        PlayerServerState player = server.getPlayer(server.getCurrentTurn());
        if (pokemon.getParameters().isEmpty()) {
            player.drawCards(1, server);
            CardSelectorState selector = new CardSelectorState(1, 1, CardSelectorDisplay.Discard, false, "power.specialdelivery.selector.discard");
            for (int i = 0; i < player.getHand().size(); ++i) {
                ImmutableCard card = player.getHand().get(i);
                selector.getCardList().add(new CardWithLocation(new CommonCardState(card), true, BoardLocation.Hand, i));
            }
            return selector;
        }
        return null;
    }

    @Override
    public boolean canActivate(PokemonCardState pokemon, GameServerState client) {
        return pokemon.getParameters().size() == 1;
    }

    @Override
    public void activate(PokemonCardState pokemon, GameServerState server, PlayerServerState player) {
        CommonCardState placeOnDeck = pokemon.getParameters().get(0);
        player.getDeck().add(0, placeOnDeck.getData());
        player.getHand().remove(placeOnDeck.getData());
    }

    @Override
    public void cleanUp(PokemonCardState pokemon, GameServerState server) {
    }
}

