/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.power;

import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.attack.enums.CoinSide;
import com.pixelmonmod.tcg.duel.power.BasePowerEffect;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import java.util.ArrayList;
import java.util.List;

public class Heal
extends BasePowerEffect {
    public Heal() {
        super("Heal");
    }

    @Override
    public boolean isEnabled(PokemonCardState pokemon, GameClientState client) {
        return super.isEnabled(pokemon, client) && pokemon.getParameters().isEmpty() && client.getMe().getActiveAndBenchCards().stream().anyMatch(c -> c.getStatus().getDamage() > 0);
    }

    @Override
    public List<CoinSide> flipCoin() {
        ArrayList<CoinSide> coins = new ArrayList<CoinSide>();
        coins.add(CoinSide.getRandom());
        return coins;
    }

    @Override
    public CardSelectorState getSelectorState(PokemonCardState pokemon, GameServerState server) {
        if (this.isCorrectCoinSide(server)) {
            PlayerServerState player = server.getPlayer(server.getCurrentTurn());
            CardSelectorState selector = new CardSelectorState(1, 1, CardSelectorDisplay.Select, false, "power.heal.selector.pokemon");
            player.getActiveAndBenchCards(true).stream().filter(location -> ((PokemonCardState)location.getCard()).getStatus().getDamage() > 0).forEach(location -> selector.getCardList().add((CardWithLocation)location));
            return selector;
        }
        return null;
    }

    @Override
    public boolean canActivate(PokemonCardState pokemon, GameServerState server) {
        return !this.isCorrectCoinSide(server) || !pokemon.getParameters().isEmpty();
    }

    @Override
    public void activate(PokemonCardState pokemon, GameServerState server, PlayerServerState player) {
        if (this.isCorrectCoinSide(server)) {
            PokemonCardState heal = (PokemonCardState)pokemon.getParameters().get(0);
            heal.getStatus().healDamage(10);
        }
        pokemon.getParameters().add(pokemon);
    }

    @Override
    public void cleanUp(PokemonCardState pokemon, GameServerState server) {
    }

    private boolean isCorrectCoinSide(GameServerState server) {
        return server.getCoinFlip() != null && server.getCoinFlip().getResults().get(0) == CoinSide.Head;
    }
}

