/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.power;

import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.power.BasePowerEffect;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import java.util.Objects;

public class Curse
extends BasePowerEffect {
    public Curse() {
        super("Curse");
    }

    @Override
    public boolean isEnabled(PokemonCardState pokemon, GameClientState client) {
        return super.isEnabled(pokemon, client) && this.isAnyOpponentCardDamaged(client);
    }

    private boolean isAnyOpponentCardDamaged(GameClientState client) {
        if (client.getOpponent().getActiveAndBenchCards().size() == 1) {
            return false;
        }
        for (PokemonCardState activeAndBenchCard : client.getOpponent().getActiveAndBenchCards()) {
            if (activeAndBenchCard.getStatus().getDamage() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public CardSelectorState getSelectorState(PokemonCardState pokemon, GameServerState server) {
        PlayerServerState player = server.getCurrentOpponent();
        switch (pokemon.getParameters().size()) {
            case 0: {
                CardSelectorState selector = new CardSelectorState(1, 1, CardSelectorDisplay.Select, true, "power.damageswap.selector.from");
                for (CardWithLocation activeAndBenchCard : player.getActiveAndBenchCards(false)) {
                    if (!(activeAndBenchCard.getCard() instanceof PokemonCardState) || ((PokemonCardState)activeAndBenchCard.getCard()).getStatus().getDamage() <= 0) continue;
                    selector.addCard(activeAndBenchCard);
                }
                return selector;
            }
            case 1: {
                PokemonCardState fromPokemon = (PokemonCardState)pokemon.getParameters().get(0);
                CardSelectorState selector = new CardSelectorState(1, 1, CardSelectorDisplay.Select, true, "power.damageswap.selector.to");
                for (CardWithLocation activeAndBenchCard : player.getActiveAndBenchCards(false)) {
                    if (Objects.equals(fromPokemon, activeAndBenchCard.getCard())) continue;
                    selector.addCard(activeAndBenchCard);
                }
                return selector;
            }
        }
        return null;
    }

    @Override
    public boolean canActivate(PokemonCardState pokemon, GameServerState server) {
        return pokemon.getParameters().size() == 2;
    }

    @Override
    public void activate(PokemonCardState pokemon, GameServerState server, PlayerServerState player) {
        PokemonCardState fromPokemon = (PokemonCardState)pokemon.getParameters().get(0);
        PokemonCardState toPokemon = (PokemonCardState)pokemon.getParameters().get(1);
        fromPokemon.getStatus().healDamage(10);
        toPokemon.getStatus().setDamage(toPokemon.getStatus().getDamage() + 10);
    }
}

