/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.attack.effects;

import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.api.util.helper.SelectorHelper;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ProphecyEffect
extends BaseAttackEffect {
    private static final String CODE = "PROPHECY";
    private int count;

    public ProphecyEffect() {
        super(CODE);
    }

    @Override
    public CardSelectorState getSelectorState(List<Object> parameters, GameServerState server) {
        if (parameters.size() == 0) {
            PlayerServerState me = server.getPlayer(server.getCurrentTurn());
            PlayerServerState opp = server.getPlayer(server.getNextTurn());
            return SelectorHelper.generateSelectorForPlayer(me, opp, "Choose a player");
        }
        if (parameters.size() >= 1) {
            int i;
            PlayerServerState player = server.getPlayer(server.getCurrentTurn());
            CommonCardState playerChoice = (CommonCardState)parameters.get(0);
            if (player.getActiveCard() != playerChoice) {
                player = server.getPlayer(server.getNextTurn());
            }
            int count = Math.min(this.count, player.getDeck().size());
            int skip = parameters.size() - 1;
            ArrayList<CommonCardState> top = new ArrayList<CommonCardState>();
            for (i = 0; i < count; ++i) {
                top.add(new CommonCardState(player.getDeck().get(i)));
            }
            for (i = 0; i < parameters.size(); ++i) {
                if (i == 0) continue;
                CommonCardState selected = (CommonCardState)parameters.get(i);
                CommonCardState match = top.stream().filter(c -> c.getData() == selected.getData()).findFirst().get();
                top.remove(match);
            }
            CardSelectorState selector = new CardSelectorState(1, 1, CardSelectorDisplay.Select, false, "trainer.pokedex.selector." + Integer.toString(skip + 1));
            selector.getCardList().addAll(top.stream().map(c -> new CardWithLocation((CommonCardState)c, true, BoardLocation.Deck, 0)).collect(Collectors.toList()));
            return selector;
        }
        return null;
    }

    @Override
    public boolean canApply(List<Object> parameters, CardAttack cardAttack, GameServerState server) {
        return parameters.size() - 1 == Math.min(this.count, server.getPlayer(server.getCurrentTurn()).getDeck().size());
    }

    @Override
    public void applyBeforeDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server) {
        PlayerServerState player = server.getPlayer(server.getCurrentTurn());
        PokemonCardState playerChoice = (PokemonCardState)parameters.get(0);
        if (player.getActiveCard() != playerChoice) {
            player = server.getPlayer(server.getNextTurn());
        }
        List<Object> tempParameters = parameters;
        tempParameters.remove(0);
        int index = 0;
        for (Object cardObject : parameters) {
            CommonCardState cardData = (CommonCardState)cardObject;
            player.getDeck().remove(index);
            player.getDeck().add(index, cardData.getData());
            ++index;
        }
    }

    @Override
    public BaseAttackEffect parse(String ... args) {
        this.count = Integer.parseInt(args[1]);
        return super.parse(args);
    }
}

