/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.attack.effects;

import com.pixelmonmod.tcg.api.card.CardCondition;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import com.pixelmonmod.tcg.duel.log.DuelLogItem;
import com.pixelmonmod.tcg.duel.log.DuelLogType;
import com.pixelmonmod.tcg.duel.log.parameters.DuelLogAttackParameters;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class MirrorMoveEffect
extends BaseAttackEffect {
    private static final String CODE = "MIRRORMOVE";

    public MirrorMoveEffect() {
        super(CODE);
    }

    @Override
    public void applyBeforeDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server) {
        DuelLogAttackParameters params;
        List logs = server.getLog().getItems().stream().filter(item -> item.getTurn() == server.getTurnCount() - 1 && item.getType() == DuelLogType.ATTACK).collect(Collectors.toList());
        if (!logs.isEmpty() && (params = ((DuelLogItem)logs.get(0)).getAttackParameters()).getAttacking() == card) {
            PlayerServerState opp = server.getPlayer(server.getNextTurn());
            opp.getActiveCard().addDamage(card, params.getDamage(), server);
            for (Pair<CardCondition, Integer> pair : params.getConditions()) {
                opp.getActiveCard().addCondition(card, (CardCondition)((Object)pair.getLeft()), (Integer)pair.getRight(), server);
            }
        }
    }
}

