/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.attack.effects;

import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffectWithOptionalFlip;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import java.util.List;
import java.util.stream.Collectors;

public class DiscardAttachmentEffect
extends BaseAttackEffectWithOptionalFlip {
    private static final String[] CODES = new String[]{"SELF_DISCARD", "OPP_DISCARD"};
    public static final int ALL_COUNT = -1;
    private boolean onMe;
    private Energy energy;
    private int count;

    public DiscardAttachmentEffect() {
        super(CODES);
    }

    @Override
    public CardSelectorState getSelectorState(List<Object> parameters, GameServerState server) {
        if (this.energy == null && this.count != -1) {
            List<CommonCardState> energyCards = this.getEnergyCards(server);
            int realCount = Math.min(this.count, energyCards.size());
            if (realCount == 0) {
                return null;
            }
            CardSelectorState selector = new CardSelectorState(realCount, realCount, CardSelectorDisplay.Discard, false);
            for (CommonCardState card : energyCards) {
                selector.getCardList().add(new CardWithLocation(card, this.onMe, BoardLocation.Attachment, 0));
            }
            return selector;
        }
        return null;
    }

    @Override
    public boolean canApply(List<Object> parameters, CardAttack cardAttack, GameServerState server) {
        if (this.energy == null && this.count != -1) {
            List<CommonCardState> energyCards = this.getEnergyCards(server);
            if (energyCards.isEmpty()) {
                return true;
            }
            return parameters.size() == Math.min(energyCards.size(), this.count);
        }
        return true;
    }

    @Override
    public void applyOnCorrectCoinSideBeforeDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server) {
        block6: {
            CommonCardState attachment;
            int i;
            int discardCount;
            int totalCount;
            PokemonCardState applyingCard;
            PlayerServerState applyingPlayer;
            block7: {
                applyingPlayer = this.onMe ? server.getPlayer(server.getCurrentTurn()) : server.getPlayer(server.getNextTurn());
                applyingCard = applyingPlayer.getActiveCard();
                List<CommonCardState> energyCards = this.getEnergyCards(server);
                if (energyCards.isEmpty()) {
                    return;
                }
                totalCount = Math.min(this.count, energyCards.size());
                discardCount = 0;
                if (this.energy != null || this.count == -1) break block7;
                for (Object parameter : parameters) {
                    CommonCardState attachment2 = (CommonCardState)parameter;
                    applyingCard.getAttachments().remove(attachment2);
                    applyingPlayer.getDiscardPile().add(attachment2.getData());
                }
                break block6;
            }
            for (i = 0; i < applyingCard.getAttachments().size(); ++i) {
                attachment = applyingCard.getAttachments().get(i);
                if (attachment.getCardType() != CardType.ENERGY || attachment.getMainEnergy() != this.energy) continue;
                applyingCard.getAttachments().remove(i);
                applyingPlayer.getDiscardPile().add(attachment.getData());
                --i;
                if (++discardCount == totalCount) break;
            }
            if (discardCount >= totalCount) break block6;
            for (i = 0; i < applyingCard.getAttachments().size(); ++i) {
                attachment = applyingCard.getAttachments().get(i);
                if (attachment.getAbility() == null || attachment.getAbility().getEffect() == null) continue;
                List<CommonCardState> equivalence = attachment.getAbility().getEffect().getEnergyEquivalence(attachment);
                List matched = equivalence.stream().filter(c -> c.getMainEnergy() == this.energy).collect(Collectors.toList());
                if (!matched.isEmpty()) {
                    applyingCard.getAttachments().remove(i);
                    applyingPlayer.getDiscardPile().add(attachment.getData());
                    --i;
                    discardCount += matched.size();
                }
                if (discardCount < totalCount) {
                    continue;
                }
                break;
            }
        }
    }

    private List<CommonCardState> getEnergyCards(GameServerState server) {
        PlayerServerState player = this.onMe ? server.getPlayer(server.getCurrentTurn()) : server.getPlayer(server.getNextTurn());
        return player.getActiveCard().getAttachments().stream().filter(c -> c.isEnergyEquivalence()).collect(Collectors.toList());
    }

    @Override
    public BaseAttackEffect parse(String ... args) {
        String[] types = args[0].split("_");
        this.onMe = types[0].equalsIgnoreCase("SELF");
        this.count = -1;
        this.energy = Energy.getEnergyFromString(args[1]);
        if (!args[2].equalsIgnoreCase("ALL") && !args[2].equalsIgnoreCase("*")) {
            this.count = Integer.parseInt(args[2]);
        }
        return super.parse(args);
    }
}

