/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.attack.effects;

import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import com.pixelmonmod.tcg.duel.attack.enums.DamageBonusType;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DamageBonusEffect
extends BaseAttackEffect {
    private static final String[] CODES = new String[]{"DAMAGE_BONUS"};
    private boolean conditionOnMe;
    private DamageBonusType type;
    private Energy energy;
    private int pokedexNumber;
    private int value;
    private Integer maximumBonus;
    private boolean ignoreBaseDamage;

    public DamageBonusEffect() {
        super(CODES);
    }

    @Override
    public void applyBeforeDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server) {
        PlayerServerState player = server.getPlayer(server.getCurrentTurn());
        PlayerServerState opp = server.getPlayer(server.getNextTurn());
        PokemonCardState active = this.conditionOnMe ? player.getActiveCard() : opp.getActiveCard();
        int count = 0;
        switch (this.type) {
            case PerBench: {
                PokemonCardState[] bench;
                for (PokemonCardState benchCard : bench = this.conditionOnMe ? player.getBenchCards() : opp.getBenchCards()) {
                    if (benchCard == null) continue;
                    ++count;
                }
                break;
            }
            case PerDamage: {
                count = active.getStatus().getDamage() / 10;
                break;
            }
            case PerPokemon: {
                count = (int)(this.conditionOnMe ? player : opp).getActiveAndBenchCards().stream().filter(c -> c.getPokemonID() == this.pokedexNumber).count();
                break;
            }
            case PerEnergy: {
                List energyCards = active.getAttachments().stream().filter(CommonCardState::isEnergyEquivalence).collect(Collectors.toList());
                for (CommonCardState energyCard : energyCards) {
                    List<CommonCardState> equi;
                    ArrayList<Energy> energies = new ArrayList<Energy>();
                    if (energyCard.getCardType() == CardType.ENERGY) {
                        energies.add(energyCard.getMainEnergy());
                        if (energyCard.getSecondaryEnergy() != null) {
                            energies.add(energyCard.getSecondaryEnergy());
                        }
                    } else if (energyCard.getAbility() != null && energyCard.getAbility().getEffect() != null && (equi = energyCard.getAbility().getEffect().getEnergyEquivalence(active)) != null) {
                        for (CommonCardState equiEnergy : equi) {
                            energies.add(equiEnergy.getMainEnergy());
                        }
                    }
                    for (Energy energy : energies) {
                        if (this.energy != null && energy != this.energy) continue;
                        ++count;
                    }
                }
                if (!this.conditionOnMe) break;
                for (Energy costEnergy : attack.getData().getCosts()) {
                    if (this.energy != null && costEnergy != this.energy && costEnergy != Energy.COLORLESS) continue;
                    --count;
                }
                break;
            }
        }
        int damage = this.ignoreBaseDamage ? 0 : attack.getDamage();
        int bonus = count * this.value;
        if (this.maximumBonus != null && bonus > this.maximumBonus) {
            bonus = this.maximumBonus;
        }
        attack.setDamage(damage + bonus);
    }

    @Override
    public BaseAttackEffect parse(String ... args) {
        this.conditionOnMe = args[1].equalsIgnoreCase("SELF");
        int index = 2;
        if (args[index].equalsIgnoreCase("PER_DAMAGE")) {
            this.type = DamageBonusType.PerDamage;
            ++index;
        } else if (args[index].equalsIgnoreCase("PER_BENCH")) {
            this.type = DamageBonusType.PerBench;
            ++index;
        } else if (args[index].equalsIgnoreCase("PER_ENERGY")) {
            this.type = DamageBonusType.PerEnergy;
            ++index;
        } else if (args[index].equalsIgnoreCase("PER_POKEMON")) {
            this.type = DamageBonusType.PerPokemon;
            ++index;
        } else {
            this.type = DamageBonusType.PerEnergy;
        }
        if (this.type == DamageBonusType.PerEnergy) {
            this.energy = Energy.getEnergyFromString(args[index++]);
        } else if (this.type == DamageBonusType.PerPokemon) {
            this.pokedexNumber = Integer.parseInt(args[index++]);
        }
        if (args[index].startsWith("*") || args[index].startsWith("x")) {
            this.ignoreBaseDamage = true;
            args[index] = args[index].substring(1);
        }
        this.value = Integer.parseInt(args[index++]);
        this.maximumBonus = args.length == index + 1 ? Integer.valueOf(Integer.parseInt(args[index])) : null;
        return super.parse(args);
    }
}

