/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.tcg.duel.BufferBuilderWrapper;
import com.pixelmonmod.tcg.duel.BufferSupplier;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;

public class RenderingTCG {
    private static ResourceLocation CURRENT_TEXTURE = null;
    private static final BufferSupplier GUI_BUFFER;
    private static BufferSupplier CURRENT_BUFFER;

    public static void setBuffer(BufferSupplier supplier) {
        CURRENT_BUFFER = supplier;
    }

    public static void setBufferForScreenRendering() {
        RenderingTCG.setBuffer(GUI_BUFFER);
    }

    public static void setBufferForWorldRendering(IRenderTypeBuffer buffer) {
        RenderingTCG.setBuffer(() -> new BufferBuilderWrapper((BufferBuilder)buffer.getBuffer(PixelmonRendering.getQuadTextureUVRenderType(RenderingTCG.getCurrentTexture()))));
    }

    public static void bind(ResourceLocation texture) {
        CURRENT_TEXTURE = texture;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
    }

    public static ResourceLocation getCurrentTexture() {
        if (CURRENT_TEXTURE == null) {
            throw new NullPointerException("No texture bound in TCG rendering pipeline!");
        }
        return CURRENT_TEXTURE;
    }

    public static Tessellator tessellator() {
        return Tessellator.func_178181_a();
    }

    public static BufferBuilder buffer() {
        return RenderingTCG.tessellator().func_178180_c();
    }

    public static void draw(int mode, VertexFormat format, MatrixStack matrix, Consumer<BufferBuilderWrapper> buffer) {
        BufferBuilderWrapper builder = CURRENT_BUFFER.get();
        builder.begin(mode, format, matrix);
        buffer.accept(builder);
        CURRENT_BUFFER.finish();
    }

    public static void draw(ResourceLocation texture, int mode, VertexFormat format, MatrixStack matrix, Consumer<BufferBuilderWrapper> buffer) {
        RenderingTCG.bind(texture);
        RenderingTCG.draw(mode, format, matrix, buffer);
    }

    public static void vertex(BufferBuilderWrapper builder, Matrix4f mat, double x, double y, double z, float a, float u, float v) {
        RenderingTCG.vertex(builder.get(), mat, (float)x, (float)y, (float)z, 1.0f, 1.0f, 1.0f, a, u, v, 0xF000F0);
    }

    public static void vertex(BufferBuilderWrapper builder, Matrix4f mat, double x, double y, double z, float u, float v) {
        RenderingTCG.vertex(builder.get(), mat, (float)x, (float)y, (float)z, 1.0f, 1.0f, 1.0f, 1.0f, u, v, 0xF000F0);
    }

    public static void vertex(BufferBuilderWrapper builder, Matrix4f mat, float x, float y, float z, float a, float u, float v) {
        RenderingTCG.vertex(builder.get(), mat, x, y, z, 1.0f, 1.0f, 1.0f, a, u, v, 0xF000F0);
    }

    public static void vertex(BufferBuilderWrapper builder, Matrix4f mat, float x, float y, float z, float u, float v) {
        RenderingTCG.vertex(builder.get(), mat, x, y, z, 1.0f, 1.0f, 1.0f, 1.0f, u, v, 0xF000F0);
    }

    public static void vertex(BufferBuilderWrapper builder, Matrix4f mat, float x, float y, float z, float r, float g, float b, float a, float u, float v, int light) {
        builder.get().func_227888_a_(mat, x, y, z).func_227885_a_(r, g, b, a).func_225583_a_(u, v).func_227886_a_(light).func_181675_d();
    }

    public static void vertex(BufferBuilder builder, Matrix4f mat, double x, double y, double z, float a, float u, float v) {
        RenderingTCG.vertex(builder, mat, (float)x, (float)y, (float)z, 1.0f, 1.0f, 1.0f, a, u, v, 0xF000F0);
    }

    public static void vertex(BufferBuilder builder, Matrix4f mat, double x, double y, double z, float u, float v) {
        RenderingTCG.vertex(builder, mat, (float)x, (float)y, (float)z, 1.0f, 1.0f, 1.0f, 1.0f, u, v, 0xF000F0);
    }

    public static void vertex(BufferBuilder builder, Matrix4f mat, float x, float y, float z, float a, float u, float v) {
        RenderingTCG.vertex(builder, mat, x, y, z, 1.0f, 1.0f, 1.0f, a, u, v, 0xF000F0);
    }

    public static void vertex(BufferBuilder builder, Matrix4f mat, float x, float y, float z, float u, float v) {
        RenderingTCG.vertex(builder, mat, x, y, z, 1.0f, 1.0f, 1.0f, 1.0f, u, v, 0xF000F0);
    }

    public static void vertex(BufferBuilder builder, Matrix4f mat, float x, float y, float z, float r, float g, float b, float a, float u, float v, int light) {
        builder.func_227888_a_(mat, x, y, z).func_227885_a_(r, g, b, a).func_225583_a_(u, v).func_181675_d();
    }

    static {
        CURRENT_BUFFER = GUI_BUFFER = new BufferSupplier(){

            @Override
            public BufferBuilderWrapper get() {
                return new BufferBuilderWrapper(RenderingTCG.buffer());
            }

            @Override
            public void finish() {
                RenderingTCG.tessellator().func_78381_a();
            }
        };
    }
}

