/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.PixelmonRenderer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.tcg.api.card.CardCondition;
import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.client.gui.duel.TCGScreen;
import com.pixelmonmod.tcg.duel.RenderCard;
import com.pixelmonmod.tcg.duel.RenderingTCG;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GamePhase;
import com.pixelmonmod.tcg.duel.state.PlayerClientOpponentState;
import com.pixelmonmod.tcg.duel.state.PlayerCommonState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.RenderState;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import java.util.List;
import java.util.OptionalDouble;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

public class RenderDuel {
    private static final int DEFAULT_LINE_WIDTH = 2;
    public static final RenderType LINES = RenderType.func_228632_a_((String)"lines22", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228720_a_(new RenderState.LineState(OptionalDouble.of(2.0))).func_228718_a_(RenderType.field_239235_M_).func_228726_a_(RenderType.field_228515_g_).func_228721_a_(RenderType.field_241712_U_).func_228727_a_(RenderType.field_228495_E_).func_228728_a_(false));
    private static final PixelmonEntity[] activePokemons = new PixelmonEntity[2];
    private static float prevPartialTicks = 1.0f;
    private static float partialTicksCompare = 1.0f;
    private static boolean newTick = false;

    @OnlyIn(value=Dist.CLIENT)
    public static void drawStraightLine(MatrixStack matrixStack, IRenderTypeBuffer buffer, float fromX, float fromY, float fromZ, float toX, float toY, float toZ, int r, int g, int b, float w) {
        matrixStack.func_227860_a_();
        Matrix4f mat = matrixStack.func_227866_c_().func_227870_a_();
        IVertexBuilder buffer1 = buffer.getBuffer(LINES);
        buffer1.func_227888_a_(mat, fromX, fromY, fromZ).func_225586_a_(r, g, b, 255).func_181675_d();
        buffer1.func_227888_a_(mat, toX, toY, toZ).func_225586_a_(r, g, b, 255).func_181675_d();
        matrixStack.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void draw2DLine(MatrixStack matrix, double fromX, double fromY, double toX, double toY, float r, float g, float b, float w) {
        RenderDuel.draw2DLine(matrix, fromX, fromY, toX, toY, r, g, b, 1.0f, w);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void draw2DLine(MatrixStack matrix, double fromX, double fromY, double toX, double toY, float r, float g, float b, float a, float w) {
        Tessellator tessellator = Tessellator.func_178181_a();
        matrix.func_227860_a_();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.depthMask((boolean)false);
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        Vector3d view = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        matrix.func_227861_a_(-view.field_72450_a, -view.field_72448_b, -view.field_72449_c);
        BufferBuilder builder = tessellator.func_178180_c();
        Matrix4f mat = matrix.func_227866_c_().func_227870_a_();
        RenderSystem.lineWidth((float)w);
        builder.func_181668_a(3, DefaultVertexFormats.field_227850_m_);
        builder.func_227888_a_(mat, (float)fromX, (float)fromY, 0.0f).func_227885_a_(r, g, b, a).func_227886_a_(0xF000F0).func_181675_d();
        builder.func_227888_a_(mat, (float)toX, (float)toY, 0.0f).func_227885_a_(r, g, b, a).func_227886_a_(0xF000F0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)2848);
        RenderSystem.enableTexture();
        RenderSystem.lineWidth((float)2.0f);
        matrix.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void draw2DRectangle(MatrixStack matrix, double x1, double x2, double y1, double y2, float r, float g, float b, float a) {
        Tessellator tessellator = Tessellator.func_178181_a();
        matrix.func_227860_a_();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.depthMask((boolean)false);
        Vector3d view = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        matrix.func_227861_a_(-view.field_72450_a, -view.field_72448_b, -view.field_72449_c);
        BufferBuilder builder = tessellator.func_178180_c();
        Matrix4f mat = matrix.func_227866_c_().func_227870_a_();
        builder.func_181668_a(7, DefaultVertexFormats.field_227850_m_);
        builder.func_227888_a_(mat, (float)x1, (float)y1, 0.0f).func_227885_a_(r, g, b, a).func_227886_a_(0xF000F0).func_181675_d();
        builder.func_227888_a_(mat, (float)x1, (float)y2, 0.0f).func_227885_a_(r, g, b, a).func_227886_a_(0xF000F0).func_181675_d();
        builder.func_227888_a_(mat, (float)x2, (float)y2, 0.0f).func_227885_a_(r, g, b, a).func_227886_a_(0xF000F0).func_181675_d();
        builder.func_227888_a_(mat, (float)x2, (float)y1, 0.0f).func_227885_a_(r, g, b, a).func_227886_a_(0xF000F0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)2848);
        RenderSystem.enableTexture();
        RenderSystem.lineWidth((float)2.0f);
        matrix.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawCardOutline(MatrixStack matrix, IRenderTypeBuffer buffer, float x, float y, float z, boolean isHorizontal, int r, int g, int b) {
        matrix.func_227860_a_();
        y += 0.01f;
        if (isHorizontal) {
            RenderDuel.drawStraightLine(matrix, buffer, x, y, z, x, y, z - 2.0f, r, g, b, 2.0f);
            RenderDuel.drawStraightLine(matrix, buffer, x, y, z, x + 1.5f, y, z, r, g, b, 2.0f);
            RenderDuel.drawStraightLine(matrix, buffer, x + 1.5f, y, z, x + 1.5f, y, z - 2.0f, r, g, b, 2.0f);
            RenderDuel.drawStraightLine(matrix, buffer, x, y, z - 2.0f, x + 1.5f, y, z - 2.0f, r, g, b, 2.0f);
        } else {
            RenderDuel.drawStraightLine(matrix, buffer, x, y, z, x, y, z - 1.5f, r, g, b, 2.0f);
            RenderDuel.drawStraightLine(matrix, buffer, x, y, z, x + 2.0f, y, z, r, g, b, 2.0f);
            RenderDuel.drawStraightLine(matrix, buffer, x + 2.0f, y, z, x + 2.0f, y, z - 1.5f, r, g, b, 2.0f);
            RenderDuel.drawStraightLine(matrix, buffer, x, y, z - 1.5f, x + 2.0f, y, z - 1.5f, r, g, b, 2.0f);
        }
        matrix.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawPrizeOutline(MatrixStack matrixStack, IRenderTypeBuffer buffer, float x, float y, float z, int r, int g, int b) {
        RenderDuel.drawStraightLine(matrixStack, buffer, x, y += 0.01f, z, x, y, z - 1.5f, r, g, b, 2.0f);
        RenderDuel.drawStraightLine(matrixStack, buffer, x, y, z, x + 1.125f, y, z, r, g, b, 2.0f);
        RenderDuel.drawStraightLine(matrixStack, buffer, x + 1.125f, y, z, x + 1.125f, y, z - 1.5f, r, g, b, 2.0f);
        RenderDuel.drawStraightLine(matrixStack, buffer, x, y, z - 1.5f, x + 1.125f, y, z - 1.5f, r, g, b, 2.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawBoardOutline(MatrixStack matrix, IRenderTypeBuffer buffer, BattleOwnedTileEntityController controller, float x, float y, float z, float partialTicks) {
        int i;
        if (controller.getRender() == null) {
            return;
        }
        if (partialTicks < prevPartialTicks) {
            partialTicksCompare = partialTicks;
            newTick = true;
        }
        if (partialTicksCompare != partialTicks) {
            newTick = false;
        }
        prevPartialTicks = partialTicks;
        RenderingTCG.setBufferForWorldRendering(buffer);
        FontRenderer f = Minecraft.func_71410_x().field_71466_p;
        matrix.func_227860_a_();
        matrix.func_227862_a_(controller.getScale(), controller.getScale(), controller.getScale());
        RenderState render = controller.getRender();
        y += 0.01f;
        int r = 255;
        int g = 255;
        int b = 255;
        if (controller.isShadowGame()) {
            r = 103;
            g = 0;
            b = 168;
        }
        RenderDuel.drawStraightLine(matrix, buffer, -7.0f, 0.0f, 0.0f, 8.0f, 0.0f, 0.0f, r, g, b, 2.0f);
        RenderDuel.drawStraightLine(matrix, buffer, -7.0f, 0.0f, 0.0f, -7.0f, 0.0f, -10.5f, r, g, b, 2.0f);
        RenderDuel.drawStraightLine(matrix, buffer, -7.0f, 0.0f, -10.5f, 8.0f, 0.0f, -10.5f, r, g, b, 2.0f);
        RenderDuel.drawStraightLine(matrix, buffer, 8.0f, 0.0f, -10.5f, 8.0f, 0.0f, 0.0f, r, g, b, 2.0f);
        RenderDuel.drawStraightLine(matrix, buffer, 0.5f, 0.0f, -10.5f, 0.5f, 0.0f, -9.5f, r, g, b, 2.0f);
        RenderDuel.drawStraightLine(matrix, buffer, 0.5f, 0.0f, 0.0f, 0.5f, 0.0f, -7.5f, r, g, b, 2.0f);
        y -= 0.01f;
        for (i = 0; i < 5; ++i) {
            RenderDuel.drawCardOutline(matrix, buffer, -6.5f, 0.0f, -0.5f - (float)(i * 2), false, r, g, b);
            RenderDuel.drawCardOutline(matrix, buffer, 5.5f, 0.0f, -0.5f - (float)(i * 2), false, r, g, b);
        }
        RenderDuel.drawCardOutline(matrix, buffer, -2.5f, 0.0f, -4.5f, false, r, g, b);
        RenderDuel.drawCardOutline(matrix, buffer, -6.5f, 0.0f, 2.5f, true, r, g, b);
        RenderDuel.drawCardOutline(matrix, buffer, 1.5f, 0.0f, -4.5f, false, r, g, b);
        RenderDuel.drawCardOutline(matrix, buffer, 4.0f, 0.0f, 2.5f, true, r, g, b);
        if (render.getPlayers() != null) {
            GameClientState client = controller.getClient();
            for (int playerIndex = 0; playerIndex < 2; ++playerIndex) {
                int i2;
                float xOffset;
                PlayerClientOpponentState player = render.getPlayers()[playerIndex];
                PlayerClientOpponentState opp = render.getPlayers()[(playerIndex + 1) % 2];
                if (player == null) continue;
                int rotation = playerIndex * 180;
                float f2 = xOffset = playerIndex == 0 ? 1.5f : -2.5f;
                if (player.getPlayerName() != null) {
                    float x0 = xOffset;
                    float y0 = -1.65f;
                    float z0 = 6.0f;
                    matrix.func_227860_a_();
                    RenderCard.handleRotation(matrix, x0, y0, z0, rotation, 1.0f);
                    boolean force = Minecraft.func_71410_x().func_211821_e();
                    Minecraft.func_71410_x().func_238209_b_(false);
                    RenderCard.drawUnlocalizedString(matrix, (double)(x0 - 5.0f), (double)y0, (double)z0 - 5.5, player.getPlayerName(), render.getGamePhase().after(GamePhase.PreMatch) && render.getCurrentTurn() == playerIndex ? 56797 : 0xFFFFFF, false, 90, 4.0f, "");
                    Minecraft.func_71410_x().func_238209_b_(force);
                    matrix.func_227865_b_();
                }
                matrix.func_227860_a_();
                float x1 = playerIndex == 0 ? 2.825f : -3.825f;
                float z1 = playerIndex == 0 ? 2.375f : 0.875f;
                matrix.func_227861_a_(0.0, 0.0, rotation > 0 ? -0.75 : 0.0);
                RenderCard.handleRotation(matrix, x1, 0.0f, z1, rotation, 1.0f);
                RenderingTCG.draw(player.getCoin().getHeads(), 7, DefaultVertexFormats.field_227852_q_, matrix, builder -> {
                    builder.vertex((double)x1, 0.05, (double)z1, 1.0f, 1.0f);
                    builder.vertex((double)(x1 + 0.75f), 0.05, (double)z1, 1.0f, 0.0f);
                    builder.vertex((double)(x1 + 0.75f), 0.05, (double)(z1 - 0.75f), 0.0f, 0.0f);
                    builder.vertex((double)x1, 0.05, (double)(z1 - 0.75f), 0.0f, 1.0f);
                });
                matrix.func_227865_b_();
                PokemonCardState activeCard = player.getActiveCard();
                if (activeCard != null) {
                    float x0 = xOffset;
                    float y0 = 0.1f;
                    float z0 = 6.0f;
                    matrix.func_227860_a_();
                    if (activeCard.getStatus().getConditions().stream().anyMatch(c -> c.getLeft() == CardCondition.ASLEEP)) {
                        matrix.func_227861_a_((double)x0 + 12.25, (double)y0, (double)z0 - 10.25);
                        matrix.func_227863_a_(QuaternionHelper.fromEuler(90.0f, 0.0f, 1.0f, 0.0f));
                        matrix.func_227861_a_((double)(-x0), (double)(-y0), (double)(-z0));
                    } else if (activeCard.getStatus().getConditions().stream().anyMatch(c -> c.getLeft() == CardCondition.PARALYZED)) {
                        matrix.func_227861_a_((double)x0 - 10.25, (double)y0, (double)z0 - 12.25);
                        matrix.func_227863_a_(QuaternionHelper.fromEuler(-90.0f, 0.0f, 1.0f, 0.0f));
                        matrix.func_227861_a_((double)(-x0), (double)(-y0), (double)(-z0));
                    } else if (activeCard.getStatus().getConditions().stream().anyMatch(c -> c.getLeft() == CardCondition.CONFUSED)) {
                        matrix.func_227861_a_((double)(x0 + 2.0f), (double)y0, (double)z0 - 22.5);
                        matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 1.0f, 0.0f));
                        matrix.func_227861_a_((double)(-x0), (double)(-y0), (double)(-z0));
                    }
                    Minecraft mc = Minecraft.func_71410_x();
                    if (client != null && client.getMe() != null && client.getMe().getPlayerName().equals(player.getPlayerName()) && client.getMe().getAvailableActions().isCanAttack() && client.isMyTurn()) {
                        RenderDuel.drawCardOutline(matrix, buffer, x0, y0 - 0.3f, z0 - 10.5f, false, 0, 255, 0);
                    }
                    RenderCard.drawCardOrBase(matrix, x0, y0, z0, activeCard, rotation, f, partialTicks, player, opp);
                    RenderDuel.drawDamageCounter(matrix, activeCard.getStatus().getDamage(), x0, y0, z0, rotation, f);
                    RenderDuel.drawAttachments(matrix, playerIndex, activeCard, x0, y0, z0, rotation, partialTicks, f, player, opp);
                    if (!activeCard.getData().isFaceDown() && !(mc.field_71462_r instanceof TCGScreen)) {
                        matrix.func_227860_a_();
                        RenderDuel.drawPokemonModelOnBoard(matrix, x0, y0, z0, mc, partialTicks, activeCard, BoardLocation.Active, 0, playerIndex, controller.getScale());
                        matrix.func_227865_b_();
                    }
                    if (activeCard.getStatus().getConditions().stream().anyMatch(c -> c.getLeft() == CardCondition.BURNT)) {
                        RenderDuel.drawStatusCounter(matrix, CardCondition.BURNT, x0, y0, z0, rotation);
                    }
                    if (activeCard.getStatus().getConditions().stream().anyMatch(c -> c.getLeft() == CardCondition.POISONED)) {
                        RenderDuel.drawStatusCounter(matrix, CardCondition.POISONED, x0, y0, z0, rotation);
                    }
                    if (activeCard.getStatus().getConditions().stream().anyMatch(c -> c.getLeft() == CardCondition.ASLEEP)) {
                        matrix.func_227863_a_(QuaternionHelper.fromEuler(90.0f, 0.0f, 0.0f, 1.0f));
                    } else if (activeCard.getStatus().getConditions().stream().anyMatch(c -> c.getLeft() == CardCondition.PARALYZED)) {
                        matrix.func_227863_a_(QuaternionHelper.fromEuler(-90.0f, 0.0f, 0.0f, 1.0f));
                    } else if (activeCard.getStatus().getConditions().stream().anyMatch(c -> c.getLeft() == CardCondition.CONFUSED)) {
                        matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
                    }
                    matrix.func_227865_b_();
                }
                for (i2 = 0; i2 < 5; ++i2) {
                    int benchIndex = playerIndex == 1 ? 4 - i2 : i2;
                    PokemonCardState benchCard = player.getBenchCards()[benchIndex];
                    if (benchCard == null) continue;
                    float x0 = playerIndex == 0 ? 5.5f : -6.5f;
                    float y0 = 0.1f;
                    float z0 = 10.0f - (float)i2 * 2.0f;
                    RenderCard.drawCardOrBase(matrix, x0, y0, z0, benchCard, rotation, f, partialTicks, player, opp);
                    RenderDuel.drawDamageCounter(matrix, benchCard.getStatus().getDamage(), x0, y0, z0, rotation, f);
                    RenderDuel.drawAttachments(matrix, playerIndex, benchCard, x0, y0, z0, rotation, partialTicks, f, player, opp);
                }
                if (player.getTrainerCard() != null) {
                    RenderCard.drawCard(matrix, xOffset, 0.1f, 3.0f, player.getTrainerCard(), rotation, f, partialTicks, player, opp);
                }
                matrix.func_227860_a_();
                if (player.getPrizeCards() != null) {
                    for (i2 = 0; i2 < player.getPrizeCards().length; ++i2) {
                        float xPrizeOffset = (playerIndex == 0 ? 6.5f : 0.75f) + 0.45f - (float)(i2 % 3 + 3) * 1.125f;
                        float zPrizeOffset = 8.5f + (float)(i2 / 3) * 1.5f;
                        if (player.getPrizeCards()[i2] == null) continue;
                        matrix.func_227860_a_();
                        RenderCard.handleRotation(matrix, xPrizeOffset, 0.1f, zPrizeOffset, 90, 0.75f);
                        RenderCard.drawCardBase(matrix, xPrizeOffset, 0.1f, zPrizeOffset, null, false, (PlayerCommonState)player, (PlayerCommonState)opp);
                        matrix.func_227865_b_();
                    }
                }
                matrix.func_227865_b_();
                matrix.func_227860_a_();
                double x0 = 0.0;
                double y0 = 0.1;
                double z0 = -0.5;
                for (int i3 = 0; i3 < player.getDeckSize(); ++i3) {
                    x0 = playerIndex == 0 ? 4.0 : -4.5;
                    y0 = 0.02 * (double)i3 + 0.1;
                    RenderCard.drawCardBase(matrix, x0, y0, z0, null, true, (PlayerCommonState)player, (PlayerCommonState)opp);
                }
                RenderCard.handleRotation(matrix, (float)x0, (float)y0, (float)z0, 270, 2.7f);
                String s = Integer.toString(player.getDeckSize());
                RenderCard.drawUnlocalizedString(matrix, x0 - 0.253, y0 - 1.65, z0 + 0.075, s, 0, false, 90, 3.0f, "");
                RenderCard.drawUnlocalizedString(matrix, x0 - 0.243, y0 - 1.64, z0 + 0.065, s, 0xEEEEEE, false, 90, 3.0f, "");
                RenderCard.drawUnlocalizedString(matrix, x0 - 0.785, (double)-1.65f, z0 + 0.13, "Deck", 0xFFFFFF, false, 90, 1.0f, "");
                matrix.func_227865_b_();
                matrix.func_227860_a_();
                x0 = 0.0;
                y0 = 0.1;
                z0 = -0.5;
                for (int i4 = 0; i4 < player.getDiscardPile().size(); ++i4) {
                    x0 = playerIndex == 0 ? 6.0 : -6.5;
                    y0 = 0.02 * (double)i4 + 0.1;
                    RenderCard.drawCardBase(matrix, x0, y0, z0, null, true, (PlayerCommonState)player, (PlayerCommonState)opp);
                }
                if (player.getDiscardPile().size() == 0) {
                    x0 = playerIndex == 0 ? 6.0 : -6.5;
                    y0 = 0.1;
                }
                RenderCard.handleRotation(matrix, x0, y0, z0, 270, 2.7f);
                s = Integer.toString(player.getDiscardPile().size());
                RenderCard.drawUnlocalizedString(matrix, x0 - 0.253, y0 - 1.65, z0 + 0.075, s, 0, false, 90, 3.0f, "");
                RenderCard.drawUnlocalizedString(matrix, x0 - 0.243, y0 - 1.64, z0 + 0.065, s, 0xEEEEEE, false, 90, 3.0f, "");
                RenderCard.drawUnlocalizedString(matrix, x0 - 0.785, (double)-1.65f, z0, "Discards", 0xFFFFFF, false, 90, 1.0f, "");
                matrix.func_227865_b_();
            }
        }
        RenderCard.drawCard(matrix, -6.5f, 0.1f, 2.5f, null, 90, f, partialTicks, null, null);
        RenderCard.drawCard(matrix, 4.0f, 0.1f, 2.5f, null, 90, f, partialTicks, null, null);
        RenderDuel.drawCardOutline(matrix, buffer, -2.5f, 0.0f, -1.5f, false, r, g, b);
        RenderDuel.drawCardOutline(matrix, buffer, -4.5f, 0.0f, 2.5f, true, r, g, b);
        RenderDuel.drawCardOutline(matrix, buffer, 1.5f, 0.0f, -1.5f, false, r, g, b);
        RenderDuel.drawCardOutline(matrix, buffer, 6.0f, 0.0f, 2.5f, true, r, g, b);
        RenderCard.drawCard(matrix, -4.5f, 0.1f, 2.5f, null, 90, f, partialTicks, null, null);
        RenderCard.drawCard(matrix, 6.0f, 0.1f, 2.5f, null, 90, f, partialTicks, null, null);
        matrix.func_227860_a_();
        for (i = 0; i < 6; ++i) {
            float zOffset = 7.0f + (float)(i / 3) * 1.5f;
            float xOffset = 1.6875f - (float)(i % 3 + 3) * 1.125f;
            RenderDuel.drawPrizeOutline(matrix, buffer, -xOffset, 0.0f, -zOffset, r, g, b);
            xOffset = 7.4375f - (float)(i % 3 + 3) * 1.125f;
            RenderDuel.drawPrizeOutline(matrix, buffer, -xOffset, 0.0f, -zOffset, r, g, b);
        }
        matrix.func_227865_b_();
        RenderDuel.drawCardOutline(matrix, buffer, -0.25f, 0.0f, -7.5f, true, r, g, b);
        matrix.func_227865_b_();
        RenderingTCG.setBufferForScreenRendering();
    }

    private static void drawDamageCounter(MatrixStack matrix, int damage, double x0, double y0, double z0, int rotation, FontRenderer f) {
        matrix.func_227860_a_();
        if (damage > 0) {
            String str = Integer.toString(damage);
            RenderCard.handleRotation(matrix, x0, y0, z0, rotation, 1.0f);
            RenderCard.drawSprite(matrix, (float)(x0 + (double)0.55f), (float)(y0 + (double)0.01f), (float)(z0 + 1.0), 3.0, 0, new ResourceLocation("tcg:gui/cards/damage.png"));
            RenderCard.drawUnlocalizedString(matrix, x0 + 2.2, y0 - (double)1.68f, z0 + 0.17 - 0.125 * (double)str.toCharArray().length, str, 0xFFFFFF, false, 90, 3.5f, "");
        }
        matrix.func_227865_b_();
    }

    private static void drawStatusCounter(MatrixStack matrix, CardCondition cardCondition, float x0, float y0, float z0, int rotation) {
        matrix.func_227860_a_();
        double offset = 0.0;
        if (cardCondition == CardCondition.BURNT) {
            offset = 0.8;
        }
        RenderCard.handleRotation(matrix, x0, y0, z0, rotation, 1.0f);
        RenderCard.drawSprite(matrix, (double)x0 - offset, (double)y0 + 0.005, (double)(z0 + 1.0f), 3.0, 0, new ResourceLocation("tcg:gui/cards/" + cardCondition.getName().toLowerCase() + ".png"));
        matrix.func_227865_b_();
    }

    private static void drawAttachments(MatrixStack matrix, int playerIndex, PokemonCardState activeCard, float x0, float y0, float z0, int rotation, float t, FontRenderer f, PlayerClientOpponentState player, PlayerClientOpponentState opp) {
        matrix.func_227860_a_();
        float attachmentOffsetX = 0.03f;
        float attachmentOffsetY = 0.026f;
        float attachmentOffsetZ = 0.03f;
        int sign = playerIndex == 0 ? 1 : -1;
        int energyCount = 0;
        for (int attachmentIndex = 0; attachmentIndex < activeCard.getAttachments().size(); ++attachmentIndex) {
            List<CommonCardState> energies;
            CommonCardState attachment = activeCard.getAttachments().get(attachmentIndex);
            RenderCard.drawCardOrBase(matrix, x0 + (float)sign * attachmentOffsetX * (float)(attachmentIndex + 1), y0 - attachmentOffsetY * (float)(attachmentIndex + 1), z0 - (float)sign * attachmentOffsetZ * (float)(attachmentIndex + 1), attachment, 180, f, t, player, opp);
            if (attachment.getCardType() == CardType.ENERGY) {
                RenderDuel.drawEnergySprite(matrix, playerIndex, x0, y0, z0, rotation, energyCount++, attachment.getMainEnergy());
                if (attachment.getSecondaryEnergy() == null) continue;
                RenderDuel.drawEnergySprite(matrix, playerIndex, x0, y0, z0, rotation, energyCount++, attachment.getSecondaryEnergy());
                continue;
            }
            if (attachment.getAbility() == null || attachment.getAbility().getEffect() == null || (energies = attachment.getAbility().getEffect().getEnergyEquivalence(attachment)) == null) continue;
            for (CommonCardState energy : energies) {
                RenderDuel.drawEnergySprite(matrix, playerIndex, x0, y0, z0, rotation, energyCount++, energy.getMainEnergy());
            }
        }
        matrix.func_227865_b_();
    }

    private static void drawEnergySprite(MatrixStack matrix, int playerIndex, double x0, double y0, double z0, int rotation, int energyCount, Energy energy) {
        matrix.func_227860_a_();
        int sign = playerIndex == 0 ? 1 : -1;
        double energySize = 0.25;
        double xEnergyOffset = -1.3;
        double zEnergyOffset = -0.7 + (double)energyCount * (energySize + 0.02);
        RenderCard.handleRotation(matrix, x0, y0, z0, rotation, 1.0f);
        RenderCard.drawEnergySprite(matrix, x0 + xEnergyOffset, y0 + 0.01, z0 + zEnergyOffset, rotation, energy);
        matrix.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawPokemonModelOnBoard(MatrixStack matrix, double x, double y, double z, Minecraft mc, float partialTicks, CommonCardState c, BoardLocation location, int sublocation, int playerIndex, float scale) {
        PixelmonEntity pixelmon = activePokemons[playerIndex];
        int rotation = playerIndex == 0 ? 270 : 90;
        matrix.func_227861_a_(-x, -y, -z);
        matrix.func_227863_a_(new Quaternion(0.0f, (float)rotation, 180.0f, true));
        matrix.func_227861_a_(x += playerIndex == 0 ? -2.25 : 3.25, y, z -= 9.5);
        if (pixelmon == null || pixelmon.getSpecies().getDex() != c.getPokemonID()) {
            pixelmon = PokemonFactory.create(PixelmonSpecies.fromDex(c.getPokemonID()).get()).getOrCreatePixelmon((World)mc.field_71441_e, x, y, z);
            pixelmon.getLvl().setLevel(1);
            pixelmon.getPokemon().setGrowth(EnumGrowth.Ginormous);
            pixelmon.canMove = true;
            pixelmon.func_200203_b(StringTextComponent.field_240750_d_);
            RenderDuel.activePokemons[playerIndex] = pixelmon;
            pixelmon.setAnimation(AnimationType.IDLE);
        }
        if (pixelmon.isSpriteModel() || PixelmonConfigProxy.getGraphics().isGlobalSpriteToggle()) {
            return;
        }
        pixelmon.func_226284_e_(true);
        pixelmon.setPixelmonScale((float)((double)scale * (pixelmon.getForm().getDimensions().getHeight() / 3.0 / pixelmon.getForm().getDimensions().getHeight())));
        if (newTick) {
            pixelmon.getAnimationVariables().tick();
        }
        matrix.func_227860_a_();
        Vector3f color = c.getOverrideModelColor() != null ? c.getOverrideModelColor() : new Vector3f(1.0f, 1.0f, 1.0f);
        RenderHelper.func_227780_a_();
        try {
            EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            pixelmon.setRenderColor(color.func_195899_a(), color.func_195900_b(), color.func_195902_c(), 1.0f);
            EntityRenderer entityClassRenderObject = renderManager.func_78713_a((Entity)pixelmon);
            PixelmonRenderer rp = (PixelmonRenderer)entityClassRenderObject;
            IRenderTypeBuffer.Impl buffer = ScreenHelper.getBufferImpl();
            rp.render(pixelmon, 0.0f, partialTicks, matrix, (IRenderTypeBuffer)buffer, 0xF000F0);
            buffer.func_228461_a_();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        matrix.func_227865_b_();
    }
}

