/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.structure.type;

import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.world.generation.features.GymVillagePiece;
import com.pixelmonmod.pixelmon.world.structure.type.ChunkSearchStructure;
import com.pixelmonmod.pixelmon.world.structure.type.GymConfig;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPatternRegistry;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class GymStructure
extends ChunkSearchStructure<GymConfig> {
    private final int startY = 0;
    private final boolean doExpansionHack = true;
    private final boolean projectStartToHeightmap = true;

    public GymStructure(Codec<GymConfig> p_i241978_1_) {
        super(p_i241978_1_);
    }

    @Override
    public boolean isSuitable(Biome.Category category, String name) {
        return true;
    }

    @Override
    public int getSearchRadius() {
        return 6;
    }

    public Structure.IStartFactory<GymConfig> func_214557_a() {
        return (p_242778_1_, p_242778_2_, p_242778_3_, p_242778_4_, p_242778_5_, p_242778_6_) -> new Start(this, p_242778_2_, p_242778_3_, p_242778_4_, p_242778_5_, p_242778_6_);
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    protected boolean func_230365_b_() {
        return false;
    }

    public static class Start
    extends MarginedStructureStart<GymConfig> {
        private final GymStructure feature;

        public Start(GymStructure p_i241979_1_, int p_i241979_2_, int p_i241979_3_, MutableBoundingBox p_i241979_4_, int p_i241979_5_, long p_i241979_6_) {
            super((Structure)p_i241979_1_, p_i241979_2_, p_i241979_3_, p_i241979_4_, p_i241979_5_, p_i241979_6_);
            this.feature = p_i241979_1_;
        }

        public void generatePieces(DynamicRegistries p_230364_1_, ChunkGenerator generator, TemplateManager p_230364_3_, int chunkX, int chunkZ, Biome biome, GymConfig p_230364_7_) {
            BlockPos blockpos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
            JigsawPatternRegistry.func_244093_a();
            if (biome.func_201856_r() == Biome.Category.NETHER) {
                BlockPos.Mutable mutable = blockpos.func_239590_i_();
                IBlockReader baseColumn = generator.func_230348_a_(blockpos.func_177958_n(), blockpos.func_177952_p());
                boolean foundAir = false;
                for (int i = 127; i > 20; --i) {
                    mutable.func_181079_c(mutable.func_177958_n(), i, mutable.func_177952_p());
                    boolean air = baseColumn.func_180495_p(mutable.func_185334_h()).func_196958_f();
                    if (air && !foundAir) {
                        foundAir = true;
                    }
                    if (air || !foundAir) continue;
                    blockpos = new BlockPos(mutable.func_177958_n(), i, mutable.func_177952_p()).func_177984_a();
                    break;
                }
            }
            boolean projectStartToHeightmap = biome.func_201856_r() != Biome.Category.NETHER;
            JigsawManager.func_242837_a((DynamicRegistries)p_230364_1_, (VillageConfig)p_230364_7_, (a, b, c, d, e, f) -> new GymVillagePiece(a, b, c, d, e, f, p_230364_7_.doesTransformSurroundingLand()), (ChunkGenerator)generator, (TemplateManager)p_230364_3_, (BlockPos)blockpos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)true, (boolean)projectStartToHeightmap);
            this.func_202500_a();
        }
    }
}

