/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.listener;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.enums.BattleEndTaskType;
import com.pixelmonmod.pixelmon.api.events.PixelmonFaintEvent;
import com.pixelmonmod.pixelmon.api.events.battles.BattleEndEvent;
import com.pixelmonmod.pixelmon.api.events.battles.BattleStartedEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.SpawnerCoordinator;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnActionPokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.WeightedSet;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.world.BlockCollection;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.ai.AggressiveAI;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.battles.status.Paralysis;
import com.pixelmonmod.pixelmon.battles.status.Poison;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import com.pixelmonmod.pixelmon.spawning.PlayerTrackingSpawner;
import com.pixelmonmod.pixelmon.world.dimension.ultraspace.UltraSpace;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class UltraSpaceListener {
    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!(entity instanceof PlayerEntity) || ((PlayerEntity)event.getEntityLiving()).func_184812_l_()) {
            return;
        }
        if (((PlayerEntity)entity).func_184812_l_() || entity.func_175149_v()) {
            return;
        }
        if (Objects.equals(entity.field_70170_p.func_234923_W_(), UltraSpace.WORLD)) {
            boolean modifyGravity = false;
            if (!entity.func_189652_ae() && !entity.func_184218_aH()) {
                modifyGravity = true;
            }
            if (modifyGravity) {
                Vector3d movement = entity.func_213322_ci();
                if (!entity.func_213453_ef() && !entity.func_203007_ba()) {
                    entity.func_213317_d(new Vector3d(movement.func_82615_a(), movement.func_82617_b() + 0.07, movement.func_82616_c()));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.field_70170_p.func_234923_W_() == UltraSpace.WORLD) {
            event.setDistance(event.getDistance() / 5.0f);
            event.setDamageMultiplier(0.5f);
        }
    }

    @SubscribeEvent
    public static void onClonePlayer(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            PlayerEntity old = event.getOriginal();
            PlayerEntity copy = event.getPlayer();
            CompoundNBT persistentData = copy.getPersistentData();
            if (persistentData.func_74764_b("PortalX")) {
                copy.getPersistentData().func_218657_a("PortalX", old.getPersistentData().func_74781_a("PortalX"));
            }
            if (persistentData.func_74764_b("PortalY")) {
                copy.getPersistentData().func_218657_a("PortalY", old.getPersistentData().func_74781_a("PortalY"));
            }
            if (persistentData.func_74764_b("PortalZ")) {
                copy.getPersistentData().func_218657_a("PortalZ", old.getPersistentData().func_74781_a("PortalZ"));
            }
            if (persistentData.func_74764_b("PortalD")) {
                copy.getPersistentData().func_218657_a("PortalD", old.getPersistentData().func_74781_a("PortalD"));
            }
        }
    }

    @SubscribeEvent
    public static void onPokeFaint(PixelmonFaintEvent.Post event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (!UltraSpace.is((World)event.getPlayer().func_71121_q())) {
            return;
        }
        PlayerPartyStorage party = StorageProxy.getParty(event.getPlayer());
        BattleController battle = BattleRegistry.getBattle((PlayerEntity)event.getPlayer());
        if (party.countAblePokemon() == 0) {
            if (battle != null) {
                party.addTaskForBattleEnd(BattleEndTaskType.ALWAYS_QUEUE, battleController -> UltraSpaceListener.teleportBackToOverworld(event.getPlayer()));
            } else {
                UltraSpaceListener.teleportBackToOverworld(event.getPlayer());
            }
        }
    }

    private static void teleportBackToOverworld(ServerPlayerEntity player) {
        BlockPos respawnPosition = player.func_241140_K_();
        ServerWorld world = ServerLifecycleHooks.getCurrentServer().func_71218_a(player.func_241141_L_());
        if (respawnPosition == null) {
            respawnPosition = world.func_241135_u_();
        }
        player.func_200619_a(world, (double)respawnPosition.func_177958_n(), (double)respawnPosition.func_177956_o(), (double)respawnPosition.func_177952_p(), player.field_70177_z, player.field_70125_A);
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null || !UltraSpace.is(event.getPlayer().field_70170_p)) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        World world = event.getPlayer().field_70170_p;
        if (player.field_70170_p.func_226691_t_(player.func_233580_cy_()).getRegistryName().func_110623_a().equals("ultra_plant") && event.getState().func_203425_a(Blocks.field_180398_cJ) && RandomHelper.getRandomChance(0.5)) {
            LightningBoltEntity entity = new LightningBoltEntity(EntityType.field_200728_aG, world);
            entity.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            world.func_217376_c((Entity)entity);
            for (Pokemon pokemon : StorageProxy.getParty((ServerPlayerEntity)player).getAll()) {
                if (pokemon == null) continue;
                pokemon.setStatus(new Paralysis());
            }
            return;
        }
        if (player.field_70170_p.func_226691_t_(player.func_233580_cy_()).getRegistryName().func_110623_a().equals("ultra_crater") && (event.getState().func_203425_a(Blocks.field_150339_S) || event.getState().func_203425_a(PixelmonBlocks.aluminium_block) || event.getState().func_203425_a(Blocks.field_189880_di)) && RandomHelper.getRandomChance(0.5)) {
            event.getPlayer().func_195064_c(new EffectInstance(Effects.field_76436_u, 300, 3, false, true, true));
            event.getPlayer().func_195064_c(new EffectInstance(Effects.field_76419_f, 1200, 3, false, true, true));
            event.getPlayer().func_195064_c(new EffectInstance(Effects.field_76440_q, 200, 1, false, true, true));
            for (Pokemon pokemon : StorageProxy.getParty((ServerPlayerEntity)player).getAll()) {
                if (pokemon == null) continue;
                pokemon.setStatus(new Poison());
            }
        }
    }

    @SubscribeEvent
    public static void onBattleStart(BattleStartedEvent.Pre event) {
        PlayerParticipant player = UltraSpaceListener.findPlayer(event);
        if (player == null || !UltraSpace.is(player.player.field_70170_p) || event.getTeamOne().length > 1 || event.getTeamTwo().length > 1) {
            return;
        }
        WildPixelmonParticipant wildPokemon = UltraSpaceListener.findWildPokemon(event);
        if (wildPokemon == null) {
            return;
        }
        if (PixelmonConfigProxy.getSpawning().isAlwaysAggressiveDimensions(player.player.field_70170_p)) {
            wildPokemon.setBattleAI(new AggressiveAI(wildPokemon));
        }
        if (!PixelmonConfigProxy.getSpawning().isHordeBattleDimensions(player.player.field_70170_p)) {
            return;
        }
        if (event.getBattleController().participants.size() > 2 || !RandomHelper.getRandomChance(PixelmonConfigProxy.getSpawning().getUltraSpaceHordeSpawnRate())) {
            return;
        }
        PixelmonEntity entity = (PixelmonEntity)wildPokemon.getEntity();
        ArrayList newWildPokemon = Lists.newArrayList();
        newWildPokemon.add(new WildPixelmonParticipant(entity));
        AbstractSpawner spawner = PixelmonSpawning.coordinator.getSpawner(player.player.func_200200_C_().getString());
        if (!(spawner instanceof PlayerTrackingSpawner)) {
            return;
        }
        boolean cancellation = event.isCanceled();
        event.setCanceled(true);
        PlayerTrackingSpawner pSpawner = (PlayerTrackingSpawner)spawner;
        ((CompletableFuture)spawner.getTrackedBlockCollection((Entity)player.player, 0.0f, 0.0f, pSpawner.horizontalSliceRadius, pSpawner.verticalSliceRadius, 0, 0).thenApplyAsync(blockCollection -> {
            ArrayList<SpawnLocation> spawnLocations = pSpawner.spawnLocationCalculator.calculateSpawnableLocations((BlockCollection)blockCollection);
            WeightedSet<Pair> possibleSpawns = WeightedSet.newWeightedSet(new Object[0]);
            for (SpawnLocation spawnLocation : spawnLocations) {
                List<SpawnInfo> spawns = spawner.getSuitableSpawns(spawnLocation);
                if (spawns.isEmpty()) continue;
                for (SpawnInfo spawn : spawns) {
                    possibleSpawns.add(spawn.rarity, Pair.of((Object)spawn, (Object)spawnLocation));
                }
            }
            if (possibleSpawns.isEffectivelyEmpty()) {
                event.setCanceled(cancellation);
                return null;
            }
            return possibleSpawns;
        }, (Executor)SpawnerCoordinator.PROCESSOR)).thenAcceptAsync(possibleSpawns -> {
            if (possibleSpawns == null) {
                return;
            }
            for (int i = 0; i < 4; ++i) {
                Pair spawnAction = (Pair)possibleSpawns.get();
                SpawnAction<? extends Entity> action = ((SpawnInfo)spawnAction.getFirst()).construct(spawner, (SpawnLocation)spawnAction.getSecond());
                if (!(action instanceof SpawnActionPokemon)) continue;
                PixelmonEntity spawnedEntity = (PixelmonEntity)((SpawnActionPokemon)action).getOrCreateEntity();
                spawner.tweaks.forEach(tweak -> tweak.doTweak(spawner, action));
                spawnedEntity.func_70107_b((double)((SpawnLocation)spawnAction.getSecond()).location.pos.func_177958_n() + 0.5, ((SpawnLocation)spawnAction.getSecond()).location.pos.func_177956_o(), (double)((SpawnLocation)spawnAction.getSecond()).location.pos.func_177952_p() + 0.5);
                ((SpawnLocation)spawnAction.getSecond()).location.world.func_217376_c((Entity)spawnedEntity);
                spawnedEntity.func_184211_a("REMOVE_AFTER_BATTLE");
                spawner.spawnedTracker.addEntity((Entity)spawnedEntity);
                WildPixelmonParticipant nextParticipant = new WildPixelmonParticipant(spawnedEntity);
                nextParticipant.setBattleAI(new AggressiveAI(nextParticipant));
                newWildPokemon.add(nextParticipant);
            }
            BattleController controller = BattleRegistry.startBattle(newWildPokemon.toArray(new BattleParticipant[0]), new BattleParticipant[]{player}, new BattleRules(BattleType.HORDE));
            if (controller == null) {
                return;
            }
            for (BattleParticipant battleParticipant : newWildPokemon) {
                battleParticipant.bc = controller;
                for (PixelmonWrapper pixelmonWrapper : battleParticipant.allPokemon) {
                    pixelmonWrapper.bc = controller;
                    pixelmonWrapper.entity.battleController = controller;
                }
            }
            controller.sendToAll(wildPokemon.getName() + " summoned some nearby allies to assist them", new Object[0]);
        }, (Executor)ServerLifecycleHooks.getCurrentServer());
    }

    @SubscribeEvent
    public static void onBattleEnd(BattleEndEvent event) {
        for (BattleParticipant participant : event.getBattleController().participants) {
            WildPixelmonParticipant wildParticipant;
            if (!(participant instanceof WildPixelmonParticipant) || (wildParticipant = (WildPixelmonParticipant)participant).getEntity() == null || !wildParticipant.getEntity().func_184216_O().contains("REMOVE_AFTER_BATTLE")) continue;
            wildParticipant.getEntity().func_70106_y();
        }
    }

    private static PlayerParticipant findPlayer(BattleStartedEvent event) {
        for (BattleParticipant battleParticipant : event.getTeamOne()) {
            if (!(battleParticipant instanceof PlayerParticipant)) continue;
            return (PlayerParticipant)battleParticipant;
        }
        for (BattleParticipant battleParticipant : event.getTeamTwo()) {
            if (!(battleParticipant instanceof PlayerParticipant)) continue;
            return (PlayerParticipant)battleParticipant;
        }
        return null;
    }

    private static WildPixelmonParticipant findWildPokemon(BattleStartedEvent event) {
        for (BattleParticipant battleParticipant : event.getTeamOne()) {
            if (!(battleParticipant instanceof WildPixelmonParticipant)) continue;
            return (WildPixelmonParticipant)battleParticipant;
        }
        for (BattleParticipant battleParticipant : event.getTeamTwo()) {
            if (!(battleParticipant instanceof WildPixelmonParticipant)) continue;
            return (WildPixelmonParticipant)battleParticipant;
        }
        return null;
    }
}

