/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.generation.features.ultraspace.crater;

import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class CraterMonolithFeature
extends Feature<NoFeatureConfig> {
    public CraterMonolithFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(ISeedReader level, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        BlockState blockState;
        if (!RandomHelper.getRandomChance(0.05f)) {
            return false;
        }
        BlockPos.Mutable mutablePos = new BlockPos.Mutable(pos.func_177958_n(), generator.func_222532_b(pos.func_177958_n(), pos.func_177956_o(), Heightmap.Type.WORLD_SURFACE_WG), pos.func_177952_p());
        while (mutablePos.func_177956_o() > 20 && ((blockState = level.func_180495_p((BlockPos)mutablePos)).func_203425_a(Blocks.field_150350_a) || blockState.func_203425_a(Blocks.field_150355_j))) {
            mutablePos.func_185336_p(mutablePos.func_177956_o() - 1);
        }
        this.generateSphereWithRadius(level, mutablePos, pos, 8, 20, 30);
        this.generateSphereWithRadius(level, mutablePos, pos, 7, 15, 20);
        this.generateSphereWithRadius(level, mutablePos, pos, 6, 10, 15);
        this.generateSphereWithRadius(level, mutablePos, pos, 5, 8, 9);
        this.generateSphereWithRadius(level, mutablePos, pos, 4, 6, 7);
        this.generateSphereWithRadius(level, mutablePos, pos, 3, 4, 6);
        this.generateSphereWithRadius(level, mutablePos, pos, 2, 2, 4);
        return true;
    }

    private void generateSphereWithRadius(ISeedReader level, BlockPos.Mutable mutablePos, BlockPos pos, int radius, int minHeight, int maxHeight) {
        int originalY = mutablePos.func_177956_o();
        int height = RandomHelper.getRandomNumberBetween(minHeight, maxHeight);
        for (int y = mutablePos.func_177956_o(); y < originalY + height; ++y) {
            mutablePos.func_185336_p(y);
            for (int x = -radius; x < radius; ++x) {
                for (int z = -radius; z < radius; ++z) {
                    mutablePos.func_223471_o(pos.func_177958_n() + x);
                    mutablePos.func_223472_q(pos.func_177952_p() + z);
                    if (x * x + z * z - (radius - 1) * (radius - 1) >= 0) continue;
                    if (RandomHelper.getRandomChance(0.75f)) {
                        this.func_230367_a_((IWorldWriter)level, (BlockPos)mutablePos, Blocks.field_196856_iQ.func_176223_P());
                        continue;
                    }
                    this.func_230367_a_((IWorldWriter)level, (BlockPos)mutablePos, Blocks.field_196883_jg.func_176223_P());
                }
            }
        }
    }
}

