/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.generation.features;

import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class LeafStoneOreFeature
extends Feature<NoFeatureConfig> {
    public LeafStoneOreFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, Random rand, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        world.func_180501_a(pos, PixelmonBlocks.leaf_stone_ore.func_176223_P(), 18);
        return true;
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        int chunkZ;
        if (!world.func_230315_m_().func_236043_f_()) {
            return false;
        }
        int chunkX = pos.func_177958_n() >> 4;
        Biome biome = world.func_226691_t_(new BlockPos(chunkX * 16, 0, (chunkZ = pos.func_177952_p() >> 4) * 16));
        if (biome.func_201856_r() == Biome.Category.FOREST) {
            for (int i = 0; i < random.nextInt(3) + 4; ++i) {
                int z;
                int y;
                int x = random.nextInt(16) + chunkX * 16;
                BlockState block = world.func_180495_p(new BlockPos(x, (y = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(x, 0, z = random.nextInt(16) + chunkZ * 16)).func_177956_o()) - 1, z));
                Material blockMaterial = block.func_185904_a();
                if (blockMaterial != Material.field_151584_j) continue;
                while (blockMaterial != Material.field_151576_e && y > 0) {
                    block = world.func_180495_p(new BlockPos(x, --y - 1, z));
                    blockMaterial = block.func_185904_a();
                }
                if (y <= 0) continue;
                this.generate(world, random, x, y - 1, z);
            }
        }
        return true;
    }
}

