/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.generation.features;

import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.enums.EvolutionRockType;
import com.pixelmonmod.pixelmon.world.dimension.ultraspace.UltraSpace;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class EvolutionRockFeature
extends Feature<NoFeatureConfig> {
    public EvolutionRockFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        if (!world.func_230315_m_().func_236043_f_() && !UltraSpace.is(world)) {
            return false;
        }
        int chunkX = pos.func_177958_n() >> 4;
        int chunkZ = pos.func_177952_p() >> 4;
        int xPos = random.nextInt(16) + chunkX * 16;
        int zPos = random.nextInt(16) + chunkZ * 16;
        int yPos = world.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, new BlockPos(xPos, 0, zPos)).func_177956_o() - 1;
        Biome biome = world.func_226691_t_(new BlockPos(xPos, 0, zPos));
        Block block = world.func_180495_p(new BlockPos(xPos, yPos - 1, zPos)).func_177230_c();
        if (block == Blocks.field_150349_c || block == Blocks.field_150346_d) {
            for (EvolutionRockType r : EvolutionRockType.values()) {
                for (Biome.Category b : r.getBiomes()) {
                    if (b != biome.func_201856_r() || !(random.nextDouble() < 0.05)) continue;
                    boolean canSpawn = true;
                    for (int ix = -1; ix < 2; ++ix) {
                        for (int iz = -1; iz < 2; ++iz) {
                            Block block2 = world.func_180495_p(new BlockPos(xPos + ix, yPos - 1, zPos + iz)).func_177230_c();
                            if (block2 == Blocks.field_150349_c || block2 == Blocks.field_150346_d || block2 == Blocks.field_196604_cC || block2 == Blocks.field_150433_aE) continue;
                            canSpawn = false;
                        }
                    }
                    if (canSpawn) {
                        // empty if block
                    }
                    return true;
                }
            }
        }
        return true;
    }
}

