/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.generation;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.world.generation.PixelmonFeatures;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class WorldGenRegistration {
    public static final Set<GenerationSettings> CONFIGURED_FEATURES = Sets.newHashSet();

    private static void add(GenerationSettings settings) {
        CONFIGURED_FEATURES.add(settings);
    }

    static {
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.UNDERGROUND_ORES, PixelmonFeatures.BAUXITE_ORE));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.UNDERGROUND_ORES, PixelmonFeatures.SILVER_ORE));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.UNDERGROUND_ORES, PixelmonFeatures.PLATINUM_ORE));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.UNDERGROUND_ORES, PixelmonFeatures.FIRE_STONE_ORE));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.UNDERGROUND_ORES, PixelmonFeatures.MOON_STONE_ORE));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.UNDERGROUND_ORES, PixelmonFeatures.ICE_STONE_ORE));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, PixelmonFeatures.SUN_STONE_ORE));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, PixelmonFeatures.LEAF_STONE_ORE));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.UNDERGROUND_ORES, PixelmonFeatures.DAWN_ORE));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.UNDERGROUND_ORES, PixelmonFeatures.DUSK_ORE));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.UNDERGROUND_ORES, PixelmonFeatures.SHINY_ORE));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.UNDERGROUND_ORES, PixelmonFeatures.WATER_STONE_ORE));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.UNDERGROUND_ORES, PixelmonFeatures.SAPPHIRE_ORE));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.UNDERGROUND_ORES, PixelmonFeatures.AMETHYST_ORE));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.UNDERGROUND_ORES, PixelmonFeatures.CRYSTAL_ORE));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.UNDERGROUND_ORES, PixelmonFeatures.SILICON_ORE));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.UNDERGROUND_ORES, PixelmonFeatures.RUBY_ORE));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.SURFACE_STRUCTURES, PixelmonFeatures.EVOLUTION_ROCK));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.UNDERGROUND_ORES, PixelmonFeatures.FOSSIL));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.VEGETAL_DECORATION, PixelmonFeatures.GRACIDEA));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.VEGETAL_DECORATION, PixelmonFeatures.MAX_MUSHROOMS));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.SURFACE_STRUCTURES, PixelmonFeatures.POKE_CHEST));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.VEGETAL_DECORATION, PixelmonFeatures.BERRY_TREES));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.VEGETAL_DECORATION, PixelmonFeatures.APRICORN_TREES));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.VEGETAL_DECORATION, PixelmonFeatures.TUMBLE_STONES, event -> event.getCategory() == Biome.Category.EXTREME_HILLS));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, PixelmonFeatures.ULTRA_BOSS, event -> event.getName().toString().contains("ultra_")));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.SURFACE_STRUCTURES, PixelmonFeatures.CRATER_MONOLITH, event -> event.getName().toString().contains("ultra_crater")));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.SURFACE_STRUCTURES, PixelmonFeatures.CRATER_PIPES, event -> event.getName().toString().contains("ultra_crater")));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.SURFACE_STRUCTURES, PixelmonFeatures.PLANT_MONOLITH, event -> event.getName().toString().contains("ultra_plant")));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.SURFACE_STRUCTURES, PixelmonFeatures.PLANT_XURKITREE, event -> event.getName().toString().contains("ultra_plant")));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.SURFACE_STRUCTURES, PixelmonFeatures.DEEP_SEA_SPIKES, event -> event.getName().toString().contains("ultra_deep_sea")));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.LAKES, PixelmonFeatures.DEEP_SEA_KELP, event -> event.getName().toString().contains("ultra_deep_sea")));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.VEGETAL_DECORATION, PixelmonFeatures.DEEP_SEA_KELP, event -> event.getName().toString().contains("ultra_deep_sea")));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.VEGETAL_DECORATION, PixelmonFeatures.PATCH_CACTUS_DESERT, event -> event.getName().toString().contains("ultra_desert")));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.SURFACE_STRUCTURES, PixelmonFeatures.DESERT_SPIKES, event -> event.getName().toString().contains("ultra_desert")));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.LAKES, PixelmonFeatures.DISK_CLAY, event -> event.getName().toString().contains("ultra_deep_sea")));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.LAKES, PixelmonFeatures.DISK_GRAVEL, event -> event.getName().toString().contains("ultra_deep_sea")));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, PixelmonFeatures.DISK_GILDED_ULTRA_SAND, event -> event.getName().toString().contains("ultra_desert")));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.VEGETAL_DECORATION, PixelmonFeatures.ULTRA_FOREST_FLOWER, event -> event.getName().toString().contains("ultra_forest") || event.getName().toString().contains("ultra_jungle")));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.VEGETAL_DECORATION, PixelmonFeatures.TREES_ULTRA_JUNGLE, event -> event.getName().toString().contains("ultra_jungle")));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.VEGETAL_DECORATION, PixelmonFeatures.TREES_ULTRA_FOREST, event -> event.getName().toString().contains("ultra_forest")));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.VEGETAL_DECORATION, PixelmonFeatures.FALLEN_LEAVES, event -> event.getName().toString().contains("ultra_jungle") || event.getName().toString().contains("ultra_forest")));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.RAW_GENERATION, PixelmonFeatures.DROWNED_WORLD_ISLAND, event -> event.getName().toString().contains("drowned_")));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, PixelmonFeatures.DISK_MAGMA_BLOCK, event -> event.getName().toString().contains("drowned_")));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.VEGETAL_DECORATION, PixelmonFeatures.DROWNED_WORLD_SEAGRASS, event -> event.getName().toString().contains("drowned_")));
        WorldGenRegistration.add(new GenerationSettings(GenerationStage.Decoration.VEGETAL_DECORATION, PixelmonFeatures.DROWNED_WORLD_KELP, event -> event.getName().toString().contains("drowned_")));
    }

    public static final class GenerationSettings {
        private final GenerationStage.Decoration decoration;
        private final ConfiguredFeature<?, ?> feature;
        private final Predicate<BiomeLoadingEvent> predicate;

        public GenerationSettings(GenerationStage.Decoration decoration, ConfiguredFeature<?, ?> feature, Predicate<BiomeLoadingEvent> predicate) {
            this.decoration = decoration;
            this.feature = feature;
            this.predicate = predicate;
        }

        public GenerationSettings(GenerationStage.Decoration decoration, ConfiguredFeature<?, ?> feature) {
            this(decoration, feature, biomeLoadingEvent -> true);
        }

        public GenerationStage.Decoration getDecoration() {
            return this.decoration;
        }

        public ConfiguredFeature<?, ?> getFeature() {
            return this.feature;
        }

        public Predicate<BiomeLoadingEvent> getPredicate() {
            return this.predicate;
        }
    }
}

