/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.schedulers;

import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.storage.StorageSaveScheduler;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PixelmonStorageStandardScheduler
implements StorageSaveScheduler {
    public int lastSaveTick = 0;

    @Override
    public void onServerStopping(FMLServerStoppingEvent event) {
        this.saveAll();
        this.lastSaveTick = 0;
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        int currentTick = ServerLifecycleHooks.getCurrentServer().func_71259_af();
        if (currentTick > this.lastSaveTick) {
            this.saveAll();
            this.lastSaveTick = currentTick;
        }
    }

    public void saveAll() {
        for (PokemonStorage storage : StorageProxy.getAllCachedStorages()) {
            if (!storage.getShouldSave()) continue;
            this.save(storage);
            StorageProxy.onStorageSaved(storage);
        }
    }
}

