/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.quest;

import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.actions.Action;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.quest.Context;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.StageIcon;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.ArrayList;
import net.minecraft.network.PacketBuffer;

public class Stage {
    private short stage;
    private short nextStage;
    private StageIcon icon = null;
    private ArrayList<String> conditions = new ArrayList();
    private ArrayList<String> objectives = new ArrayList();
    private ArrayList<String> actions = new ArrayList();
    private transient ArrayList<Objective> parsedConditions = new ArrayList();
    private transient ArrayList<Objective> parsedObjectives = new ArrayList();
    private transient ArrayList<Action> parsedActions = new ArrayList();

    public Stage() {
        this.stage = 0;
        this.nextStage = (short)10;
    }

    public Stage(int stage, int nextStage) {
        this.stage = (short)stage;
        this.nextStage = (short)nextStage;
    }

    public Stage(int stage, int nextStage, String objective) {
        this.stage = (short)stage;
        this.nextStage = (short)nextStage;
        this.objectives.add(objective);
    }

    public Stage(Stage toCopy) {
        this.stage = toCopy.stage;
        this.nextStage = toCopy.nextStage;
        this.icon = toCopy.icon;
        this.conditions.addAll(toCopy.conditions);
        this.objectives.addAll(toCopy.objectives);
        this.actions.addAll(toCopy.actions);
    }

    public Stage(PacketBuffer buf) {
        this.readFromByteBuf(buf);
    }

    public short getStage() {
        return this.stage;
    }

    public short getNextStage() {
        return this.nextStage;
    }

    public StageIcon getIcon() {
        if (this.icon == null) {
            this.icon = this.getNextStage() == -1 ? StageIcon.QUESTION_MARK : StageIcon.EXCLAMATION_MARK;
        }
        return this.icon;
    }

    public void changeIcon() {
        StageIcon icon = this.getIcon();
        int ordinal = icon.ordinal() + 1;
        this.icon = StageIcon.values()[ordinal == StageIcon.values().length ? 0 : ordinal];
    }

    public ArrayList<String> getRawConditions() {
        return this.conditions;
    }

    public ArrayList<String> getRawObjectives() {
        return this.objectives;
    }

    public ArrayList<String> getRawActions() {
        return this.actions;
    }

    public ArrayList<Objective> getParsedConditions() {
        return this.parsedConditions;
    }

    public ArrayList<Objective> getParsedObjectives() {
        return this.parsedObjectives;
    }

    public ArrayList<Action> getParsedActions() {
        return this.parsedActions;
    }

    public boolean meetsConditions(QuestData data, QuestProgress progress) throws InvalidQuestArgsException {
        for (int i = 0; i < this.parsedConditions.size(); ++i) {
            Objective condition = this.parsedConditions.get(i);
            if (condition.test(this, data, progress, new Context())) continue;
            return false;
        }
        return true;
    }

    public void setStage(short stage) {
        this.stage = stage;
    }

    public void setNextStage(short nextStage) {
        this.nextStage = nextStage;
    }

    protected void parse(Quest quest) throws InvalidQuestArgsException {
        String[] args;
        this.parsedConditions.clear();
        this.parsedObjectives.clear();
        this.parsedActions.clear();
        if (this.conditions != null) {
            int i = 0;
            for (String objectiveString : this.conditions) {
                args = objectiveString.split(" ");
                this.parsedConditions.add(new Objective(args, quest, this, i++));
            }
        }
        if (this.objectives != null) {
            int j = 0;
            for (String objectiveString : this.objectives) {
                args = objectiveString.split(" ");
                this.parsedObjectives.add(new Objective(args, quest, this, j++));
            }
        }
        if (this.actions != null) {
            int k = 0;
            for (String actionString : this.actions) {
                args = actionString.split(" ");
                this.parsedActions.add(new Action(args, quest, this, k++));
            }
        }
    }

    public static Builder builder(Quest.Builder questBuilder) {
        return new Builder(questBuilder);
    }

    public void readFromByteBuf(PacketBuffer buf) {
        this.stage = buf.readShort();
        this.nextStage = buf.readShort();
        this.icon = StageIcon.getIcon(buf.readByte());
        this.conditions = new ArrayList();
        int conditionCount = buf.readShort();
        for (int i = 0; i < conditionCount; ++i) {
            this.conditions.add(buf.func_218666_n());
        }
        this.objectives = new ArrayList();
        int objectiveCount = buf.readShort();
        for (int i = 0; i < objectiveCount; ++i) {
            this.objectives.add(buf.func_218666_n());
        }
        this.actions = new ArrayList();
        int actionCount = buf.readShort();
        for (int i = 0; i < actionCount; ++i) {
            this.actions.add(buf.func_218666_n());
        }
    }

    public void writeToByteBuf(PacketBuffer buf) {
        buf.writeShort((int)this.stage);
        buf.writeShort((int)this.nextStage);
        buf.writeByte(this.getIcon().ordinal());
        buf.writeShort(this.conditions.size());
        for (String condition : this.conditions) {
            buf.func_180714_a(condition);
        }
        buf.writeShort(this.objectives.size());
        for (String objective : this.objectives) {
            buf.func_180714_a(objective);
        }
        buf.writeShort(this.actions.size());
        for (String action : this.actions) {
            buf.func_180714_a(action);
        }
    }

    public static class Builder {
        private final Quest.Builder questBuilder;
        private final Stage stage;

        public Builder(Quest.Builder questBuilder) {
            this.questBuilder = questBuilder;
            this.stage = new Stage();
        }

        public Builder setStage(short stage) {
            this.stage.stage = stage;
            return this;
        }

        public Builder setNextStage(short nextStage) {
            this.stage.nextStage = nextStage;
            return this;
        }

        public Builder setStage(int stage) {
            this.stage.stage = (short)stage;
            return this;
        }

        public Builder setNextStage(int nextStage) {
            this.stage.nextStage = (short)nextStage;
            return this;
        }

        public Builder addCondition(String condition) {
            this.stage.conditions.add(condition);
            return this;
        }

        public Builder addObjective(String objective) {
            this.stage.objectives.add(objective);
            return this;
        }

        public Builder addAction(String action) {
            this.stage.actions.add(action);
            return this;
        }

        public Quest.Builder build() {
            this.questBuilder.addStage(this.stage);
            return this.questBuilder;
        }
    }
}

