/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.editor.args;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.math.NumberUtils;

public enum ArgumentType {
    WHOLE_NUMBER,
    DECIMAL_NUMBER,
    TEXT,
    SPACED_TEXT,
    REGISTRY_KEY,
    ENTITY_UUID,
    BOOLEAN,
    SUCCESS,
    ITEM,
    TYPE,
    DATE;


    public boolean isValidInput(String input) {
        switch (this) {
            case WHOLE_NUMBER: {
                if (input.startsWith("-")) {
                    input = input.substring(1);
                }
                return NumberUtils.isDigits((String)input);
            }
            case DECIMAL_NUMBER: {
                return NumberUtils.isParsable((String)input);
            }
            case TEXT: 
            case SPACED_TEXT: {
                return !input.isEmpty();
            }
            case REGISTRY_KEY: {
                return input.contains(":");
            }
            case ENTITY_UUID: {
                String[] components = input.split("-");
                return components.length == 5;
            }
            case BOOLEAN: {
                return input.equalsIgnoreCase("true") || input.equalsIgnoreCase("false");
            }
            case SUCCESS: {
                return input.equalsIgnoreCase("success") || input.equalsIgnoreCase("failure");
            }
            case ITEM: {
                return ForgeRegistries.ITEMS.getValue(ResourceLocation.func_208304_a((String)input)) != null;
            }
            case TYPE: {
                for (Element type : Element.getAllTypes()) {
                    if (!type.getName().equalsIgnoreCase(input)) continue;
                    return true;
                }
                return false;
            }
            case DATE: {
                return input.split("/").length == 2;
            }
        }
        return false;
    }
}

