/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.listener;

import com.pixelmonmod.pixelmon.advancements.PixelmonAdvancements;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.economy.BankAccountProxy;
import com.pixelmonmod.pixelmon.api.pokemon.LearnMoveController;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.trading.NPCTrades;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.BattleQuery;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.teamselection.TeamSelectionRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ServerConfigListPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ServerCosmeticsUpdatePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.UpdateClientRulesPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.UpdateClientPlayerDataPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.SetTempMode;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.SendEntireDayCarePacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DropItemQueryList;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQuery;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQueryList;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.GameRules;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PixelmonPlayerTracker {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.getPlayer() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        PlayerPartyStorage party = StorageProxy.getParty(player);
        NetworkHelper.sendPacket(new ServerConfigListPacket(), player);
        NetworkHelper.sendPacket(new ServerCosmeticsUpdatePacket(party.getServerCosmetics()), player);
        party.playerPokedex.checkForCharms();
        NetworkHelper.sendPacket(new SetTempMode(party.inTemporaryMode(), party.getTempPartyColor()), player);
        for (int i = 0; i < 6; ++i) {
            party.notifyListeners(new StoragePosition(-1, i), party.get(i), EnumUpdateType.CLIENT);
        }
        PixelmonPlayerTracker.removePlayer(player);
        NetworkHelper.sendPacket(new SendEntireDayCarePacket(party.getDayCare()), player);
        if (PixelmonConfigProxy.getGeneral().isAlwaysHaveMegaRing()) {
            try {
                if (!party.getMegaItemsUnlocked().canMega()) {
                    party.setMegaItem(EnumMegaItem.BraceletORAS, false);
                    party.unlockMega(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (PixelmonConfigProxy.getGeneral().isAlwaysHaveDynamaxBand()) {
            try {
                if (!party.getMegaItemsUnlocked().canDynamax()) {
                    party.setMegaItem(EnumMegaItem.DynamaxBand, false);
                    party.unlockDynamax(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BankAccountProxy.getBankAccount(player).get().updatePlayer();
        NetworkHelper.sendPacket(new UpdateClientPlayerDataPacket(party.trainerCardColor), player);
        party.playerPokedex.update();
        NetworkHelper.sendPacket(new UpdateClientRulesPacket(), player);
        PixelmonAdvancements.POKEDEX_TRIGGER.trigger(player);
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity) {
            PixelmonPlayerTracker.removePlayer((ServerPlayerEntity)player);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        Entity eventEntity = event.getEntity();
        if (event.getEntity() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            if (!player.func_71121_q().func_82736_K().func_223586_b(GameRules.field_223600_c)) {
                StorageProxy.getParty(player).dropLureInLureSlot(player);
            }
            PixelmonPlayerTracker.removePlayer((ServerPlayerEntity)eventEntity);
        }
    }

    public static void removePlayer(ServerPlayerEntity player) {
        EvolutionQuery eq;
        StorageProxy.getParty(player).retrieveAll("Forced");
        BattleQuery bq = BattleQuery.getQuery(player);
        if (bq != null) {
            bq.declineQuery(player);
        }
        if ((eq = EvolutionQueryList.get((PlayerEntity)player)) != null) {
            EvolutionQueryList.declineQuery(player, eq.pokemonUUID);
        }
        DropItemQueryList.removeQuery(player);
        BattleController bc = BattleRegistry.getBattle((PlayerEntity)player);
        if (bc != null) {
            if (bc.hasSpectator((PlayerEntity)player)) {
                bc.removeSpectator(player);
            } else {
                bc.endBattle(BattleEndCause.FORCE);
            }
        }
        LearnMoveController.clearLearnMoves(player);
        TeamSelectionRegistry.removeSelection(player);
        NPCTrades.clearTradePair(player.func_110124_au());
    }
}

