/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.medicine;

import com.pixelmonmod.pixelmon.api.pokemon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.WrapperLink;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.items.IMedicine;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import com.pixelmonmod.pixelmon.items.group.PixelmonItemGroups;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;

public abstract class MedicineItem
extends PixelmonItem {
    private final IMedicine[] healMethods;
    private int friendshipDecreaseNormal;
    private int friendshipDecreaseHigh;

    public MedicineItem(IMedicine ... healMethods) {
        super(new Item.Properties().func_200917_a(16).func_200916_a(PixelmonItemGroups.TAB_RESTORATION));
        this.healMethods = healMethods;
    }

    public MedicineItem setFriendshipDecrease(int normal, int high) {
        this.friendshipDecreaseNormal = normal;
        this.friendshipDecreaseHigh = high;
        return this;
    }

    @Override
    public boolean useFromBag(PixelmonWrapper pixelmonWrapper, PixelmonWrapper target, ItemStack stack, int additionalInfo) {
        this.useMedicine(new WrapperLink(target), additionalInfo);
        return super.useFromBag(pixelmonWrapper, target, stack, additionalInfo);
    }

    public boolean useMedicine(PokemonLink target, int additionalInfo) {
        boolean success = false;
        for (IMedicine healMethod : this.healMethods) {
            success = healMethod.useMedicine(target) || success;
        }
        if (success) {
            int friendship = target.getFriendship();
            target.adjustFriendship(friendship >= 200 ? -this.friendshipDecreaseHigh : -this.friendshipDecreaseNormal);
        } else {
            target.sendMessage("pixelmon.general.noeffect", new Object[0]);
        }
        return success;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity playerIn, Hand hand) {
        return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(hand));
    }
}

