/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Gluttony;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Ripen;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.BerryType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.heldItems.BerryItem;
import net.minecraft.item.Item;

public class BerryStatIncreaseItem
extends BerryItem {
    private final BattleStatsType stat;

    public BerryStatIncreaseItem(Item.Properties properties, BerryType berry, BattleStatsType stat) {
        super(properties, EnumHeldItems.berryStatIncrease, berry);
        this.stat = stat;
    }

    @Override
    public void tookDamage(PixelmonWrapper attacker, PixelmonWrapper defender, float damage, DamageTypeEnum damageType) {
        int lowHealth;
        int n = lowHealth = defender.getBattleAbility() instanceof Gluttony ? 50 : 25;
        if (defender.isAlive() && defender.getHealthPercent() <= (float)lowHealth) {
            this.eatBerry(defender);
        }
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        if (newPokemon.getHealthPercent() <= 25.0f) {
            this.eatBerry(newPokemon);
        }
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        this.applySwitchInEffect(pw);
    }

    @Override
    public void eatBerry(PixelmonWrapper pokemon) {
        if (BerryStatIncreaseItem.canEatBerry(pokemon)) {
            boolean ripened = pokemon.getBattleAbility().isAbility((Class<? extends AbstractAbility>)Ripen.class);
            pokemon.bc.sendToAll("pixelmon.helditems.pinchberry", pokemon.getNickname(), pokemon.getHeldItem().getLocalizedName());
            if (this.stat != null) {
                pokemon.getBattleStats().modifyStat(ripened ? 2 : 1, this.stat);
            } else if (this.getBerry() == BerryType.STARF) {
                pokemon.getBattleStats().raiseRandomStat(ripened ? 4 : 2);
            } else if (this.getBerry() == BerryType.LANSAT) {
                pokemon.getBattleStats().increaseCritStage(ripened ? 4 : 2, false);
            }
            if (ripened) {
                pokemon.bc.sendToAll("pixelmon.abilities.ripen", pokemon.getNickname(), this.getLocalizedName());
            }
            super.eatBerry(pokemon);
            pokemon.consumeItem();
        }
    }
}

