/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MagicGuard;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Ripen;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.BerryType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.heldItems.BerryItem;
import net.minecraft.item.Item;

public class BerryRecoilItem
extends BerryItem {
    private AttackCategory attackCategory;

    public BerryRecoilItem(Item.Properties properties, EnumHeldItems berryType, BerryType berry, AttackCategory attackCategory) {
        super(properties, berryType, berry);
        this.attackCategory = attackCategory;
    }

    @Override
    public void postProcessDamagingAttackTarget(PixelmonWrapper attacker, PixelmonWrapper target, Attack attack, float damage) {
        if (BerryRecoilItem.canEatBerry(target) && damage > 0.0f && attack.getAttackCategory() == this.attackCategory && attacker.isAlive() && !(attacker.getBattleAbility() instanceof MagicGuard)) {
            boolean ripened = target.getBattleAbility().isAbility((Class<? extends AbstractAbility>)Ripen.class);
            attacker.bc.sendToAll("pixelmon.helditems.recoilberry", target.getNickname(), target.getHeldItem().getLocalizedName(), attacker.getNickname());
            if (ripened) {
                target.bc.sendToAll("pixelmon.abilities.ripen", target.getNickname(), this.getLocalizedName());
            }
            attacker.doBattleDamage(target, attacker.getPercentMaxHealth(ripened ? 25.0f : 12.5f), DamageTypeEnum.ITEM);
            this.eatBerry(target);
            target.consumeItem();
        }
    }
}

