/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.enums.EnumFeatureState;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class KeyItem
extends PixelmonItem {
    private final EnumKeyItem item;

    public KeyItem(EnumKeyItem item) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f));
        this.item = item;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!worldIn.field_72995_K) {
            PlayerPartyStorage pps = StorageProxy.getParty(playerIn.func_110124_au());
            boolean given = false;
            switch (this.item) {
                case KeyStone: {
                    if (pps.getMegaItemsUnlocked().canMega()) break;
                    pps.unlockMega(true);
                    OpenScreenPacket.open((PlayerEntity)pps.getPlayer(), EnumGuiScreen.MegaItem, new int[0]);
                    given = true;
                    break;
                }
                case WishingStar: {
                    if (pps.getMegaItemsUnlocked().canDynamax()) break;
                    pps.unlockDynamax(true);
                    OpenScreenPacket.open((PlayerEntity)pps.getPlayer(), EnumGuiScreen.MegaItem, 1);
                    given = true;
                    break;
                }
                case OvalCharm: {
                    if (pps.getOvalCharm().isAvailable()) break;
                    pps.setOvalCharm(EnumFeatureState.Active);
                    OpenScreenPacket.open((PlayerEntity)pps.getPlayer(), EnumGuiScreen.OvalCharm, new int[0]);
                    given = true;
                    break;
                }
                case ShinyCharm: {
                    if (pps.getShinyCharm().isAvailable()) break;
                    pps.setShinyCharm(EnumFeatureState.Active);
                    OpenScreenPacket.open((PlayerEntity)pps.getPlayer(), EnumGuiScreen.ShinyCharm, new int[0]);
                    given = true;
                    break;
                }
                case ExpCharm: {
                    if (pps.getExpCharm().isAvailable()) break;
                    pps.setExpCharm(EnumFeatureState.Active);
                    OpenScreenPacket.open((PlayerEntity)pps.getPlayer(), EnumGuiScreen.ExpCharm, new int[0]);
                    given = true;
                    break;
                }
                case CatchingCharm: {
                    if (pps.getCatchingCharm().isAvailable()) break;
                    pps.setCatchingCharm(EnumFeatureState.Active);
                    OpenScreenPacket.open((PlayerEntity)pps.getPlayer(), EnumGuiScreen.CatchingCharm, new int[0]);
                    given = true;
                    break;
                }
                case MarkCharm: {
                    if (pps.getMarkCharm().isAvailable()) break;
                    pps.setMarkCharm(EnumFeatureState.Active);
                    OpenScreenPacket.open((PlayerEntity)pps.getPlayer(), EnumGuiScreen.MarkCharm, new int[0]);
                    given = true;
                }
            }
            if (given) {
                if (!playerIn.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
            }
            playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("pixelmon.items.alreadyhave").func_240699_a_(TextFormatting.GRAY), Util.field_240973_b_);
            return new ActionResult(ActionResultType.FAIL, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public static enum EnumKeyItem {
        KeyStone("key_stone"),
        ShinyCharm("shiny_charm"),
        OvalCharm("oval_charm"),
        WishingStar("wishing_star"),
        ExpCharm("exp_charm"),
        CatchingCharm("catching_charm"),
        MarkCharm("mark_charm");

        private final String name;

        private EnumKeyItem(String name) {
            this.name = name;
        }
    }
}

