/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums.items;

import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.ModelHolder;
import com.pixelmonmod.pixelmon.client.render.tileEntities.SharedModels;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public enum EnumFossils {
    NULL(-1, 0, null, ""),
    HELIX(0, 1, PixelmonSpecies.OMANYTE::getValueUnsafe, "helix_fossil"),
    DOME(1, 1, PixelmonSpecies.KABUTO::getValueUnsafe, "dome_fossil"),
    OLD_AMBER(2, 1, PixelmonSpecies.AERODACTYL::getValueUnsafe, "old_amber"),
    ROOT(3, 3, PixelmonSpecies.LILEEP::getValueUnsafe, "root_fossil"),
    CLAW(4, 3, PixelmonSpecies.ANORITH::getValueUnsafe, "claw_fossil"),
    SKULL(5, 4, PixelmonSpecies.CRANIDOS::getValueUnsafe, "skull_fossil"),
    ARMOR(6, 4, PixelmonSpecies.SHIELDON::getValueUnsafe, "armor_fossil"),
    COVER(7, 5, PixelmonSpecies.TIRTOUGA::getValueUnsafe, "cover_fossil"),
    PLUME(8, 5, PixelmonSpecies.ARCHEN::getValueUnsafe, "plume_fossil"),
    JAW(9, 6, PixelmonSpecies.TYRUNT::getValueUnsafe, "jaw_fossil"),
    SAIL(10, 6, PixelmonSpecies.AMAURA::getValueUnsafe, "sail_fossil"),
    BIRD(11, 8, () -> null, "bird_fossil", "gen8_individual"),
    DINO(12, 8, () -> null, "dino_fossil", "gen8_individual"),
    DRAKE(13, 8, () -> null, "drake_fossil", "gen8_individual"),
    FISH(14, 8, () -> null, "fish_fossil", "gen8_individual"),
    DZ(-2, 8, PixelmonSpecies.DRACOZOLT::getValueUnsafe, "", "gen8_combined"),
    AZ(-3, 8, PixelmonSpecies.ARCTOZOLT::getValueUnsafe, "", "gen8_combined"),
    DV(-4, 8, PixelmonSpecies.DRACOVISH::getValueUnsafe, "", "gen8_combined"),
    AV(-5, 8, PixelmonSpecies.ARCTOVISH::getValueUnsafe, "", "gen8_combined");

    private int index;
    private int generation;
    private Supplier<Species> pokemon;
    private String itemName;
    private ResourceLocation texture;

    private EnumFossils(int index, int generation, Supplier<Species> pokemon, String itemName) {
        this.index = index;
        this.generation = generation;
        this.pokemon = pokemon;
        this.itemName = itemName;
        this.texture = ResourceLocationHelper.of("pixelmon", "textures/fossils/" + this.name().toLowerCase(Locale.ROOT) + "_fossilmodel.png");
    }

    private EnumFossils(int index, int generation, Supplier<Species> pokemon, String itemName, String texLoc) {
        this.index = index;
        this.generation = generation;
        this.pokemon = pokemon;
        this.itemName = itemName;
        this.texture = ResourceLocationHelper.of("pixelmon", "textures/fossils/" + texLoc + "_fossilmodel.png");
    }

    public static EnumFossils fromIndex(int curFos) {
        for (EnumFossils f : EnumFossils.values()) {
            if (f.index != curFos) continue;
            return f;
        }
        return NULL;
    }

    public int getIndex() {
        return this.index;
    }

    public int getGeneration() {
        return this.generation;
    }

    public Species getPokemon() {
        return this.pokemon == null ? null : this.pokemon.get();
    }

    public String getItemName() {
        return this.itemName;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public Item getItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.func_208304_a((String)("pixelmon:" + this.getItemName())));
    }

    public ModelHolder getModel() {
        switch (this) {
            case HELIX: {
                return SharedModels.helixFossil;
            }
            case DOME: {
                return SharedModels.domeFossil;
            }
            case OLD_AMBER: {
                return SharedModels.oldAmber;
            }
            case ROOT: {
                return SharedModels.rootFossil;
            }
            case CLAW: {
                return SharedModels.clawFossil;
            }
            case SKULL: {
                return SharedModels.skullFossil;
            }
            case ARMOR: {
                return SharedModels.armorFossil;
            }
            case COVER: {
                return SharedModels.coverFossil;
            }
            case PLUME: {
                return SharedModels.plumeFossil;
            }
            case JAW: {
                return SharedModels.jawFossil;
            }
            case SAIL: {
                return SharedModels.sailFossil;
            }
            case BIRD: {
                return SharedModels.birdFossil;
            }
            case DINO: {
                return SharedModels.dinoFossil;
            }
            case DRAKE: {
                return SharedModels.drakeFossil;
            }
            case FISH: {
                return SharedModels.fishFossil;
            }
            case DZ: {
                return SharedModels.dzFossil;
            }
            case AZ: {
                return SharedModels.azFossil;
            }
            case DV: {
                return SharedModels.dvFossil;
            }
            case AV: {
                return SharedModels.avFossil;
            }
        }
        return SharedModels.helixFossil;
    }
}

