/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.moveSkills;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.config.GeneralConfig;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.IlluminatePositionsPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class OreSense {
    public static int durationTicks = 300;
    public static int maxSearchRadius = 10;

    public static MoveSkill createMoveSkill() {
        MoveSkill moveSkill = new MoveSkill("ore_sense").setName("pixelmon.moveskill.ore_sense").describe("pixelmon.moveskill.ore_sense.description1", "pixelmon.moveskill.ore_sense.description2").setIcon(ResourceLocationHelper.of("pixelmon", "textures/gui/overlay/externalmoves/oresense.png")).setAnyMoves("Magnet Rise", "Metal Sound", "Steel Beam").setIntrinsicSpecs(Lists.newArrayList((Object[])new PokemonSpecification[]{PokemonSpecificationProxy.create("ab:MagnetPull")})).setDefaultCooldownTicks(2400).setUsePP(true);
        return moveSkill.setBehaviourNoTarget(pixelmon -> {
            final World world = pixelmon.field_70170_p;
            final BlockPos middle = pixelmon.func_233580_cy_();
            new Timer(true).schedule(new TimerTask((PixelmonEntity)pixelmon){
                BlockPos.Mutable pos = new BlockPos.Mutable(0, 0, 0);
                final /* synthetic */ PixelmonEntity val$pixelmon;
                {
                    this.val$pixelmon = pixelmonEntity;
                }

                @Override
                public void run() {
                    ArrayList<BlockPos> oreLocations = new ArrayList<BlockPos>();
                    for (int x = middle.func_177958_n() - maxSearchRadius; x <= middle.func_177958_n() + maxSearchRadius; ++x) {
                        for (int y = middle.func_177956_o() - maxSearchRadius; y <= middle.func_177956_o() + maxSearchRadius; ++y) {
                            for (int z = middle.func_177952_p() - maxSearchRadius; z <= middle.func_177952_p() + maxSearchRadius; ++z) {
                                BlockState state = world.func_180495_p((BlockPos)this.pos.func_181079_c(x, y, z));
                                if (!OreSense.isAnOre(state.func_177230_c())) continue;
                                oreLocations.add(new BlockPos((Vector3i)this.pos));
                            }
                        }
                    }
                    world.func_73046_m().execute(() -> {
                        ServerPlayerEntity player = (ServerPlayerEntity)this.val$pixelmon.getOwner();
                        if (player == null) {
                            return;
                        }
                        HashMap<BlockPos, GeneralConfig.OreColor> locationColors = new HashMap<BlockPos, GeneralConfig.OreColor>();
                        for (BlockPos pos : oreLocations) {
                            GeneralConfig.OreColor entry;
                            int color;
                            Block block = world.func_180495_p(pos).func_177230_c();
                            if (block.getRegistryName() == null || (color = (entry = PixelmonConfigProxy.getGeneral().getEntryForBlock(block.getRegistryName().toString())).getColor()) == -1) continue;
                            locationColors.put(pos, entry);
                        }
                        if (locationColors.isEmpty()) {
                            ChatHandler.sendFormattedChat((ICommandSource)this.val$pixelmon.getOwner(), TextFormatting.RED, "pixelmon.moveskill.ore_sense.none", new Object[0]);
                        } else {
                            ChatHandler.sendFormattedChat((ICommandSource)this.val$pixelmon.getOwner(), TextFormatting.WHITE, "pixelmon.moveskill.ore_sense.some", this.val$pixelmon.func_145748_c_());
                            NetworkHelper.sendPacket(new IlluminatePositionsPacket(world, durationTicks, locationColors), player);
                        }
                    });
                }
            }, 1L);
            return moveSkill.cooldownTicks;
        });
    }

    private static boolean isAnOre(Block block) {
        if (block.getRegistryName() != null) {
            String blockName = block.getRegistryName().toString();
            return PixelmonConfigProxy.getGeneral().getEntryForBlock(blockName) != null;
        }
        return false;
    }
}

