/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.dimensions.Dimensions;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.GenderProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.ModelLocator;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.type.FlyingModelPredicate;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelSmd;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.models.smd.SmdAnimation;
import com.pixelmonmod.pixelmon.client.models.smd.SmdAnimationSequence;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.client.render.TexturedEntity;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor.UpdateClientEditingStatuePacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractBaseEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractClientEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.AnimationVariables;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.IncrementingVariable;
import com.pixelmonmod.pixelmon.enums.EnumBoundingBoxMode;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumStatueTextureType;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StatueEntity
extends AbstractClientEntity
implements TexturedEntity {
    public static final int parameterId = Pokemon.SYNC_POKEMON_BASE.getParameterId();
    public static final int parameterId2 = Pokemon.SYNC_GROWTH.getParameterId();
    public static final DataSync<StatueEntity, EnumBoundingBoxMode> SYNC_BOUND_MODE = new DataSync<StatueEntity, EnumBoundingBoxMode>(StatueEntity.class, PixelmonDataSerializers.BOUNDING_BOX_MODE, (statueEntity, enumBoundingBoxMode) -> {
        statueEntity.boundingMode = enumBoundingBoxMode;
        statueEntity.func_174826_a(statueEntity.getForm().getDimensions().createBoundingBox((Entity)statueEntity, statueEntity.func_213355_cm()));
    });
    public static final DataSync<StatueEntity, String> SYNC_LABEL = new DataSync<StatueEntity, String>(StatueEntity.class, DataSerializers.field_187194_d, (statueEntity, s) -> {
        statueEntity.label = s;
    });
    public static final DataSync<StatueEntity, EnumStatueTextureType> SYNC_TEXTURES = new DataSync<StatueEntity, EnumStatueTextureType>(StatueEntity.class, PixelmonDataSerializers.STATUE_TEXTURE_TYPE, (statueEntity, s) -> {
        statueEntity.textureMode = s;
    });
    public static final DataSync<StatueEntity, AnimationType> SYNC_ANIMATION = new DataSync<StatueEntity, AnimationType>(StatueEntity.class, PixelmonDataSerializers.ANIMATION_TYPE, (statueEntity, s) -> {
        statueEntity.animation = s;
    });
    public static final DataSync<StatueEntity, Integer> SYNC_ANIMATION_FRAME = new DataSync<StatueEntity, Integer>(StatueEntity.class, DataSerializers.field_187192_b, (statueEntity, s) -> {
        statueEntity.animationFrame = s;
    });
    public static final DataSync<StatueEntity, Boolean> SYNC_IS_FLYING = new DataSync<StatueEntity, Boolean>(StatueEntity.class, DataSerializers.field_187198_h, (statueEntity, s) -> {
        statueEntity.isFlying = s;
    });
    public static final DataSync<StatueEntity, Boolean> SYNC_CAN_MOVE = new DataSync<StatueEntity, Boolean>(StatueEntity.class, DataSerializers.field_187198_h, (statueEntity, s) -> {
        statueEntity.canMove = s;
    });
    private EnumBoundingBoxMode boundingMode = EnumBoundingBoxMode.Solid;
    private String label = "";
    private EnumStatueTextureType textureMode = EnumStatueTextureType.OriginalTexture;
    private AnimationType animation = AnimationType.IDLE;
    private int animationFrame = 0;
    private boolean isFlying = false;
    private boolean canMove = false;
    private AnimationType lastAnimation = null;
    private int lastFrame = -1;
    private AnimationVariables animationVariables;
    private ResourceLocation lastTexture;
    private final boolean exists = true;

    public StatueEntity(EntityType<StatueEntity> type, World world) {
        super((EntityType<? extends AbstractClientEntity>)type, world);
    }

    public StatueEntity(World world) {
        this((EntityType<StatueEntity>)((EntityType)EntityRegistration.STATUE.get()), world);
        this.func_189654_d(true);
    }

    @Override
    protected void func_70088_a() {
        this.define(SYNC_LABEL, "");
        this.define(SYNC_TEXTURES, EnumStatueTextureType.OriginalTexture);
        this.define(SYNC_ANIMATION, AnimationType.IDLE);
        this.define(SYNC_ANIMATION_FRAME, 0);
        this.define(SYNC_IS_FLYING, false);
        this.define(SYNC_CAN_MOVE, false);
        super.func_70088_a();
        this.define(SYNC_BOUND_MODE, EnumBoundingBoxMode.Solid);
    }

    public void func_70636_d() {
    }

    public boolean func_70781_l() {
        return false;
    }

    public boolean func_175446_cd() {
        return true;
    }

    protected void func_70619_bc() {
    }

    public boolean func_70613_aW() {
        return false;
    }

    @Override
    public void setPokemon(Pokemon pokemon) {
        PokemonBase.SYNC_POKEMON_BASE.set((Entity)this, (Object)pokemon);
    }

    public void setPalette(String palette) {
        PokemonBase.SYNC_POKEMON_BASE.set((Entity)this, (Object)new PokemonBase(this.getSpecies(), this.getForm(), this.getGenderProperties().getPalette(palette), this.getGender()));
    }

    protected void setPokemon(PokemonBase pokemon) {
        this.pokemon = pokemon.toPokemon();
        this.initAnimation();
    }

    public void setBoundingMode(EnumBoundingBoxMode boundingMode) {
        SYNC_BOUND_MODE.set((Entity)this, (Object)boundingMode);
    }

    public EnumBoundingBoxMode getBoundingMode() {
        return this.boundingMode;
    }

    public void setCanMove(boolean canMove) {
        SYNC_CAN_MOVE.set((Entity)this, (Object)canMove);
    }

    public boolean canMove() {
        return this.canMove;
    }

    public PokemonBase getPokemonBase() {
        return this.pokemon;
    }

    public void setSpecies(Species species) {
        this.setPokemon(new PokemonBase(species));
    }

    public void setSpecies(RegistryValue<Species> species) {
        species.ifInitialized(s -> this.setPokemon(new PokemonBase((Species)s)));
    }

    @Override
    public void resetDataWatchers() {
        super.resetDataWatchers();
        SYNC_BOUND_MODE.set((Entity)this, (Object)EnumBoundingBoxMode.Solid);
        SYNC_LABEL.set((Entity)this, (Object)"");
        SYNC_TEXTURES.set((Entity)this, (Object)EnumStatueTextureType.OriginalTexture);
        SYNC_ANIMATION.set((Entity)this, (Object)AnimationType.IDLE);
        SYNC_ANIMATION_FRAME.set((Entity)this, (Object)0);
        SYNC_IS_FLYING.set((Entity)this, (Object)false);
        SYNC_CAN_MOVE.set((Entity)this, (Object)false);
    }

    @Override
    public Species getSpecies() {
        return this.pokemon.getSpecies();
    }

    public void setForm(Stats form) {
        PaletteProperties palette;
        GenderProperties genderProperties = form.getGenderProperties(this.pokemon.getGender());
        if (genderProperties == null) {
            genderProperties = form.getDefaultGenderProperties();
        }
        if ((palette = genderProperties.getPalette(this.getPalette().getName())) == null) {
            palette = genderProperties.getDefaultPalette();
        }
        PokemonBase.SYNC_POKEMON_BASE.set((Entity)this, (Object)new PokemonBase(this.pokemon.getSpecies(), form, palette, this.pokemon.getGender()));
    }

    @Override
    public Stats getForm() {
        if (this.pokemon.getForm() == null) {
            PokemonBase.SYNC_POKEMON_BASE.set((Entity)this, (Object)new PokemonBase(this.getSpecies(), this.getSpecies().getDefaultForm(), this.getPalette(), this.getGender()));
        }
        return this.pokemon.getForm();
    }

    public void setGender(Gender gender) {
        PaletteProperties palette;
        GenderProperties genderProperties = this.getForm().getGenderProperties(gender);
        if (genderProperties == null) {
            genderProperties = this.getForm().getDefaultGenderProperties();
        }
        if ((palette = genderProperties.getPalette(this.getPalette().getName())) == null) {
            palette = genderProperties.getDefaultPalette();
        }
        PokemonBase.SYNC_POKEMON_BASE.set((Entity)this, (Object)new PokemonBase(this.pokemon.getSpecies(), this.pokemon.getForm(), palette, gender));
    }

    public Gender getGender() {
        return this.pokemon.getGender();
    }

    public Stats getStats() {
        return null;
    }

    public void setGrowth(EnumGrowth growth) {
        Pokemon.SYNC_GROWTH.set((Entity)this, (Object)growth);
    }

    public EnumGrowth getGrowth() {
        return this.pokemon.getGrowth();
    }

    @Override
    public void setPixelmonScale(float scale) {
        AbstractBaseEntity.SYNC_SCALE.set((Entity)this, (Object)Float.valueOf(scale));
    }

    @Override
    public float getPixelmonScale() {
        return this.scale;
    }

    public void setLabel(String label) {
        SYNC_LABEL.set((Entity)this, (Object)label);
    }

    public String getLabel() {
        return this.label;
    }

    public void setTextureType(EnumStatueTextureType type) {
        SYNC_TEXTURES.set((Entity)this, (Object)type);
    }

    public EnumStatueTextureType getTextureType() {
        return this.textureMode;
    }

    @Override
    public void setAnimation(AnimationType animationType) {
        SYNC_ANIMATION.set((Entity)this, (Object)animationType);
    }

    public AnimationType getAnimation() {
        AnimationType animationType = this.animation;
        if (animationType == null) {
            animationType = AnimationType.IDLE;
            this.setAnimation(animationType);
        }
        return animationType;
    }

    public void setAnimationFrame(int animationFrame) {
        if (animationFrame < 0) {
            animationFrame = 0;
        }
        SYNC_ANIMATION_FRAME.set((Entity)this, (Object)animationFrame);
    }

    public int getAnimationFrame() {
        return this.animationFrame;
    }

    public Stats getBaseStats() {
        return this.pokemon.getForm();
    }

    @Override
    public Color getColor() {
        return this.textureMode.color;
    }

    @Override
    public void func_70071_h_() {
        this.func_213317_d(Vector3d.field_186680_a);
        super.func_70071_h_();
        if (this.field_70173_aa % 64 == 1) {
            this.updateSize();
        }
        if (this.pokemon == null) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.isAnimated() && this.animationVariables != null) {
                this.animationVariables.tick();
                if (this.getModel() instanceof PixelmonModelSmd) {
                    PixelmonModelSmd smdModel = (PixelmonModelSmd)this.getModel();
                    IncrementingVariable inc = this.getAnimationVariables().getCounter(-1);
                    if (inc == null) {
                        this.getAnimationVariables().setCounter(-1, 2.1474836E9f, smdModel.animationIncrement);
                    } else {
                        inc.increment = smdModel.animationIncrement;
                    }
                }
            }
            if ((this.lastAnimation == null || this.lastFrame == -1 || this.lastFrame != this.getAnimationFrame() || !this.lastAnimation.equals((Object)this.getAnimation())) && this.isSmd()) {
                SmdAnimation theAnim;
                this.lastAnimation = this.getAnimation();
                this.lastFrame = this.getAnimationFrame();
                ValveStudioModel model = ((PixelmonModelSmd)this.getModel()).theModel;
                if (model == null) {
                    Pixelmon.LOGGER.error("Missing model for Statue Entity at " + this.func_213303_ch().toString() + " data: " + this.pokemon.toString());
                    return;
                }
                model.setAnimation(this.getAnimation());
                SmdAnimation smdAnimation = theAnim = model.currentSequence == null ? null : model.currentSequence.current();
                if (theAnim == null || theAnim.totalFrames == 0) {
                    return;
                }
                if (this.getAnimationFrame() >= theAnim.totalFrames) {
                    this.setAnimationFrame(theAnim.totalFrames - 1);
                }
                theAnim.setCurrentFrame(this.getAnimationFrame());
                model.animate();
                this.updateSize();
            }
        }
    }

    @Override
    public void func_70030_z() {
        if (this.getPalette() == null) {
            return;
        }
        ModelLocator[] modelLocators = this.getPalette().getModelLocators();
        if (this.field_70716_bi > 0 && !this.func_184186_bw()) {
            double d0 = this.func_226277_ct_() + (this.field_184623_bh - this.func_226277_ct_()) / (double)this.field_70716_bi;
            double d1 = this.func_226278_cu_() + (this.field_184624_bi - this.func_226278_cu_()) / (double)this.field_70716_bi;
            double d2 = this.func_226281_cx_() + (this.field_184625_bj - this.func_226281_cx_()) / (double)this.field_70716_bi;
            double d3 = MathHelper.func_76138_g((double)(this.field_184626_bk - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.field_70716_bi);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70709_bj - (double)this.field_70125_A) / (double)this.field_70716_bi);
            --this.field_70716_bi;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        } else if (!this.func_70613_aW()) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.98, 0.98, 0.98));
        }
        if (this.canMove()) {
            if (Math.abs(this.func_213322_ci().func_82615_a()) < 0.003) {
                this.func_213293_j(0.0, this.func_213322_ci().func_82617_b(), this.func_213322_ci().func_82616_c());
            }
            if (Math.abs(this.func_213322_ci().func_82615_a()) < 0.003) {
                this.func_213293_j(this.func_213322_ci().func_82615_a(), 0.0, this.func_213322_ci().func_82616_c());
            }
            if (Math.abs(this.func_213322_ci().func_82616_c()) < 0.003) {
                this.func_213293_j(this.func_213322_ci().func_82615_a(), this.func_213322_ci().func_82617_b(), 0.0);
            }
            this.field_70170_p.func_217381_Z().func_76320_a("travel");
            this.field_70702_br *= 0.98f;
            this.field_191988_bg *= 0.98f;
            this.func_213352_e(new Vector3d((double)this.field_70702_br, (double)this.field_70701_bs, (double)this.field_191988_bg));
            this.field_70170_p.func_217381_Z().func_76319_b();
        }
        if (this.boundingMode == EnumBoundingBoxMode.Pushout) {
            this.field_70170_p.func_217381_Z().func_76320_a("push");
            this.func_85033_bc();
            this.field_70170_p.func_217381_Z().func_76319_b();
        }
        this.field_70763_ax = this.field_70764_aw;
        this.field_70760_ar = this.field_70761_aq;
        this.field_70758_at = this.field_70759_as;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.flyingDelayCounter = 0;
        for (int i = 0; i < modelLocators.length; ++i) {
            ModelLocator modelLocator = modelLocators[i];
            if (!modelLocator.getPredicate().shouldUseModel(this)) continue;
            if (this.getModelSlot() == i) break;
            this.setModelSlot(i);
            break;
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player instanceof ServerPlayerEntity && !stack.func_190926_b() && stack.func_77973_b() == PixelmonItems.chisel.getItem()) {
            NetworkHelper.sendPacket(new UpdateClientEditingStatuePacket(this.func_110124_au()), (ServerPlayerEntity)player);
            OpenScreenPacket.open(player, EnumGuiScreen.StatueEditor, this.func_145782_y());
        }
        return ActionResultType.FAIL;
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        this.pokemon.writeToNBT(nbt);
        nbt.func_74778_a("Variant", this.pokemon.getForm().getName());
        if (this.getGrowth() != null) {
            nbt.func_74774_a("Growth", (byte)this.getGrowth().index);
        }
        nbt.func_74774_a("BoundingBoxMode", (byte)this.boundingMode.ordinal());
        nbt.func_74778_a("statueLabel", this.getLabel());
        nbt.func_74774_a("statueTexture", (byte)this.getTextureType().ordinal());
        nbt.func_74778_a("statueAnimation", this.getAnimation().toString().toLowerCase(Locale.ROOT));
        nbt.func_74768_a("statueFrame", this.getAnimationFrame());
        nbt.func_74757_a("Animate", this.isAnimated());
        nbt.func_74757_a("statueModelType", !this.getIsFlying());
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        Pokemon pokemon = PokemonFactory.create(nbt);
        PokemonBase.SYNC_POKEMON_BASE.set((Entity)this, (Object)pokemon);
        if (nbt.func_74764_b("Growth")) {
            this.setGrowth(EnumGrowth.getFromNBT(nbt));
        }
        if (nbt.func_74764_b("BoundingBoxMode")) {
            SYNC_BOUND_MODE.set((Entity)this, (Object)EnumBoundingBoxMode.values()[nbt.func_74771_c("BoundingBoxMode")]);
        }
        if (nbt.func_74764_b("statueLabel")) {
            this.setLabel(nbt.func_74779_i("statueLabel"));
        }
        if (nbt.func_74764_b("statueTexture")) {
            this.setTextureType(EnumStatueTextureType.getFromOrdinal(nbt.func_74771_c("statueTexture")));
        }
        if (nbt.func_74764_b("statueAnimation")) {
            this.setAnimation(AnimationType.getTypeFor(nbt.func_74779_i("statueAnimation")));
            this.setAnimationFrame(nbt.func_74762_e("statueFrame"));
            this.setIsFlying(!nbt.func_74767_n("statueModelType"));
            this.setAnimated(nbt.func_74767_n("Animate"));
        }
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.getSpecies().getLocalizedName());
    }

    @Override
    public boolean func_213397_c(double p_213397_1_) {
        return false;
    }

    @Override
    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_241845_aY() {
        return this.boundingMode == EnumBoundingBoxMode.Solid;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76380_i) {
            this.func_70106_y();
            return true;
        }
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)PixelmonItems.chisel.getItem());
    }

    @Override
    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        this.updateSize();
    }

    @Override
    public float func_213307_e(Pose p_213307_1_) {
        float scaleFactor = PixelmonConfigProxy.getGraphics().isScaleModelsUp() ? 1.3f : 1.0f;
        float scale = this.getPixelmonScale() * scaleFactor * this.getScaleFactor();
        Dimensions data = this.getBaseStats().getDimensions();
        return data.getEyeHeight() * scale;
    }

    @Override
    public void updateSize() {
        if (this.pokemon == null || this.getBaseStats() == null) {
            return;
        }
        float scaleFactor = PixelmonConfigProxy.getGraphics().isScaleModelsUp() ? 1.3f : 1.0f;
        float scale = this.getPixelmonScale() * scaleFactor * this.getScaleFactor();
        Dimensions data = this.getBaseStats().getDimensions();
        this.setDimensions(new EntitySize((float)(data.getHeight() * (double)scale), (float)(data.getWidth() * (double)scale), false));
        this.func_174826_a(data.createBoundingBox((Entity)this, scale));
    }

    @Override
    public float getScaleFactor() {
        if (this.getGrowth() == null) {
            return 1.0f;
        }
        return (float)Math.pow(this.getGrowth().scaleValue, PixelmonConfigProxy.getGeneral().getGrowthScaleModifier());
    }

    @Override
    public ResourceLocation getTexture() {
        EnumStatueTextureType type = this.getTextureType();
        if (type.texture != null) {
            return type.texture;
        }
        if (this.getPalette() == null) {
            this.setSpecies(PixelmonSpecies.BULBASAUR);
            Pixelmon.LOGGER.warn("StatueEntity at " + this.func_213303_ch() + " " + this.field_70170_p.func_234923_W_() + " failed to load! Falling back to Bulbasaur.");
        }
        return this.getPalette().getTexture();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isSmd() {
        return this.getModel() instanceof PixelmonModelSmd;
    }

    @Override
    public AnimationType getCurrentAnimation() {
        return this.getAnimation();
    }

    @Override
    public void initAnimation() {
        Model base;
        if (this.field_70170_p.field_72995_K && (base = this.getModel()) instanceof PixelmonModelSmd) {
            ValveStudioModel model = ((PixelmonModelSmd)base).theModel;
            model.animate();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getFrameCount() {
        if (this.isSmd()) {
            ValveStudioModel model = ((PixelmonModelSmd)this.getModel()).theModel;
            if (model == null) {
                return 0;
            }
            model.setAnimation(this.getAnimation());
            SmdAnimationSequence sequence = model.currentSequence;
            return sequence == null || sequence.current() == null ? 0 : sequence.current().totalFrames;
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AnimationType nextAnimation() {
        if (this.isSmd()) {
            AnimationType animation = this.getAnimation();
            Iterator<Map.Entry<AnimationType, SmdAnimationSequence>> it = ((PixelmonModelSmd)this.getModel()).theModel.anims.entrySet().iterator();
            AnimationType first = null;
            boolean takeNext = false;
            while (it.hasNext()) {
                Map.Entry<AnimationType, SmdAnimationSequence> entry = it.next();
                AnimationType key = entry.getKey();
                if (first == null) {
                    first = key;
                }
                if (takeNext) {
                    return key;
                }
                if (!key.equals((Object)animation)) continue;
                takeNext = true;
            }
            return first;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<AnimationType> getAllAnimations() {
        ArrayList<AnimationType> animations = new ArrayList<AnimationType>();
        if (this.isSmd()) {
            animations.addAll(((PixelmonModelSmd)this.getModel()).theModel.anims.keySet());
        }
        for (ModelLocator modelLocator : this.getPalette().getModelLocators()) {
            if (!(modelLocator.getPredicate() instanceof FlyingModelPredicate)) continue;
            animations.add(AnimationType.FLY);
        }
        return animations;
    }

    @Override
    public AnimationVariables getAnimationVariables() {
        if (this.animationVariables == null) {
            this.animationVariables = new AnimationVariables();
        }
        return this.animationVariables;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Model getModel() {
        if (this.getPalette() == null) {
            return PixelmonSpecies.MISSINGNO.getValueUnsafe().getDefaultForm().getDefaultGenderProperties().getDefaultPalette().getModel(this).getModel();
        }
        if (this.getPalette().getModel(this) == null || this.getPalette().getModel(this).getModel() == null) {
            return PixelmonSpecies.MISSINGNO.getValueUnsafe().getDefaultForm().getDefaultGenderProperties().getDefaultPalette().getModel(this).getModel();
        }
        return this.getPalette().getModel(this).getModel();
    }

    public void setIsFlying(boolean isFlying) {
        SYNC_IS_FLYING.set((Entity)this, (Object)isFlying);
    }

    public boolean getIsFlying() {
        return this.isFlying;
    }
}

