/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.SpeciesHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.TerrainExamine;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractInteractionsEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public abstract class AbstractBattleEntity
extends AbstractInteractionsEntity {
    public static final DataSync<AbstractBattleEntity, Integer> SYNC_GROUP_ID = new DataSync<AbstractBattleEntity, Integer>(AbstractBattleEntity.class, DataSerializers.field_187192_b, (abstractBattleEntity, integer) -> {
        abstractBattleEntity.groupId = integer;
    });
    public BattleController battleController;
    private PixelmonWrapper pixelmonWrapper;
    public List<String> relearnableEvolutionMoves = new ArrayList<String>();
    protected int groupId;

    public AbstractBattleEntity(EntityType<? extends AbstractBattleEntity> type, World par1World) {
        super((EntityType<? extends AbstractInteractionsEntity>)type, par1World);
    }

    @Override
    protected void func_70088_a() {
        this.define(SYNC_GROUP_ID, -1);
        super.func_70088_a();
    }

    @Override
    public boolean func_213397_c(double p_213397_1_) {
        if (this.battleController != null) {
            return false;
        }
        return super.func_213397_c(p_213397_1_);
    }

    public boolean inGroup() {
        return this.groupId != -1;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        SYNC_GROUP_ID.set((Entity)this, (Object)groupId);
    }

    public void startBattle(BattleParticipant p1, BattleParticipant p2) {
        if (this.inSameFlock(p1, p2)) {
            return;
        }
        this.startBattle(p1, p2, BattleType.SINGLE);
    }

    private boolean inSameFlock(BattleParticipant p1, BattleParticipant p2) {
        if (!(p1 instanceof WildPixelmonParticipant) || !(p2 instanceof WildPixelmonParticipant)) {
            return false;
        }
        AbstractBattleEntity battleEntity1 = (AbstractBattleEntity)((WildPixelmonParticipant)p1).getEntity();
        AbstractBattleEntity battleEntity2 = (AbstractBattleEntity)((WildPixelmonParticipant)p2).getEntity();
        return battleEntity1.inGroup() && battleEntity2.inGroup() && battleEntity1.groupId == battleEntity2.groupId;
    }

    public void startBattle(BattleParticipant p1, BattleParticipant p2, BattleType battleType) {
        this.startBattle(p1, p2, new BattleRules(battleType));
    }

    public void startBattle(BattleParticipant p1, BattleParticipant p2, BattleRules rules) {
        if (this.getPokemon().getMoveset().isEmpty()) {
            this.getPokemon().getMoveset().addImmutable(this.getForm().getMoves().getMovesAtLevel(this.getPokemon().getPokemonLevel()));
        }
        for (BattleParticipant p : new BattleParticipant[]{p1, p2}) {
            if (p.countAblePokemon() > 0) continue;
            return;
        }
        try {
            p1.startedBattle = true;
            this.battleController = BattleRegistry.startBattle(new BattleParticipant[]{p1}, new BattleParticipant[]{p2}, rules);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onEndBattle() {
        if (this.getPokemon().getSpecies().is(PixelmonSpecies.BURMY) && this.pixelmonWrapper != null) {
            this.updateBurmyForm();
        }
        this.battleController = null;
        this.pixelmonWrapper = null;
        this.field_70714_bg.func_220886_b(Goal.Flag.MOVE);
        this.field_70714_bg.func_220886_b(Goal.Flag.JUMP);
        this.field_70714_bg.func_220886_b(Goal.Flag.TARGET);
        this.field_70714_bg.func_220886_b(Goal.Flag.LOOK);
    }

    private void updateBurmyForm() {
        for (PixelmonWrapper pw : this.pixelmonWrapper.getOpponentPokemon()) {
            TerrainExamine.TerrainType type = TerrainExamine.getTerrain(pw);
            if (type == TerrainExamine.TerrainType.Default) continue;
            this.setForm(SpeciesHelper.getBurmyForm(type));
            return;
        }
        this.setForm(SpeciesHelper.getBurmyForm(TerrainExamine.TerrainType.Default));
    }

    @Nullable
    public NPCTrainer getTrainer() {
        LivingEntity owner = this.getOwner();
        return owner instanceof NPCTrainer ? (NPCTrainer)owner : null;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            if ((this.getBossTier().isBoss() || this.getPokemon().isUncatchable()) && source.field_76373_n.equals("mob") && !(source.func_76364_f() instanceof PixelmonEntity)) {
                return false;
            }
            if (source.field_76373_n.equals("player") || source.field_76373_n.equals("arrow") || source.field_76373_n.equals("trident")) {
                if (!PixelmonConfigProxy.getGeneral().isCanPokemonBeHit() || this.battleController != null || this.isEvolving()) {
                    return false;
                }
                amount *= 3.0f;
            }
            if (!(this.battleController == null && !this.isEvolving() || source != DamageSource.field_76367_g && source != DamageSource.field_76369_e && source != DamageSource.field_76379_h && source != DamageSource.field_76372_a && source != DamageSource.field_76368_d && source != DamageSource.field_76371_c && source != DamageSource.field_76370_b && source != DamageSource.field_82729_p && source != DamageSource.field_82728_o && source != DamageSource.field_76376_m)) {
                return false;
            }
            boolean flag = super.func_70097_a(source, amount);
            if (this.battleController == null) {
                this.updateHealth();
            }
            Entity entity = source.func_76364_f();
            if (this.battleController == null && this.getOwner() != null) {
                this.update(EnumUpdateType.HP);
            }
            if (this.isValidTarget(entity)) {
                this.func_70624_b((LivingEntity)((MobEntity)entity));
            }
            return flag;
        }
        return false;
    }

    public List<ImmutableAttack> getAttacksAtLevel(int level) {
        return this.getForm().getMoves().getMovesAtLevel(level);
    }

    public boolean learnsAttackAtLevel(int level) {
        return !this.getForm().getMoves().getMovesAtLevel(level).isEmpty();
    }

    protected boolean isValidTarget(Entity entity) {
        return entity instanceof PixelmonEntity;
    }

    @Override
    public void func_70606_j(float par1) {
        super.func_70606_j(par1);
        if (this.battleController != null) {
            this.battleController.updatePokemonHealth();
        }
    }

    public BattleParticipant getParticipant() {
        if (this.battleController == null) {
            return null;
        }
        for (BattleParticipant p : this.battleController.participants) {
            for (PixelmonWrapper pw : p.controlledPokemon) {
                if (pw.entity != this) continue;
                return p;
            }
        }
        return null;
    }

    public PixelmonWrapper getPixelmonWrapper() {
        if (this.battleController == null) {
            return null;
        }
        if (this.pixelmonWrapper != null && this.pixelmonWrapper.bc != null) {
            return this.pixelmonWrapper;
        }
        for (BattleParticipant bp : this.battleController.participants) {
            if (bp.controlledPokemon == null) continue;
            for (PixelmonWrapper pw : bp.controlledPokemon) {
                if (pw.entity != this) continue;
                this.pixelmonWrapper = pw;
                return pw;
            }
        }
        return null;
    }

    public void setPixelmonWrapper(PixelmonWrapper newWrapper) {
        this.pixelmonWrapper = newWrapper;
    }

    @Override
    public int getPartyPosition() {
        PixelmonWrapper pw;
        int partyPosition = super.getPartyPosition();
        if (partyPosition == -1 && (pw = this.getPixelmonWrapper()) != null) {
            partyPosition = pw.getPartyPosition();
        }
        return partyPosition;
    }
}

