/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.NPCChatEvent;
import com.pixelmonmod.pixelmon.api.events.npc.NPCEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetChattingNPCTexturesPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCDataPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCEditDataPacket;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.npcs.IndexedNPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ClientNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.GeneralNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.GymNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import com.pixelmonmod.tcg.api.config.TCGConfigProxy;
import com.pixelmonmod.tcg.entity.TCGTrades;
import com.pixelmonmod.tcg.item.AdminPendantItem;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.eventbus.api.Event;

public class NPCChatting
extends IndexedNPCEntity
implements IMerchant {
    private ArrayList<String> chatPages = new ArrayList();
    boolean usingDefaultName = true;
    boolean usingDefaultChat = true;
    protected EnumNPCType npcType;
    private PlayerEntity tradingPlayer;
    protected MerchantOffers offers;
    private final Inventory inventory = new Inventory(8);

    public NPCChatting(EntityType<? extends NPCChatting> type, World world) {
        super((EntityType<? extends IndexedNPCEntity>)type, world);
        this.npcType = EnumNPCType.ChattingNPC;
    }

    public NPCChatting(World world) {
        this((EntityType<? extends NPCChatting>)((EntityType)EntityRegistration.NPC_CHATTING.get()), world);
    }

    public void init(GeneralNPCData data) {
        this.npcIndex = data.id;
        this.nameIndex = data.getRandomNameIndex();
        this.chatIndex = data.getRandomChatIndex();
        this.npcLocation = SpawnLocationType.LAND_VILLAGER;
    }

    public void init(GymNPCData data) {
        this.npcIndex = "_gym_" + data.id;
        this.nameIndex = data.getRandomNameIndex();
        this.chatIndex = data.getRandomChatIndex();
        this.npcLocation = SpawnLocationType.LAND_VILLAGER;
    }

    @Override
    public void init(String name) {
        super.init(name);
        this.setCustomSteveTexture("npcchat1.png");
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getTexture() {
        if (this.getCustomSteveTexture().contains(";")) {
            String id = this.getCustomSteveTexture().split(";")[1];
            ResourceLocation rl = ResourceLocationHelper.of("playerskins", id);
            if (Minecraft.func_71410_x().func_110434_K().func_229267_b_(rl) == null) {
                try {
                    NativeImage image = NativeImage.func_195713_a((InputStream)new URL("http://textures.minecraft.net/texture/" + id).openStream());
                    if (image.func_195714_b() < 64) {
                        int y;
                        int x;
                        NativeImage resized = new NativeImage(image.func_195702_a(), image.func_195702_a(), false);
                        for (x = 0; x < image.func_195702_a(); ++x) {
                            for (y = 0; y < image.func_195714_b(); ++y) {
                                resized.func_195700_a(x, y, image.func_195709_a(x, y));
                            }
                        }
                        for (x = 32; x < resized.func_195702_a(); ++x) {
                            for (y = 0; y < 16; ++y) {
                                int rgb = resized.func_195709_a(x, y);
                                if (rgb != -16777216) continue;
                                resized.func_195700_a(x, y, 0);
                            }
                        }
                        for (x = 0; x < 16; ++x) {
                            for (y = 16; y < 32; ++y) {
                                resized.func_195700_a(x + 16, y + 32, resized.func_195709_a(x, y));
                            }
                        }
                        for (x = 40; x < 56; ++x) {
                            for (y = 16; y < 32; ++y) {
                                resized.func_195700_a(x - 8, y + 32, resized.func_195709_a(x, y));
                            }
                        }
                        image = resized;
                    }
                    Minecraft.func_71410_x().func_110434_K().func_229263_a_(rl, (Texture)new DynamicTexture(image));
                    return rl.toString();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return DefaultPlayerSkin.func_177334_a((UUID)this.func_110124_au()).toString();
                }
            }
            return rl.toString();
        }
        return "pixelmon:textures/steve/" + this.getCustomSteveTexture();
    }

    @Override
    public String getDisplayText() {
        return "";
    }

    @Override
    public void func_70024_g(double par1, double par3, double par5) {
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a("DefaultName", this.usingDefaultName);
        nbt.func_74757_a("DefaultGreet", this.usingDefaultChat);
        nbt.func_74768_a("chatNum", this.chatPages.size());
        int i = 0;
        for (String page : this.chatPages) {
            nbt.func_74778_a("chat" + i, page);
            ++i;
        }
        MerchantOffers merchantoffers = this.func_213706_dY();
        if (!merchantoffers.isEmpty()) {
            nbt.func_218657_a("Offers", (INBT)merchantoffers.func_222199_a());
        }
        nbt.func_218657_a("Inventory", (INBT)this.inventory.func_70487_g());
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.usingDefaultName = nbt.func_74767_n("DefaultName");
        this.usingDefaultChat = nbt.func_74767_n("DefaultGreet");
        int numPages = nbt.func_74762_e("chatNum");
        for (int i = 0; i < numPages; ++i) {
            this.chatPages.add(nbt.func_74779_i("chat" + i));
        }
        if (this.getProfession() != 0) {
            this.initDefaultAI();
        }
        if (nbt.func_150297_b("Offers", 10)) {
            this.offers = new MerchantOffers(nbt.func_74775_l("Offers"));
        }
        this.inventory.func_70486_a(nbt.func_150295_c("Inventory", 10));
    }

    @Override
    public boolean interactWithNPC(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
            if (Pixelmon.EVENT_BUS.post((Event)new NPCEvent.Interact(this, this.npcType, (PlayerEntity)playerMP))) {
                return false;
            }
            String loc = playerMP.getLanguage();
            if (!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof NPCEditorItem) {
                if (!NPCEditorItem.checkPermission((PlayerEntity)playerMP)) {
                    return false;
                }
                NetworkHelper.sendPacket(new SetNPCEditDataPacket(this.getName(loc), this.getChat(loc), this.npcType), playerMP);
                NetworkHelper.sendPacket(new SetChattingNPCTexturesPacket(), playerMP);
                OpenScreenPacket.open(player, EnumGuiScreen.NPCChatEditor, this.getNPCID());
            } else if (!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof AdminPendantItem) {
                if (!NPCEditorItem.checkPermission((PlayerEntity)playerMP)) {
                    return false;
                }
                this.getPersistentData().func_74757_a("TCGTrader", !this.getPersistentData().func_74767_n("TCGTrader"));
            } else if (!this.startTradingWith(player) && !this.getChat(loc).isEmpty()) {
                NPCChatEvent event = new NPCChatEvent(this, player, this.getChat(loc));
                if (Pixelmon.EVENT_BUS.post((Event)event)) {
                    return false;
                }
                NetworkHelper.sendPacket(new SetNPCDataPacket(this.getName(loc), event.getChat(), this.npcType), (ServerPlayerEntity)player);
                OpenScreenPacket.open(player, EnumGuiScreen.NPCChat, this.getNPCID());
            }
        } else {
            this.field_70714_bg.func_220888_c().forEach(arg_0 -> ((GoalSelector)this.field_70714_bg).func_85156_a(arg_0));
        }
        return true;
    }

    @Override
    public ArrayList<String> getChat(String langCode) {
        if (this.usingDefaultChat) {
            int index = this.chatIndex;
            if (this.npcIndex.startsWith("_gym_")) {
                return new ArrayList<String>(Arrays.asList(ServerNPCRegistry.getTranslatedGymMemberChat(langCode, this.npcIndex.substring(5), index)));
            }
            return new ArrayList<String>(Arrays.asList(ServerNPCRegistry.villagers.getTranslatedChat(langCode, this.npcIndex, index)));
        }
        return this.chatPages;
    }

    @Override
    public String getName(String langCode) {
        if (this.usingDefaultName) {
            int index = this.nameIndex;
            if (this.npcIndex.startsWith("_gym_")) {
                return ServerNPCRegistry.getTranslatedGymMemberName(langCode, this.npcIndex.substring(5), index);
            }
            return ServerNPCRegistry.villagers.getTranslatedName(langCode, this.npcIndex, index);
        }
        return this.func_200200_C_().getString();
    }

    public void setChat(ArrayList<String> pages) {
        this.chatPages = pages;
        this.usingDefaultChat = false;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.usingDefaultName = false;
    }

    public void cycleTexture(ServerPlayerEntity p, ClientNPCData newData) {
        GeneralNPCData data = ServerNPCRegistry.villagers.getData(newData.getID());
        if (data == null) {
            return;
        }
        this.init(data);
        this.setTextureIndex(0);
        this.setCustomSteveTexture(newData.getTexture());
        NetworkHelper.sendPacket(new SetNPCEditDataPacket(this.getName(p.getLanguage()), this.getChat(p.getLanguage()), this.npcType), p);
    }

    public double func_233637_b_(Attribute attribute) {
        if (attribute.func_233754_c_().equalsIgnoreCase("attribute.name.generic.movement_speed")) {
            return 0.5;
        }
        return super.func_233637_b_(attribute);
    }

    public int func_213708_dV() {
        return 0;
    }

    public void func_70932_a_(@Nullable PlayerEntity p_70932_1_) {
        this.tradingPlayer = p_70932_1_;
    }

    @Nullable
    public PlayerEntity func_70931_l_() {
        return this.tradingPlayer;
    }

    public boolean isTrading() {
        return this.tradingPlayer != null;
    }

    public MerchantOffers func_213706_dY() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
        }
        return this.offers;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_213703_a(@Nullable MerchantOffers p_213703_1_) {
    }

    public void func_213702_q(int p_213702_1_) {
    }

    public void func_213704_a(MerchantOffer p_213704_1_) {
        p_213704_1_.func_222219_j();
        this.field_70757_a = -this.func_70627_aG();
        this.rewardTradeXp(p_213704_1_);
    }

    protected void rewardTradeXp(MerchantOffer p_213713_1_) {
        if (p_213713_1_.func_222221_q()) {
            int i = 3 + this.field_70146_Z.nextInt(4);
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), i));
        }
    }

    public boolean func_213705_dZ() {
        return false;
    }

    public void func_110297_a_(ItemStack p_110297_1_) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(this.getTradeUpdatedSound(!p_110297_1_.func_190926_b()), this.func_70599_aP(), this.func_70647_i());
            if (this.func_213706_dY().size() < TCGConfigProxy.getConfig().getMaxTradesPerTrader()) {
                this.updateTrades();
            }
        }
    }

    public SoundEvent func_213714_ea() {
        return SoundEvents.field_187915_go;
    }

    protected SoundEvent getTradeUpdatedSound(boolean p_213721_1_) {
        return p_213721_1_ ? SoundEvents.field_187915_go : SoundEvents.field_187913_gm;
    }

    public void playCelebrateSound() {
        this.func_184185_a(SoundEvents.field_219721_mv, this.func_70599_aP(), this.func_70647_i());
    }

    @Nullable
    public Entity changeDimension(ServerWorld p_241206_1_, ITeleporter teleporter) {
        this.stopTrading();
        return super.changeDimension(p_241206_1_, teleporter);
    }

    protected void stopTrading() {
        this.func_70932_a_(null);
    }

    public void func_70645_a(DamageSource p_70645_1_) {
        super.func_70645_a(p_70645_1_);
        this.stopTrading();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void addParticlesAroundSelf(IParticleData p_213718_1_) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a(p_213718_1_, this.func_226282_d_(1.0), this.func_226279_cv_() + 1.0, this.func_226287_g_(1.0), d0, d1, d2);
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public boolean func_174820_d(int p_174820_1_, ItemStack p_174820_2_) {
        if (super.func_174820_d(p_174820_1_, p_174820_2_)) {
            return true;
        }
        int i = p_174820_1_ - 300;
        if (i >= 0 && i < this.inventory.func_70302_i_()) {
            this.inventory.func_70299_a(i, p_174820_2_);
            return true;
        }
        return false;
    }

    protected void updateTrades() {
        VillagerTrades.ITrade[] trades;
        if (this.getPersistentData().func_74767_n("TCGTrader") && (trades = (VillagerTrades.ITrade[])TCGTrades.TCG_TRADER_TRADES.get(1)) != null) {
            int i;
            VillagerTrades.ITrade trade;
            MerchantOffer merchantoffer;
            MerchantOffers merchantoffers = this.func_213706_dY();
            if (this.func_213706_dY().size() != 0 && this.func_213706_dY().size() < TCGConfigProxy.getConfig().getMaxTradesPerTrader()) {
                this.addOffersFromItemListings(merchantoffers, trades, 1);
            }
            if (this.func_213706_dY().size() == 0) {
                this.addOffersFromItemListings(merchantoffers, trades, 3);
            }
            if ((merchantoffer = (trade = trades[i = this.field_70146_Z.nextInt(trades.length)]).func_221182_a((Entity)this, this.field_70146_Z)) != null) {
                merchantoffers.add((Object)merchantoffer);
            }
        }
    }

    protected void addOffersFromItemListings(MerchantOffers p_213717_1_, VillagerTrades.ITrade[] p_213717_2_, int amountOfItemsToAdd) {
        if (amountOfItemsToAdd <= 0) {
            Pixelmon.LOGGER.warn("You tried to add 0 items to offer, this is an invalid amount");
            return;
        }
        HashSet set = Sets.newHashSet();
        if (p_213717_2_.length > amountOfItemsToAdd) {
            while (set.size() < amountOfItemsToAdd - 1) {
                set.add(this.field_70146_Z.nextInt(p_213717_2_.length));
            }
        } else {
            for (int i = 0; i < p_213717_2_.length; ++i) {
                set.add(i);
            }
        }
        for (Integer integer : set) {
            VillagerTrades.ITrade villagertrades$itrade = p_213717_2_[integer];
            MerchantOffer merchantoffer = villagertrades$itrade.func_221182_a((Entity)this, this.field_70146_Z);
            if (merchantoffer == null) continue;
            p_213717_1_.add((Object)merchantoffer);
        }
    }

    public boolean startTradingWith(PlayerEntity player) {
        if (this.func_213706_dY().isEmpty()) {
            this.updateTrades();
        }
        if (!this.getPersistentData().func_74767_n("TCGTrader") || this.func_213706_dY().isEmpty() || !this.func_70089_S() || this.isTrading()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70932_a_(player);
            this.func_213707_a(player, this.func_145748_c_(), 1);
        }
        return true;
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }
}

