/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.bikes;

import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityDataSyncManager;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.IncrementingVariable;
import com.pixelmonmod.pixelmon.enums.EnumBike;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class BikeEntity
extends AbstractHorseEntity {
    private static final DataSync<BikeEntity, EnumBike> SYNC_TYPE = new DataSync<BikeEntity, EnumBike>(BikeEntity.class, PixelmonDataSerializers.BIKE_TYPE, (bikeEntity, enumBike) -> {
        bikeEntity.bikeType = enumBike;
    });
    private static final DataSync<BikeEntity, DyeColor> SYNC_COLOR = new DataSync<BikeEntity, DyeColor>(BikeEntity.class, PixelmonDataSerializers.DYE_COLOR, (bikeEntity, dyeColor) -> {
        bikeEntity.color = dyeColor;
    });
    public boolean field_70703_bu = false;
    private int acceleratingTicks = 0;
    private boolean pushing = false;
    private float outOfControlTicks;
    public float moveStrafing;
    public float moveVertical;
    public float moveForward;
    public float randomYawVelocity;
    public IncrementingVariable inc;
    private EnumBike bikeType;
    private DyeColor color;
    protected EntityDataSyncManager dataSyncManager;
    private static int neededAccelerationTicks = 15;

    public BikeEntity(World world) {
        this((EntityType<BikeEntity>)((EntityType)EntityRegistration.BIKE.get()), world);
    }

    public BikeEntity(EntityType<BikeEntity> type, World world) {
        super(type, world);
        this.field_70138_W = 1.0f;
        this.field_70156_m = true;
    }

    protected void func_70088_a() {
        this.dataSyncManager = new EntityDataSyncManager();
        super.func_70088_a();
        this.dataSyncManager.define((Entity)this, SYNC_TYPE, EnumBike.Mach);
        this.dataSyncManager.define((Entity)this, SYNC_COLOR, EnumBike.Mach.defaultColor);
    }

    public boolean func_175446_cd() {
        return true;
    }

    public void func_110199_f(PlayerEntity p_110199_1_) {
    }

    @Nullable
    protected SoundEvent func_230274_fe_() {
        return this.func_184639_G();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return this.func_184639_G();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return this.func_184639_G();
    }

    protected void func_205715_ee() {
    }

    @Nullable
    protected SoundEvent func_184785_dv() {
        return this.func_184639_G();
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
    }

    protected void func_190680_a(SoundType p_190680_1_) {
    }

    public ITextComponent func_200200_C_() {
        if (this.func_145818_k_()) {
            return this.func_200201_e();
        }
        return this.getBikeType().getTranslatedName();
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        DataSync<?, ?> dataSync = this.dataSyncManager.getSync(key);
        if (dataSync != null) {
            dataSync.onSyncedDataUpdated(key, (Entity)this);
        }
    }

    public double func_70042_X() {
        return 0.7;
    }

    public boolean func_110248_bS() {
        return true;
    }

    public boolean func_110257_ck() {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public boolean func_82171_bF() {
        return true;
    }

    public void travel(float strafe, float up, float forward) {
        LivingEntity rider = (LivingEntity)this.func_184179_bs();
        if (rider != null) {
            strafe = rider.field_70702_br / 3.0f;
            forward = rider.field_191988_bg;
            boolean bl = this.pushing = rider.field_191988_bg > 0.0f;
            if (this.pushing && this.acceleratingTicks < 0) {
                this.acceleratingTicks = 1;
            } else if (this.pushing) {
                this.acceleratingTicks = Math.min(this.acceleratingTicks + 1, neededAccelerationTicks);
            }
        } else {
            this.pushing = false;
        }
        this.field_70177_z -= strafe * 10.0f;
        this.field_70177_z = (this.field_70177_z + 180.0f) % 360.0f - 180.0f;
        strafe = 0.0f;
        this.moveEntityRidden(strafe, forward);
        double var9 = this.func_226277_ct_() - this.field_70169_q;
        double var12 = this.func_226281_cx_() - this.field_70166_s;
        float var11 = MathHelper.func_76133_a((double)(var9 * var9 + var12 * var12)) * 4.0f;
        if (var11 > 1.0f) {
            var11 = 1.0f;
        }
    }

    private void moveEntityRidden(float strafe, float forward) {
        float f4 = Math.signum(forward) * MathHelper.func_76131_a((float)(1.0f * (float)this.acceleratingTicks / (float)neededAccelerationTicks * this.getRideSpeed()), (float)0.0f, (float)this.getRideSpeed());
        if (this.getAcceleration() == 1.0f) {
            f4 = this.getRideSpeed();
        } else if (forward < 0.0f) {
            if (this.acceleratingTicks > 2) {
                this.acceleratingTicks -= 2;
            } else {
                f4 = 0.25f * this.getRideSpeed();
                this.acceleratingTicks = 0;
                this.pushing = false;
            }
        }
        if (this.func_70090_H()) {
            double d0 = this.func_226278_cu_();
            Vector3d moveInWater = new Vector3d(0.0, (double)forward, 0.05);
            this.func_213309_a(strafe, moveInWater);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213293_j(this.func_213322_ci().field_72450_a * (double)0.8f, this.func_213322_ci().field_72448_b * (double)0.8f, this.func_213322_ci().field_72449_c * (double)0.8f);
            this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b - 0.019, this.func_213322_ci().field_72449_c);
            if (this.field_70123_F && this.func_70038_c(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b + (double)0.6f - this.func_226278_cu_() + d0, this.func_213322_ci().field_72449_c)) {
                this.func_213293_j(this.func_213322_ci().field_72450_a, 0.3f, this.func_213322_ci().field_72449_c);
            }
        } else if (this.func_180799_ab()) {
            double d0 = this.func_226278_cu_();
            Vector3d moveInLava = new Vector3d(0.0, (double)forward, (double)0.02f);
            this.func_213309_a(strafe, moveInLava);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213293_j(this.func_213322_ci().field_72450_a * 0.6, this.func_213322_ci().field_72448_b * 0.6, this.func_213322_ci().field_72449_c * 0.6);
            this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b - 0.02, this.func_213322_ci().field_72449_c);
            if (this.field_70123_F && this.func_70038_c(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b + (double)0.6f - this.func_226278_cu_() + d0, this.func_213322_ci().field_72449_c)) {
                this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c);
            }
        } else {
            float f2 = 0.5f;
            float f3 = 0.16277136f / (f2 * f2 * f2);
            Vector3d tempVector = new Vector3d(0.0, (double)forward, (double)(f4 *= f3 * 2.8f));
            this.func_213309_a(strafe, tempVector);
            f2 = 0.3f;
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            if (this.field_70170_p.field_72995_K && (!this.field_70170_p.func_175667_e(new BlockPos((int)this.func_226277_ct_(), 0, (int)this.func_226281_cx_())) || this.field_70170_p instanceof ServerWorld && !((ServerWorld)this.field_70170_p).func_72863_F().func_73149_a(this.field_70176_ah, this.field_70164_aj))) {
                if (this.func_226278_cu_() > 0.0) {
                    this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b - 0.1, this.func_213322_ci().field_72449_c);
                } else {
                    this.func_213293_j(this.func_213322_ci().field_72450_a, 0.0, this.func_213322_ci().field_72449_c);
                }
            } else {
                this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b - 0.08, this.func_213322_ci().field_72449_c);
            }
            this.func_213293_j(this.func_213322_ci().field_72450_a * (double)f2, this.func_213322_ci().field_72448_b * (double)0.98f, this.func_213322_ci().field_72449_c * (double)f2);
        }
    }

    public boolean func_225503_b_(float fallDistance, float damageMultiplier) {
        if (this.func_184179_bs() instanceof ServerPlayerEntity) {
            if (this.getBikeType() == EnumBike.Mach) {
                this.func_184179_bs().func_225503_b_(fallDistance / 1.5f, 1.0f);
            } else {
                this.func_184179_bs().func_225503_b_(fallDistance / 6.0f, damageMultiplier);
            }
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float offset = -0.1f;
            Vector3d vec3d = new Vector3d((double)offset, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.func_226277_ct_() + vec3d.field_72450_a, this.func_226278_cu_() + this.func_70042_X() + passenger.func_70033_W(), this.func_226281_cx_() + vec3d.field_72449_c);
            this.applyYawToEntity(passenger);
        }
    }

    protected void applyYawToEntity(Entity entity) {
        entity.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entity.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        entity.field_70126_B += f1 - f;
        entity.field_70177_z += f1 - f;
        entity.func_70034_d(entity.field_70177_z);
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d angle, Hand hand) {
        if (player.func_225608_bj_() || hand == Hand.OFF_HAND) {
            return ActionResultType.FAIL;
        }
        if (!this.field_70170_p.field_72995_K) {
            ItemStack held = player.func_184586_b(hand);
            if (held.func_77973_b() instanceof DyeItem) {
                this.setColor(DyeColor.getColor((ItemStack)held));
                return ActionResultType.SUCCESS;
            }
            if (!this.func_184207_aI() && player.func_184220_m((Entity)this)) {
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.FAIL;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_180431_b(source)) {
                return false;
            }
            if (this.func_70089_S() && !source.func_180136_u()) {
                ItemStack stack = new ItemStack((IItemProvider)this.getBikeType().getItem(), 1);
                if (this.getColor() != this.getBikeType().defaultColor) {
                    stack.func_77982_d(new CompoundNBT());
                    this.func_213281_b(stack.func_77978_p());
                }
                ItemEntity drop = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack);
                drop.func_92058_a(stack);
                drop.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                this.field_70170_p.func_217376_c((Entity)drop);
            }
            this.func_241204_bJ_();
        }
        return true;
    }

    public Vector3d func_230268_c_(LivingEntity passenger) {
        if (this.func_184196_w((Entity)passenger)) {
            return super.func_230268_c_(passenger);
        }
        return new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
    }

    public AxisAlignedBB getCollisionBoundingBox() {
        return this.func_70104_M() ? this.func_174813_aQ() : null;
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    public boolean func_70104_M() {
        return true;
    }

    public void func_70037_a(CompoundNBT compound) {
        this.setType(EnumBike.values()[compound.func_74771_c("type")]);
        if (compound.func_74764_b("color")) {
            this.setColor(DyeColor.values()[compound.func_74771_c("color")]);
        } else {
            this.setColor(this.getBikeType().defaultColor);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74774_a("type", (byte)this.bikeType.ordinal());
        compound.func_74774_a("color", (byte)this.color.ordinal());
    }

    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EnumBike getBikeType() {
        return this.bikeType;
    }

    public void setType(EnumBike type) {
        SYNC_TYPE.set((Entity)this, (Object)type);
        SYNC_COLOR.set((Entity)this, (Object)type.defaultColor);
    }

    public DyeColor getColor() {
        return this.color;
    }

    public void setColor(DyeColor type) {
        SYNC_COLOR.set((Entity)this, (Object)type);
    }

    protected void jump() {
        double motionY = 0.52f * (this.getBikeType() == EnumBike.Acro ? 1.2f : 1.0f) * (this.func_70090_H() ? 0.3f : 1.0f);
        this.func_213293_j(this.func_213322_ci().field_72450_a, motionY, this.func_213322_ci().field_72449_c);
        if (this.func_70051_ag()) {
            float f = this.field_70177_z * ((float)Math.PI / 180);
            this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b - (double)(MathHelper.func_76126_a((float)f) * 0.2f), this.func_213322_ci().field_72449_c + (double)(MathHelper.func_76134_b((float)f) * 0.2f));
        }
        this.field_70160_al = true;
    }

    private float getAcceleration() {
        return this.getBikeType() == EnumBike.Mach ? 0.1f : 0.9f;
    }

    private float getRideSpeed() {
        return 0.11f * (this.getBikeType() == EnumBike.Mach ? 1.3f : 1.0f);
    }

    private boolean shouldAnimate() {
        return this.func_184179_bs() != null && Math.abs(this.field_70169_q - this.func_226277_ct_()) + Math.abs(this.field_70166_s - this.func_226281_cx_()) > 0.001;
    }
}

