/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.WormholeTeleportEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.DimensionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RegistryHelper;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import com.pixelmonmod.pixelmon.world.dimension.ultraspace.UltraSpace;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkHooks;

public class WormholeEntity
extends Entity {
    private int maxAge = 800 + this.field_70146_Z.nextInt(1400);
    private int color = this.field_70146_Z.nextInt(6);
    private int soundTimer = 0;
    private int yaw = this.field_70146_Z.nextInt(360);
    private int pitch = this.field_70146_Z.nextInt(20) - 10;

    public WormholeEntity(EntityType<WormholeEntity> type, World world) {
        super(type, world);
    }

    public WormholeEntity(World worldIn) {
        this((EntityType<WormholeEntity>)((EntityType)EntityRegistration.WORMHOLE.get()), worldIn);
        this.maxAge = 800 + this.field_70146_Z.nextInt(1400);
        this.color = this.field_70146_Z.nextInt(6);
        this.yaw = this.field_70146_Z.nextInt(360);
        this.pitch = this.field_70146_Z.nextInt(20) - 10;
    }

    public WormholeEntity(World worldIn, int maxAge) {
        this(worldIn);
        this.maxAge = maxAge;
    }

    public WormholeEntity(World worldIn, double x, double y, double z, int maxAge) {
        this(worldIn, maxAge);
        this.func_70107_b(x, y + 7.0, z);
    }

    public WormholeEntity(World worldIn, double x, double y, double z, int maxAge, int color, int yaw, int pitch) {
        this(worldIn, maxAge);
        this.func_70107_b(x, y, z);
        this.color = Math.max(0, Math.min(color, 6));
        this.yaw = yaw;
        this.pitch = pitch;
    }

    protected void func_70088_a() {
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        float f = this.func_213311_cf() / 2.0f;
        float f1 = this.func_213302_cg();
        this.func_174826_a(new AxisAlignedBB(x - (double)f, y, z - (double)f, x + (double)f, y + (double)f1, z + (double)f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_74764_b("MaxAge")) {
            this.maxAge = compound.func_74762_e("MaxAge");
        }
        if (compound.func_74764_b("posX")) {
            this.func_70107_b(compound.func_74769_h("posX"), compound.func_74769_h("posY"), compound.func_74769_h("posZ"));
        }
        if (compound.func_74764_b("color")) {
            this.color = compound.func_74762_e("color");
        }
        if (compound.func_74764_b("pitch")) {
            this.pitch = compound.func_74762_e("pitch");
        }
        if (compound.func_74764_b("yaw")) {
            this.yaw = compound.func_74762_e("yaw");
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("MaxAge", this.maxAge);
        compound.func_74780_a("posX", this.func_226277_ct_());
        compound.func_74780_a("posY", this.func_226278_cu_());
        compound.func_74780_a("posZ", this.func_226281_cx_());
        compound.func_74768_a("color", this.color);
        compound.func_74768_a("pitch", this.pitch);
        compound.func_74768_a("yaw", this.yaw);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.maxAge != -1 && this.field_70173_aa > this.maxAge) {
                this.func_241204_bJ_();
            }
        } else if (this.soundTimer <= 0) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)SoundRegistration.ULTRA_WORMHOLE.get(), SoundCategory.BLOCKS, 0.3f, 1.0f, false);
            this.soundTimer = 380;
        } else {
            --this.soundTimer;
        }
    }

    public int getColor() {
        return this.color;
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        ServerPlayerEntity player;
        entityIn.field_70170_p.func_184133_a(null, entityIn.func_233580_cy_(), SoundEvents.field_187812_eh, SoundCategory.MASTER, 0.5f, 1.0f);
        if (!this.field_70170_p.field_72995_K && this.func_184102_h() != null && entityIn instanceof ServerPlayerEntity && !Pixelmon.EVENT_BUS.post((Event)new WormholeTeleportEvent.Pre(player = (ServerPlayerEntity)entityIn, this)) && PixelmonConfigProxy.getDimensions().isUltraSpace()) {
            if (this.field_70170_p.func_234923_W_().equals(UltraSpace.WORLD)) {
                RegistryKey d;
                double z;
                double y;
                double x;
                if (player.getPersistentData().func_74764_b("PortalX") && player.getPersistentData().func_74764_b("PortalY") && player.getPersistentData().func_74764_b("PortalZ") && player.getPersistentData().func_74764_b("PortalD")) {
                    x = player.getPersistentData().func_74769_h("PortalX");
                    y = player.getPersistentData().func_74769_h("PortalY");
                    z = player.getPersistentData().func_74769_h("PortalZ");
                    d = RegistryHelper.getKey(Registry.field_239699_ae_, player.getPersistentData().func_74779_i("PortalD"));
                } else {
                    x = this.func_226277_ct_();
                    y = this.func_226278_cu_();
                    z = this.func_226281_cx_();
                    d = player.func_241141_L_();
                }
                double[] destination = new double[]{x, y, z};
                WormholeEntity.wrapIntoWorldBorder(destination, (RegistryKey<World>)d);
                DimensionHelper.getWorld((RegistryKey<World>)d).ifPresent(world -> {
                    BlockPos coords = DimensionHelper.findLocation(world, player, destination[0], this.func_226278_cu_(), destination[2]);
                    player.func_200619_a(world, (double)coords.func_177958_n(), (double)coords.func_177956_o(), (double)coords.func_177952_p(), player.field_70177_z, player.field_70125_A);
                });
            } else {
                if (!PixelmonConfigProxy.getDimensions().isUltraSpace()) {
                    this.func_174812_G();
                    return;
                }
                player.func_184210_p();
                double[] destination = new double[]{this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()};
                WormholeEntity.wrapIntoWorldBorder(destination, UltraSpace.WORLD);
                player.getPersistentData().func_74780_a("PortalX", player.func_226277_ct_());
                player.getPersistentData().func_74780_a("PortalY", player.func_226278_cu_());
                player.getPersistentData().func_74780_a("PortalZ", player.func_226281_cx_());
                player.getPersistentData().func_74778_a("PortalD", player.func_71121_q().func_234923_W_().func_240901_a_().toString());
                DimensionHelper.getWorld(UltraSpace.WORLD).ifPresent(world -> {
                    BlockPos coords = DimensionHelper.findLocation(world, player, destination[0], this.func_226278_cu_(), destination[2]);
                    player.func_200619_a(world, (double)coords.func_177958_n(), (double)coords.func_177956_o(), (double)coords.func_177952_p(), player.field_70177_z, player.field_70125_A);
                });
            }
            WormholeTeleportEvent.Post postEvent = new WormholeTeleportEvent.Post(player, this);
            Pixelmon.EVENT_BUS.post((Event)postEvent);
            if (postEvent.shouldKillPortal()) {
                this.func_174812_G();
            }
        }
    }

    public static void wrapIntoWorldBorder(double[] pos, RegistryKey<World> dimension) {
        Optional<ServerWorld> world = DimensionHelper.getWorld(dimension);
        if (!world.isPresent() || world.get().func_175723_af() == null || world.get().func_175723_af().func_177746_a(new BlockPos(pos[0], pos[1], pos[2]))) {
            return;
        }
        WorldBorder border = world.get().func_175723_af();
        int w = (int)(border.func_177741_h() / 2.0);
        pos[0] = WormholeEntity.wrapOrdinate(pos[0], border.func_230316_a_() - (double)w, border.func_230316_a_() + (double)w);
        pos[2] = WormholeEntity.wrapOrdinate(pos[2], border.func_230317_b_() - (double)w, border.func_230317_b_() + (double)w);
    }

    private static double wrapOrdinate(double ordinate, double min, double max) {
        if (ordinate > min && ordinate < max) {
            return ordinate;
        }
        if (ordinate == min) {
            return ordinate + 2.0;
        }
        if (ordinate == max) {
            return ordinate - 2.0;
        }
        double dist = ordinate < min ? min - ordinate : ordinate - max;
        int oscillations = (int)Math.floor(dist / (max - min));
        if (ordinate < 0.0) {
            ++oscillations;
        }
        double remainder = dist % (max - min);
        ordinate = oscillations % 2 == 0 ? max - remainder : min + remainder;
        return ordinate;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70075_an() {
        return false;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int getPitch() {
        return this.pitch;
    }

    public int getYaw() {
        return this.yaw;
    }

    public boolean func_145770_h(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        return true;
    }
}

