/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.events.raids.DenEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.registries.PixelmonTicketType;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.BiomeHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.EntityHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NBTHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.PlayerHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.battles.raids.RaidRandomizer;
import com.pixelmonmod.pixelmon.client.models.animations.EnumRotation;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityDataSyncManager;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.items.SpawnDenItem;
import java.awt.Color;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeTileEntity;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class DenEntity
extends LivingEntity {
    public static final int MAX_PLAYER_RANGE = 30;
    private static final Rotations DEFAULT_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Color DEFAULT_COLOR_RGBA = new Color(255, 36, 134, 255);
    private static final Color DEFAULT_COLOR_UI_A = new Color(255, 108, 92);
    private static final Color DEFAULT_COLOR_UI_B = new Color(168, 59, 57);
    private static final Color DEFAULT_COLOR_UI_C = new Color(204, 0, 0, 51);
    public static final DataSync<DenEntity, Byte> SYNC_STATUS = new DataSync<DenEntity, Byte>(DenEntity.class, DataSerializers.field_187191_a, (denEntity, aByte) -> {
        denEntity.status = aByte;
    });
    public static final DataSync<DenEntity, Color> SYNC_COLOR_RGBA = new DataSync<DenEntity, Color>(DenEntity.class, PixelmonDataSerializers.COLOR, (denEntity, color) -> {
        denEntity.colorRGBA = color;
    });
    public static final DataSync<DenEntity, Color> SYNC_COLOR_UI_A = new DataSync<DenEntity, Color>(DenEntity.class, PixelmonDataSerializers.COLOR, (denEntity, color) -> {
        denEntity.colorUIA = color;
    });
    public static final DataSync<DenEntity, Color> SYNC_COLOR_UI_B = new DataSync<DenEntity, Color>(DenEntity.class, PixelmonDataSerializers.COLOR, (denEntity, color) -> {
        denEntity.colorUIB = color;
    });
    public static final DataSync<DenEntity, Color> SYNC_COLOR_UI_C = new DataSync<DenEntity, Color>(DenEntity.class, PixelmonDataSerializers.COLOR, (denEntity, color) -> {
        denEntity.colorUIC = color;
    });
    public static final DataSync<DenEntity, Boolean> SYNC_DECORATION = new DataSync<DenEntity, Boolean>(DenEntity.class, DataSerializers.field_187198_h, (denEntity, aBoolean) -> {
        denEntity.decoration = aBoolean;
    });
    public static final DataSync<DenEntity, Integer> SYNC_BEAMS = new DataSync<DenEntity, Integer>(DenEntity.class, DataSerializers.field_187192_b, (denEntity, integer) -> {
        denEntity.beams = integer;
    });
    public static final DataSync<DenEntity, Boolean> SYNC_ANIMATE = new DataSync<DenEntity, Boolean>(DenEntity.class, DataSerializers.field_187198_h, (denEntity, aBoolean) -> {
        denEntity.animate = aBoolean;
    });
    public static final DataSync<DenEntity, Boolean> SYNC_HIDE_BASE = new DataSync<DenEntity, Boolean>(DenEntity.class, DataSerializers.field_187198_h, (denEntity, aBoolean) -> {
        denEntity.hideBase = aBoolean;
    });
    public static final DataSync<DenEntity, Boolean> SYNC_NO_COLLIDE = new DataSync<DenEntity, Boolean>(DenEntity.class, DataSerializers.field_187198_h, (denEntity, aBoolean) -> {
        denEntity.noCollide = aBoolean;
        denEntity.canInteract = aBoolean == false;
    });
    public static final DataSync<DenEntity, Boolean> SYNC_BEAM_ON = new DataSync<DenEntity, Boolean>(DenEntity.class, DataSerializers.field_187198_h, (denEntity, aBoolean) -> {
        denEntity.beamOn = aBoolean;
    });
    public static final DataSync<DenEntity, Boolean> SYNC_BEAM_TAPER = new DataSync<DenEntity, Boolean>(DenEntity.class, DataSerializers.field_187198_h, (denEntity, aBoolean) -> {
        denEntity.beamTaper = aBoolean;
    });
    public static final DataSync<DenEntity, Float> SYNC_BEAM_LENGTH = new DataSync<DenEntity, Float>(DenEntity.class, DataSerializers.field_187193_c, (denEntity, aFloat) -> {
        denEntity.beamLength = aFloat.floatValue();
    });
    public static final DataSync<DenEntity, Float> SYNC_BEAM_WIDTH = new DataSync<DenEntity, Float>(DenEntity.class, DataSerializers.field_187193_c, (denEntity, aFloat) -> {
        denEntity.beamWidth = aFloat.floatValue();
    });
    public static final DataSync<DenEntity, Rotations> SYNC_ROTATION = new DataSync<DenEntity, Rotations>(DenEntity.class, DataSerializers.field_187199_i, (denEntity, rotations) -> {
        denEntity.rotation = rotations;
    });
    public static final DataSync<DenEntity, RaidData> SYNC_RAID_DATA = new DataSync<DenEntity, RaidData>(DenEntity.class, PixelmonDataSerializers.RAID_DATA, (denEntity, raidData1) -> {
        denEntity.raidData = raidData1;
    });
    public static final DataSync<DenEntity, Integer> SYNC_LAST_ROLL_DAY = new DataSync<DenEntity, Integer>(DenEntity.class, DataSerializers.field_187192_b, (denEntity, integer) -> {
        denEntity.lastRollDay = integer;
    });
    private boolean canInteract;
    private byte status;
    private Rotations rotation;
    private boolean decoration;
    private int beams;
    private boolean animate;
    private boolean hideBase;
    private boolean noCollide;
    private boolean beamOn;
    private boolean beamTaper;
    private float beamLength;
    private float beamWidth;
    private Color colorRGBA;
    private Color colorUIA;
    private Color colorUIB;
    private Color colorUIC;
    private RaidData raidData;
    private RaidData inUseRaidData;
    private boolean lockout = false;
    private int lastRollDay = -1;
    private long lastPickTime = -1L;
    private int pickHits = 0;
    public int ticker = 0;
    public PixelmonEntity display = null;
    protected EntityDataSyncManager dataSyncManager;

    public DenEntity(EntityType<DenEntity> type, World world) {
        super(type, world);
    }

    public DenEntity(World worldIn) {
        this((EntityType<DenEntity>)((EntityType)EntityRegistration.DEN.get()), worldIn);
        this.setDefaults();
        this.updateBoundingBox();
        this.field_70158_ak = true;
    }

    public void setDefaults() {
        this.rotation = DEFAULT_ROTATION;
        this.colorRGBA = DEFAULT_COLOR_RGBA;
        this.colorUIA = DEFAULT_COLOR_UI_A;
        this.colorUIB = DEFAULT_COLOR_UI_B;
        this.colorUIC = DEFAULT_COLOR_UI_C;
        this.decoration = false;
        this.animate = true;
        this.beams = -1;
        this.hideBase = false;
        this.noCollide = false;
        this.beamOn = false;
        this.beamTaper = true;
        this.beamLength = 65.0f;
        this.beamWidth = -1.0f;
        this.field_70145_X = this.func_189652_ae();
        this.lastRollDay = -1;
    }

    public DenEntity(World worldIn, double posX, double posY, double posZ) {
        this(worldIn);
        this.func_70107_b(posX, posY, posZ);
    }

    protected final void setSize(float width, float height) {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        this.func_70107_b(d0, d1, d2);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.define(SYNC_STATUS, (byte)0);
        this.define(SYNC_RAID_DATA, new RaidData(this.func_145782_y(), -1, 1, ""));
        this.define(SYNC_ROTATION, DEFAULT_ROTATION);
        this.define(SYNC_COLOR_RGBA, DEFAULT_COLOR_RGBA);
        this.define(SYNC_COLOR_UI_A, DEFAULT_COLOR_UI_A);
        this.define(SYNC_COLOR_UI_B, DEFAULT_COLOR_UI_B);
        this.define(SYNC_COLOR_UI_C, DEFAULT_COLOR_UI_C);
        this.define(SYNC_DECORATION, false);
        this.define(SYNC_ANIMATE, true);
        this.define(SYNC_BEAMS, -1);
        this.define(SYNC_HIDE_BASE, false);
        this.define(SYNC_NO_COLLIDE, false);
        this.define(SYNC_BEAM_ON, false);
        this.define(SYNC_BEAM_TAPER, true);
        this.define(SYNC_BEAM_LENGTH, Float.valueOf(65.0f));
        this.define(SYNC_BEAM_WIDTH, Float.valueOf(-1.0f));
        this.define(SYNC_LAST_ROLL_DAY, -1);
    }

    protected <A> void define(DataSync<?, A> sync, A value) {
        if (this.dataSyncManager == null) {
            this.dataSyncManager = new EntityDataSyncManager();
        }
        this.dataSyncManager.define((Entity)this, sync, value);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("Status", this.getStatus());
        compound.func_74768_a("ColorRGBA", this.colorRGBA.getRGB());
        compound.func_74768_a("ColorUIA", this.colorUIA.getRGB());
        compound.func_74768_a("ColorUIB", this.colorUIB.getRGB());
        compound.func_74768_a("ColorUIC", this.colorUIC.getRGB());
        if (!DEFAULT_ROTATION.equals((Object)this.rotation)) {
            compound.func_218657_a("Rotations", (INBT)this.rotation.func_179414_a());
        }
        compound.func_74757_a("Decoration", this.decoration);
        compound.func_74757_a("Animate", this.animate);
        compound.func_74768_a("Beams", this.beams);
        compound.func_74757_a("HideBase", this.hideBase);
        compound.func_74757_a("NoCollide", this.noCollide);
        compound.func_74757_a("BeamOn", this.beamOn);
        compound.func_74757_a("BeamTaper", this.beamTaper);
        compound.func_74776_a("BeamLength", this.beamLength);
        compound.func_74776_a("BeamWidth", this.beamWidth);
        compound.func_74768_a("LastRollDay", this.lastRollDay);
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        this.setColorRGBA(NBTHelper.getOrDefault(nbt, "ColorRGBA", DEFAULT_COLOR_RGBA.getRGB(), CompoundNBT::func_74762_e));
        this.setColorUIA(NBTHelper.getOrDefault(nbt, "ColorUIA", DEFAULT_COLOR_UI_A.getRGB(), CompoundNBT::func_74762_e));
        this.setColorUIB(NBTHelper.getOrDefault(nbt, "ColorUIB", DEFAULT_COLOR_UI_B.getRGB(), CompoundNBT::func_74762_e));
        this.setColorUIC(NBTHelper.getOrDefault(nbt, "ColorUIC", DEFAULT_COLOR_UI_C.getRGB(), CompoundNBT::func_74762_e));
        this.field_70145_X = this.func_189652_ae();
        ListNBT nbttaglist = nbt.func_150295_c("Rotations", 5);
        this.setRotation(nbttaglist.isEmpty() ? DEFAULT_ROTATION : new Rotations(nbttaglist));
        this.setDecoration(NBTHelper.getOrDefault(nbt, "Decoration", false, CompoundNBT::func_74767_n));
        this.setAnimate(NBTHelper.getOrDefault(nbt, "Animate", true, CompoundNBT::func_74767_n));
        this.setBeams(NBTHelper.getOrDefault(nbt, "Beams", -1, CompoundNBT::func_74762_e));
        this.setBaseHidden(NBTHelper.getOrDefault(nbt, "HideBase", false, CompoundNBT::func_74767_n));
        this.setNoCollide(NBTHelper.getOrDefault(nbt, "NoCollide", false, CompoundNBT::func_74767_n));
        this.setBeamOn(NBTHelper.getOrDefault(nbt, "BeamOn", false, CompoundNBT::func_74767_n));
        this.setBeamTaper(NBTHelper.getOrDefault(nbt, "BeamTaper", false, CompoundNBT::func_74767_n));
        this.setBeamLength(NBTHelper.getOrDefault(nbt, "BeamLength", Float.valueOf(65.0f), CompoundNBT::func_74760_g).floatValue());
        this.setBeamWidth(NBTHelper.getOrDefault(nbt, "BeamWidth", Float.valueOf(-1.0f), CompoundNBT::func_74760_g).floatValue());
        this.setLastRollDay(NBTHelper.getOrDefault(nbt, "LastRollDay", -1, CompoundNBT::func_74762_e));
    }

    public void func_213315_a(MoverType type, Vector3d pos) {
        super.func_213315_a(type, pos);
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_85033_bc() {
        super.func_85033_bc();
    }

    protected void func_82167_n(Entity entityIn) {
        Pixelmon.EVENT_BUS.post((Event)new DenEvent.Collide(this, entityIn));
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        if (!this.decoration && hand == Hand.MAIN_HAND && player instanceof ServerPlayerEntity && !Pixelmon.EVENT_BUS.post((Event)new DenEvent.Interact(this, player, true))) {
            ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
            PlayerPartyStorage pps = StorageProxy.getParty(playerMP);
            Pokemon pokemon = pps.getFirstAblePokemon();
            if (this.getServerData() != null && this.getServerData().getStars() != -1) {
                if (pokemon != null && pokemon.getPosition() != null) {
                    if (!this.getServerData().addPlayer(4, playerMP, pokemon, pokemon.getPosition().order)) {
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("raid.interact.inuse"), Util.field_240973_b_);
                    }
                } else {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("raid.interact.no_party"), Util.field_240973_b_);
                }
            } else if (this.attemptWishingPiece(player.func_184614_ca().func_77973_b(), player, true)) {
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        return ActionResultType.FAIL;
    }

    private boolean attemptWishingPiece(Item item, PlayerEntity player, boolean consumeHeldItem) {
        boolean special;
        if (this.getData().isPresent()) {
            return false;
        }
        boolean standard = item == PixelmonItems.wishing_piece;
        boolean bl = special = item == PixelmonItems.waterdude_wishing_piece;
        if (standard || special) {
            Optional<RaidData> raid;
            if (standard) {
                raid = RaidRandomizer.getRandomRaid(this, true);
            } else {
                Predicate<Species> predicate = p -> !p.getFirstForm().hasTag("undexable");
                raid = Optional.of(new RaidData(this.func_145782_y(), 5, PixelmonSpecies.getRandomLegendary(predicate)));
            }
            if (raid.isPresent()) {
                this.lockout = true;
                this.setData(raid.get());
                if (player != null) {
                    if (consumeHeldItem && !player.func_184812_l_()) {
                        player.func_184614_ca().func_190918_g(1);
                    }
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("raid.interact.wished"), Util.field_240973_b_);
                }
                this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), SoundEvents.field_187616_bj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
            if (player != null) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("raid.interact.wishfailed"), Util.field_240973_b_);
            }
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        block10: {
            if (!(source.func_76364_f() instanceof PlayerEntity) || Pixelmon.EVENT_BUS.post((Event)new DenEvent.Interact(this, (PlayerEntity)source.func_76364_f(), false))) break block10;
            PlayerEntity player = (PlayerEntity)source.func_76364_f();
            if (!player.func_130014_f_().field_72995_K) {
                ServerWorld world = (ServerWorld)player.func_130014_f_();
                if (player.func_184614_ca().func_77973_b() == PixelmonItems.den_spawner) {
                    if (SpawnDenItem.isOPOnly && !PlayerHelper.hasPermission((ServerPlayerEntity)player, "pixelmon.denspawner.use")) {
                        return false;
                    }
                    if (!player.func_184812_l_()) {
                        return false;
                    }
                    world.func_184133_a(null, this.func_233580_cy_(), SoundEvents.field_187835_fT, SoundCategory.BLOCKS, 1.0f, 0.5f);
                    this.func_241204_bJ_();
                    return true;
                }
                if (PixelmonConfigProxy.getRaids().isRaidDensBreakable() && player.func_184614_ca().func_77973_b() instanceof PickaxeItem) {
                    PickaxeItem pick = (PickaxeItem)player.func_184614_ca().func_77973_b();
                    long time = world.func_82737_E();
                    if (time - this.lastPickTime > 60L) {
                        this.pickHits = 0;
                    }
                    this.lastPickTime = time;
                    ++this.pickHits;
                    int rank = 7 - pick.func_200891_e().func_200925_d();
                    if (this.pickHits >= rank) {
                        this.func_241204_bJ_();
                        player.func_184614_ca().func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(Hand.MAIN_HAND));
                        world.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187718_dS, SoundCategory.BLOCKS, 2.0f, 1.0f);
                        for (int i = 0; i < 100; ++i) {
                            Vector3d sphere = RandomHelper.nextSpherePoint(1.5);
                            world.func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150348_b.func_176223_P()), this.func_226277_ct_() + sphere.field_72450_a, this.func_226278_cu_() + RandomHelper.rand.nextDouble() * 1.5, this.func_226281_cx_() + sphere.field_72449_c, 1, RandomHelper.rand.nextDouble() - 0.5, RandomHelper.rand.nextDouble() - 0.5, RandomHelper.rand.nextDouble() - 0.5, RandomHelper.rand.nextDouble() * 0.5);
                        }
                    } else {
                        world.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187843_fX, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        for (int i = 0; i < 10 * this.pickHits; ++i) {
                            Vector3d sphere = RandomHelper.nextSpherePoint(1.5);
                            world.func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150348_b.func_176223_P()), this.func_226277_ct_() + sphere.field_72450_a, this.func_226278_cu_() + RandomHelper.rand.nextDouble() * 1.5, this.func_226281_cx_() + sphere.field_72449_c, 1, RandomHelper.rand.nextDouble() - 0.5, RandomHelper.rand.nextDouble() - 0.5, RandomHelper.rand.nextDouble() - 0.5, RandomHelper.rand.nextDouble() * 0.5);
                        }
                    }
                }
            }
        }
        return false;
    }

    public void setStatus(byte status) {
        SYNC_STATUS.set((Entity)this, (Object)status);
    }

    public byte getStatus() {
        return this.status;
    }

    public void setData(RaidData data) {
        this.raidData = data;
        SYNC_RAID_DATA.set((Entity)this, (Object)data);
    }

    public void setInUseRaidData() {
        this.inUseRaidData = this.raidData;
    }

    public RaidData getInUseRaidData() {
        return this.inUseRaidData;
    }

    public void clearData() {
        SYNC_RAID_DATA.set((Entity)this, (Object)new RaidData(this.func_145782_y(), -1, 1, ""));
    }

    public RaidData getServerData() {
        return this.raidData;
    }

    public Optional<RaidData> getData() {
        if (this.raidData.getStars() < 0) {
            return Optional.empty();
        }
        return Optional.of(this.raidData);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
    }

    public Iterable<ItemStack> func_184193_aE() {
        return Collections.emptyList();
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        this.field_70158_ak = true;
        return true;
    }

    protected float func_110146_f(float p_110146_1_, float p_110146_2_) {
        this.field_70760_ar = this.field_70126_B;
        this.field_70761_aq = this.field_70177_z;
        return 0.0f;
    }

    public double func_70033_W() {
        return 0.1f;
    }

    public void func_181013_g(float offset) {
        this.field_70760_ar = this.field_70126_B = offset;
        this.field_70758_at = this.field_70759_as = offset;
    }

    public HandSide func_184591_cq() {
        return null;
    }

    public void func_70034_d(float rotation) {
        this.field_70760_ar = this.field_70126_B = rotation;
        this.field_70758_at = this.field_70759_as = rotation;
    }

    public boolean func_85031_j(Entity entityIn) {
        return false;
    }

    public boolean func_241849_j(Entity entity) {
        if (entity.func_200600_R().equals(EntityType.field_200765_E) && entity.func_184102_h() != null) {
            ServerPlayerEntity player;
            ItemEntity itemEntity = (ItemEntity)entity;
            ServerPlayerEntity serverPlayerEntity = player = itemEntity.func_200214_m() == null ? null : entity.func_184102_h().func_184103_al().func_177451_a(itemEntity.func_200214_m());
            if (this.attemptWishingPiece(itemEntity.func_92059_d().func_77973_b(), (PlayerEntity)player, false)) {
                itemEntity.func_92059_d().func_190918_g(1);
                if (itemEntity.func_92059_d().func_190916_E() <= 0) {
                    itemEntity.func_174812_G();
                }
            }
            return false;
        }
        return super.func_241849_j(entity);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_180799_ab()) {
            EntityHelper.setMotion((Entity)this, EnumRotation.y, 0.0);
        }
        if (this.field_70170_p instanceof ServerWorld) {
            if (!this.decoration) {
                long now = this.field_70170_p.func_72820_D();
                int day = (int)(now / 24000L);
                long marker = (long)(this.lastRollDay + 1) * 24000L;
                if (this.lastRollDay > day + 1) {
                    this.lastRollDay = 0;
                }
                if (day != this.lastRollDay && (this.field_70170_p.func_72820_D() % 24000L == (long)PixelmonConfigProxy.getRaids().getDenRespawnTime() || now >= marker)) {
                    this.roll(day);
                }
            }
        } else {
            this.getDisplay().ifPresent(display -> display.getAnimationVariables().tick());
        }
        if (this.getServerData() != null) {
            this.getServerData().onUpdate(this);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    public void func_213352_e(Vector3d p_213352_1_) {
        super.func_213352_e(p_213352_1_);
    }

    public void roll(int day) {
        this.setLastRollDay(day);
        if (this.getData().isPresent()) {
            if (!this.getServerData().hasPlayers()) {
                this.clearData();
            }
        } else if (this.lockout) {
            this.lockout = false;
        } else {
            RaidRandomizer.getRandomRaid(this, false).ifPresent(raid -> {
                ChunkPos chunkPos = new ChunkPos(this.func_233580_cy_().func_177958_n() >> 4, this.func_233580_cy_().func_177952_p() >> 4);
                ((ServerWorld)this.field_70170_p).func_72863_F().func_217228_a(PixelmonTicketType.RAID_DEN, chunkPos, 1, (Object)this.func_145782_y());
                this.setData((RaidData)raid);
                this.announce(this, raid.getSpecies(), this.field_70170_p.func_226691_t_(this.func_233580_cy_()));
            });
        }
    }

    private void announce(DenEntity den, Species species, Biome biome) {
        if (PixelmonConfigProxy.getSpawning().isDoLegendaryRaidEvent() && species.getDefaultForm().getTags().isLegendary()) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            String localizedBiome = BiomeHelper.getLocalizedBiomeName(biome).getString();
            IFormattableTextComponent message = TextHelper.translate(TextFormatting.GREEN, "spawn.legendaryraidmessage", species.getLocalizedName(), localizedBiome);
            server.func_184103_al().func_232641_a_((ITextComponent)new TranslationTextComponent("chat.type.announcement", new Object[]{TextFormatting.LIGHT_PURPLE + "Pixelmon" + TextFormatting.RESET, message}), ChatType.CHAT, Util.field_240973_b_);
            BlockPos pos = den.func_233580_cy_();
            server.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Spawned " + species.getName() + " at: " + den.field_70170_p.func_234923_W_().func_240901_a_() + " x:" + pos.func_177958_n() + ", y:" + pos.func_177956_o() + ", z:" + pos.func_177952_p()), Util.field_240973_b_);
        }
    }

    private void updateBoundingBox() {
        this.setSize(2.25f, 0.5f);
    }

    protected void func_175135_B() {
        this.func_82142_c(this.canInteract);
    }

    public void func_82142_c(boolean invisible) {
        this.canInteract = invisible;
        super.func_82142_c(invisible);
    }

    public void func_174812_G() {
        this.func_241204_bJ_();
    }

    public boolean func_180427_aV() {
        return true;
    }

    public PushReaction func_184192_z() {
        return PushReaction.IGNORE;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public void setColorRGBA(int rgb) {
        SYNC_COLOR_RGBA.set((Entity)this, (Object)new Color(rgb));
    }

    public Color getColorRGBA() {
        return this.colorRGBA;
    }

    public void setColorUIA(int rgb) {
        SYNC_COLOR_UI_A.set((Entity)this, (Object)new Color(rgb));
    }

    public Color getColorUIA() {
        return this.colorUIA;
    }

    public void setColorUIB(int rgb) {
        SYNC_COLOR_UI_B.set((Entity)this, (Object)new Color(rgb));
    }

    public Color getColorUIB() {
        return this.colorUIB;
    }

    public void setColorUIC(int rgb) {
        SYNC_COLOR_UI_C.set((Entity)this, (Object)new Color(rgb));
    }

    public Color getColorUIC() {
        return this.colorUIC;
    }

    public void setDecoration(boolean decoration) {
        SYNC_DECORATION.set((Entity)this, (Object)decoration);
    }

    public boolean isDecoration() {
        return this.decoration;
    }

    public void setAnimate(boolean animate) {
        SYNC_ANIMATE.set((Entity)this, (Object)animate);
    }

    public boolean isAnimating() {
        return this.animate;
    }

    public void setBeams(int beams) {
        SYNC_BEAMS.set((Entity)this, (Object)beams);
    }

    public int getBeams() {
        return this.beams;
    }

    public void setBaseHidden(boolean hideBase) {
        SYNC_HIDE_BASE.set((Entity)this, (Object)hideBase);
    }

    public boolean isBaseHidden() {
        return this.hideBase;
    }

    public void setNoCollide(boolean noCollide) {
        SYNC_NO_COLLIDE.set((Entity)this, (Object)noCollide);
    }

    public boolean isNoCollide() {
        boolean noCollide = this.noCollide;
        this.canInteract = !noCollide;
        return noCollide;
    }

    public void setBeamOn(boolean beamOn) {
        SYNC_BEAM_ON.set((Entity)this, (Object)beamOn);
    }

    public boolean isBeamOn() {
        return this.beamOn;
    }

    public void setBeamTaper(boolean beamTaper) {
        SYNC_BEAM_TAPER.set((Entity)this, (Object)beamTaper);
    }

    public boolean isBeamTaper() {
        return this.beamTaper;
    }

    public void setBeamLength(float beamLength) {
        SYNC_BEAM_LENGTH.set((Entity)this, (Object)Float.valueOf(beamLength));
    }

    public float getBeamLength() {
        return this.beamLength;
    }

    public void setBeamWidth(float beamWidth) {
        SYNC_BEAM_WIDTH.set((Entity)this, (Object)Float.valueOf(beamWidth));
    }

    public float getBeamWidth() {
        return this.beamWidth;
    }

    public void setLastRollDay(int lastRollDay) {
        SYNC_LAST_ROLL_DAY.set((Entity)this, (Object)lastRollDay);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<PixelmonEntity> getDisplay() {
        Optional<RaidData> raid = this.getData();
        if (raid.isPresent()) {
            if (this.display == null) {
                Pokemon pokemon = PokemonFactory.create(raid.get().getSpecies());
                if (raid.get().getForm() != null) {
                    pokemon.setForm(raid.get().getForm());
                }
                pokemon.setGrowth(EnumGrowth.Ordinary);
                this.display = new PixelmonEntity(this.field_70170_p, pokemon);
                this.display.setAnimation(AnimationType.IDLE);
                this.display.checkAnimation();
                this.display.initAnimation();
            }
            if (this.display != null && (!this.display.getPokemon().getSpecies().is(raid.get().getSpecies()) || raid.get().getForm() != null && !this.display.getForm().getName().equalsIgnoreCase(raid.get().getForm().getName()))) {
                this.display = null;
            }
            return Optional.ofNullable(this.display);
        }
        return Optional.empty();
    }

    private byte setBit(byte p_184797_1_, int p_184797_2_, boolean p_184797_3_) {
        p_184797_1_ = p_184797_3_ ? (byte)(p_184797_1_ | p_184797_2_) : (byte)(p_184797_1_ & ~p_184797_2_);
        return p_184797_1_;
    }

    public void setRotation(Rotations vec) {
        SYNC_ROTATION.set((Entity)this, (Object)vec);
    }

    public Rotations getRotation() {
        return this.rotation;
    }

    public boolean func_70067_L() {
        return true;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return SoundEvents.field_187841_fW;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187843_fX;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187835_fT;
    }

    protected float func_70599_aP() {
        return 0.0f;
    }

    public boolean func_184603_cC() {
        return false;
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        DataSync<?, ?> dataSync = this.dataSyncManager.getSync(key);
        if (dataSync != null) {
            dataSync.onSyncedDataUpdated(key, (Entity)this);
        }
    }

    public boolean func_190631_cK() {
        return false;
    }

    public AxisAlignedBB func_184177_bl() {
        return IForgeTileEntity.INFINITE_EXTENT_AABB;
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox() {
        if (this.field_70170_p.field_72995_K) {
            return this.func_70089_S() && !this.isNoCollide() ? this.func_174813_aQ() : null;
        }
        return this.func_70089_S() && !this.noCollide ? this.func_174813_aQ() : null;
    }

    public boolean func_241845_aY() {
        return this.func_70089_S() && !this.noCollide;
    }

    public boolean func_70027_ad() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)PixelmonItems.den_spawner);
    }

    public void func_233627_a_(float strength, double ratioX, double ratioZ) {
    }

    public boolean func_70648_aU() {
        return true;
    }
}

