/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl.quests;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.QuestRegistry;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SetStageCommand
extends PixelCommand {
    public SetStageCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "setstage", "/setstage <quest> <stage> [player]", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        if ((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 2)).length != 3) {
            PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.setstage.invalidargs", new Object[0]);
        }
        ServerPlayerEntity player = PixelmonCommandUtils.requireEntityPlayer(args[2]);
        short stage = (short)PixelmonCommandUtils.requireInt(args[1], Short.MIN_VALUE, Short.MAX_VALUE, "parsing.int.invalid", new Object[0]);
        PlayerPartyStorage party = StorageProxy.getParty(player);
        QuestData data = party.getQuestData();
        QuestProgress progress = PixelmonCommandUtils.require(data.getProgressForQuest(args[0], true), "pixelmon.command.invalidquest", new Object[0]);
        if (stage == -1) {
            progress.complete(player);
        } else {
            if (!progress.setStage(stage)) {
                PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.setstage.invalidstage", args[1], args[0].replace("_", " "));
                return;
            }
            progress.reopen();
        }
        progress.sendTo(player);
        sender.func_197030_a((ITextComponent)new TranslationTextComponent("pixelmon.command.setstage.notify", new Object[]{sender.func_197037_c(), player.func_145748_c_().getString(), args[0].replace("_", " "), args[1]}), true);
        PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.setstage.set", player.func_145748_c_().getString(), args[0].replace("_", " "), args[1]);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) {
        switch (args.length) {
            case 1: {
                return Lists.newArrayList(QuestRegistry.getInstance().getQuestFilepaths(true));
            }
            case 3: {
                if (!this.hasPermissionOtherTarget(sender)) break;
                return PixelmonCommandUtils.tabCompleteUsernames();
            }
        }
        return Collections.emptyList();
    }
}

