/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl.econ;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.economy.BankAccount;
import com.pixelmonmod.pixelmon.api.economy.BankAccountProxy;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class BankTransferCommand
extends PixelCommand {
    public BankTransferCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "transfer", "/transfer <player> <money>", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        if (args.length == 2) {
            ServerPlayerEntity target;
            ServerPlayerEntity player = sender.func_197035_h();
            if (player == (target = PixelmonCommandUtils.requireEntityPlayer(args[0]))) {
                PixelmonCommandUtils.endCommand("pixelmon.command.transfer.sameplayer", new Object[0]);
            }
            int amount = PixelmonCommandUtils.requireInt(args[1], 1, 999999, "parsing.int.invalid", new Object[0]);
            BankAccount userAccount = BankAccountProxy.getBankAccount(player).orElseThrow(() -> new NullPointerException("bank account"));
            BankAccount targetAccount = BankAccountProxy.getBankAccount(target).orElseThrow(() -> new NullPointerException("bank account"));
            if (userAccount.getBalance().doubleValue() < (double)amount) {
                PixelmonCommandUtils.endCommand("pixelmon.command.transfer.notenoughmoney", new Object[0]);
            }
            int beforeCurrency = targetAccount.getBalance().intValue();
            targetAccount.add(amount);
            int currencyDifference = targetAccount.getBalance().intValue() - beforeCurrency;
            if (currencyDifference == 0) {
                if (amount > 0) {
                    PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.givemoney.moneylimit", target.func_145748_c_());
                } else {
                    PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.givemoney.nomoney", target.func_145748_c_());
                }
                targetAccount.setBalance(beforeCurrency);
            } else {
                userAccount.take(currencyDifference);
                String currencyString = Integer.toString(currencyDifference);
                sender.func_197030_a((ITextComponent)new TranslationTextComponent("pixelmon.command.transfer.notifytransfer", new Object[]{sender.func_197037_c(), currencyString, target.func_145748_c_()}), true);
                PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.transfer.transferred", currencyString, target.func_145748_c_());
                target.func_145747_a((ITextComponent)new TranslationTextComponent("pixelmon.command.transfer.received", new Object[]{player.func_145748_c_(), currencyString}), Util.field_240973_b_);
            }
        } else {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) {
        return args.length == 1 ? PixelmonCommandUtils.tabCompleteUsernames() : Collections.emptyList();
    }
}

