/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import com.pixelmonmod.pixelmon.spawning.PlayerTrackingSpawner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class SpawningCommand
extends PixelCommand {
    public SpawningCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "spawning", "/spawning {off|on|diagnose]", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException {
        if (args.length == 0) {
            if (PixelmonSpawning.coordinator != null && PixelmonSpawning.coordinator.getActive()) {
                PixelmonCommandUtils.sendMessage(sender, "Spawner: On.", new Object[0]);
            } else {
                PixelmonCommandUtils.sendMessage(sender, "Spawner: Off", new Object[0]);
            }
        } else if (args[0].equalsIgnoreCase("off")) {
            if (PixelmonSpawning.coordinator != null) {
                PixelmonSpawning.coordinator.deactivate();
            }
            PixelmonCommandUtils.sendMessage(sender, "All spawning has been turned off.", new Object[0]);
        } else if (args[0].equalsIgnoreCase("on")) {
            if (PixelmonSpawning.coordinator != null) {
                PixelmonSpawning.coordinator.deactivate();
            }
            PixelmonSpawning.startTrackingSpawner();
            PixelmonCommandUtils.sendMessage(sender, "Better Spawning system has been engaged.", new Object[0]);
        } else if (args[0].equalsIgnoreCase("diagnose")) {
            boolean spawnerActive = PixelmonSpawning.coordinator != null && PixelmonSpawning.coordinator.getActive();
            PixelmonCommandUtils.sendMessage(sender, TextFormatting.GRAY + "Better Spawner: " + (spawnerActive ? TextFormatting.GREEN + "Active." : TextFormatting.RED + "Inactive."), new Object[0]);
            if (spawnerActive) {
                int spawnerCount = PixelmonSpawning.coordinator.spawners.size();
                PixelmonCommandUtils.sendMessage(sender, TextFormatting.GRAY + "Spawner count: " + TextFormatting.YELLOW + spawnerCount, new Object[0]);
                if (spawnerCount > 0) {
                    ArrayList<String> summaryMessages = new ArrayList<String>();
                    for (AbstractSpawner spawner : PixelmonSpawning.coordinator.spawners) {
                        double expectedSeconds;
                        if (!(spawner instanceof PlayerTrackingSpawner)) continue;
                        PlayerTrackingSpawner pts = (PlayerTrackingSpawner)spawner;
                        ServerPlayerEntity player = pts.getTrackedPlayer();
                        String message = player == null ? TextFormatting.RED + "OFFLINE PLAYER " + TextFormatting.GRAY + "(" : TextFormatting.YELLOW + player.func_200200_C_().getString() + " (";
                        double percentage = (double)pts.spawnedTracker.count() / (double)pts.capacity * 100.0;
                        String strPercentage = String.format("%.1f", percentage) + "%";
                        strPercentage = percentage == 100.0 || percentage == 0.0 ? TextFormatting.RED + strPercentage : TextFormatting.YELLOW + strPercentage;
                        message = message + strPercentage + TextFormatting.GRAY + ") - Last Cycle: ";
                        long timeSinceLastCycle = System.currentTimeMillis() - pts.lastCycleTime;
                        double seconds = (double)timeSinceLastCycle / 1000.0;
                        message = seconds > (expectedSeconds = (double)(pts.spawnFrequency / 60.0f)) * 60.0 ? message + TextFormatting.RED + String.format("%.1f", seconds) + "s" : (seconds > expectedSeconds * 10.0 ? message + TextFormatting.YELLOW + String.format("%.1f", seconds) + "s" : message + TextFormatting.GREEN + String.format("%.1f", seconds) + "s");
                        message = message + TextFormatting.GRAY + " - Last Spawn: ";
                        long timeSinceLastSpawn = System.currentTimeMillis() - pts.lastSpawnTime;
                        seconds = (double)timeSinceLastSpawn / 1000.0;
                        String time = String.format("%.1f", seconds) + "s";
                        message = seconds > expectedSeconds * 60.0 ? message + TextFormatting.RED + time : (seconds > expectedSeconds * 10.0 ? message + TextFormatting.YELLOW + time : message + TextFormatting.GREEN + time);
                        summaryMessages.add(message);
                    }
                    for (String message : summaryMessages) {
                        sender.func_197030_a((ITextComponent)new StringTextComponent(message), false);
                    }
                }
            }
        } else {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) {
        return args.length == 1 ? Lists.newArrayList((Object[])new String[]{"on", "off", "diagnose"}) : Collections.emptyList();
    }
}

