/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;

public class NpcKillCommand
extends PixelCommand {
    public NpcKillCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "npckill", "/npckill <world> <type>", 2);
    }

    @Override
    public List<String> getAliases() {
        return Lists.newArrayList((Object[])new String[]{"npkill"});
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException {
        ServerWorld world = PixelmonCommandUtils.getWorld(args, sender);
        int count = 0;
        int trainersInBattle = 0;
        for (Entity entity : world.getEntities().collect(Collectors.toList())) {
            if (!(entity instanceof NPCEntity)) continue;
            NPCEntity npc = (NPCEntity)entity;
            if (npc instanceof NPCTrainer) {
                NPCTrainer trainer = (NPCTrainer)npc;
                if (trainer.battleController != null) {
                    ++trainersInBattle;
                    continue;
                }
            }
            npc.func_70106_y();
            ++count;
        }
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.npckill.success", count), false);
        if (trainersInBattle > 0) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GRAY, "pixelmon.command.npckill.trainers", trainersInBattle), false);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1) {
            return Lists.newArrayList((Object[])new String[]{"Overworld", "Nether", "End"});
        }
        if (args.length == 2) {
            return Lists.newArrayList((Object[])new String[]{"All", "Chatting", "Doctor", "Relearner", "Shop", "Trader", "Trainer", "Tutor"});
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

