/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class LevellingCommand
extends PixelCommand {
    private static final List<String> ALIASES = Lists.newArrayList((Object[])new String[]{"plevelling", "level", "plevel"});
    private static final List<String> STATUS = Lists.newArrayList((Object[])new String[]{"off", "on"});

    public LevellingCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "levelling", "/levelling [player] <slot> <on|off>", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        if ((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0)).length != 3) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayerEntity player = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PlayerPartyStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage(player), "pixelmon.command.general.invalidplayer", new Object[0]);
        int slot = PixelmonCommandUtils.requireInt(args[1], 1, 6, "pixelmon.command.levelling.slot", new Object[0]);
        Pokemon pokemon = PixelmonCommandUtils.require(storage.get(slot - 1), "pixelmon.command.partyslot.nothing", player.func_200200_C_());
        boolean isLevelling = args[2].equalsIgnoreCase("on");
        if (pokemon == null || pokemon.isEgg()) {
            player.func_145747_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.levelling.failed", new Object[0]), Util.field_240973_b_);
            return;
        }
        pokemon.setDoesLevel(isLevelling);
        player.func_145747_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.levelling.success", isLevelling ? "Enabled" : "Disabled", pokemon.getLocalizedName()), Util.field_240973_b_);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        switch (args.length) {
            case 1: {
                if (this.hasPermissionOtherTarget(sender)) {
                    return PixelmonCommandUtils.tabCompleteUsernames();
                }
                return PixelmonCommandUtils.PARTY_SLOTS;
            }
            case 2: {
                if (this.hasPermissionOtherTarget(sender)) {
                    return PixelmonCommandUtils.PARTY_SLOTS;
                }
                return STATUS;
            }
            case 3: {
                return STATUS;
            }
        }
        return super.getTabCompletions(server, sender, args, pos);
    }

    @Override
    public List<String> getAliases() {
        return ALIASES;
    }
}

