/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class HealCommand
extends PixelCommand {
    public HealCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "pokeheal", "/pokeheal [player...]", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        if (args.length > 1) {
            for (String player : args) {
                this.execute(sender, new String[]{player});
            }
        } else {
            ServerPlayerEntity player = PixelmonCommandUtils.requireEntityPlayer((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0))[0]);
            if (BattleRegistry.getBattle((PlayerEntity)player) != null) {
                PixelmonCommandUtils.endCommand("pixelmon.command.heal.cantheal", player.func_145748_c_().getString());
            }
            PlayerPartyStorage party = StorageProxy.getParty(player);
            party.heal();
            PixelmonCommandUtils.notifyCommandListener(sender, this, 0, "pixelmon.command.heal.notifyhealed", sender.func_197037_c(), player.func_145748_c_().getString());
            PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.heal.healed", player.func_145748_c_().getString());
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (this.hasPermissionOtherTarget(sender) && args.length >= 1) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

