/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.util.helpers.SpriteItemHelper;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GivePixelSpriteCommand
extends PixelCommand {
    public GivePixelSpriteCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "givepixelsprite", "/givepixelsprite [player] <spec...>", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        if ((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0)).length < 2) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayerEntity player = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PokemonSpecification spec = PokemonSpecificationProxy.create(args = Arrays.copyOfRange(args, 1, args.length));
        if (!spec.getValue(SpeciesRequirement.class).isPresent()) {
            PixelmonCommandUtils.endCommand("pixelmon.command.general.invalid", new Object[0]);
        }
        ItemStack stack = SpriteItemHelper.getPhoto(spec.create());
        player.field_71071_by.func_70441_a(stack);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1) {
            if (this.hasPermissionOtherTarget(sender)) {
                return PixelmonCommandUtils.tabCompleteUsernames();
            }
            return PixelmonCommandUtils.tabCompletePokemon();
        }
        if (args.length == 2) {
            if (this.hasPermissionOtherTarget(sender)) {
                return PixelmonCommandUtils.tabCompletePokemon();
            }
            return PixelmonCommandUtils.SPEC_REQUIREMENTS;
        }
        if (args.length == 3) {
            return PixelmonCommandUtils.SPEC_REQUIREMENTS;
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

