/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.EndSpectatePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.ExitBattlePacket;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class EndBattleCommand
extends PixelCommand {
    public EndBattleCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "endbattle", "/endbattle [player]", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        ServerPlayerEntity player = PixelmonCommandUtils.requireEntityPlayer((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0))[0]);
        BattleController bc = BattleRegistry.getBattle((PlayerEntity)player);
        if (bc != null) {
            if (bc.removeSpectator(player)) {
                NetworkHelper.sendPacket(new EndSpectatePacket(), player);
            } else {
                bc.endBattle(BattleEndCause.FORCE);
                sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.endbattle.endbattle", new Object[0]), false);
                BattleRegistry.deRegisterBattle(bc);
            }
        } else {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.endbattle.notinbattle", player.func_200200_C_()), false);
            NetworkHelper.sendPacket(new ExitBattlePacket(), player);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1 && this.hasPermissionOtherTarget(sender)) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

