/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CompTestCommand
extends PixelCommand {
    public CompTestCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "comptest", "/comptest [player] <box> <slot> <specs...>", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        if ((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0)).length < 3) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayerEntity target = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PCStorage storage = PixelmonCommandUtils.require(StorageProxy.getPCForPlayer(target), "pixelmon.command.general.invalidplayer", new Object[0]);
        int box = PixelmonCommandUtils.requireInt(args[1], 1, PixelmonConfigProxy.getStorage().getComputerBoxes(), "pixelmon.command.box", PixelmonConfigProxy.getStorage().getComputerBoxes());
        int slot = PixelmonCommandUtils.requireInt(args[2], 1, 30, "pixelmon.command.slot", 30);
        StoragePosition storagePosition = new StoragePosition(box - 1, slot - 1);
        Pokemon pokemon = PixelmonCommandUtils.require(storage.get(storagePosition), "pixelmon.command.compslot.nothing", target.func_200200_C_());
        CharSequence[] specList = Arrays.copyOfRange(args, 2, args.length);
        PokemonSpecification spec = PokemonSpecificationProxy.create(String.join((CharSequence)" ", specList));
        if (spec.matches(pokemon)) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.comptest.match", pokemon.getLocalizedName()), false);
        } else {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.comptest.nomatch", pokemon.getLocalizedName()), false);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        boolean hasPermissionOtherTarget = this.hasPermissionOtherTarget(sender);
        switch (args.length) {
            case 0: {
                return super.getTabCompletions(server, sender, args, pos);
            }
            case 1: {
                if (hasPermissionOtherTarget) {
                    return PixelmonCommandUtils.tabCompleteUsernames();
                }
                return IntStream.range(1, PixelmonConfigProxy.getStorage().getComputerBoxes()).mapToObj(String::valueOf).collect(Collectors.toList());
            }
            case 2: {
                if (hasPermissionOtherTarget) {
                    return IntStream.range(1, PixelmonConfigProxy.getStorage().getComputerBoxes()).mapToObj(String::valueOf).collect(Collectors.toList());
                }
                return IntStream.range(1, 30).mapToObj(String::valueOf).collect(Collectors.toList());
            }
            case 3: {
                if (!hasPermissionOtherTarget) break;
                return IntStream.range(1, 30).mapToObj(String::valueOf).collect(Collectors.toList());
            }
        }
        return PixelmonCommandUtils.SPEC_REQUIREMENTS;
    }
}

