/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.aggression.Aggression;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.RegexPatterns;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class Battle2
extends PixelCommand {
    public Battle2(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher);
    }

    @Override
    public String getName() {
        return "pokebattle2";
    }

    @Override
    public String getUsage(CommandSource sender) {
        return "/pokebattle2 <player> <player|pokemon> <player|pokemon> <player|pokemon>";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException {
        if (args.length < 2) {
            PixelmonCommandUtils.sendMessage(sender, this.getUsage(sender), new Object[0]);
            return;
        }
        try {
            BattleParticipant[] team2;
            BattleParticipant[] team1;
            ArrayList<BattleParticipant> participants = new ArrayList<BattleParticipant>();
            ArrayList<PixelmonEntity> wildPixelmon = new ArrayList<PixelmonEntity>();
            ArrayList<String> playerNames = new ArrayList<String>();
            int numParticipants = 0;
            for (String arg : args) {
                if (arg.startsWith("lvl")) continue;
                ++numParticipants;
            }
            if (numParticipants < 2 || numParticipants > 4) {
                PixelmonCommandUtils.sendMessage(sender, TextFormatting.RED, "pixelmon.command.battle2.cantstart", new Object[0]);
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("lvl")) continue;
                Object part = this.getPart(sender, args[i]);
                if (part == null) {
                    PixelmonCommandUtils.sendMessage(sender, TextFormatting.RED, "pixelmon.command.battle2.invalid", i + 1);
                    return;
                }
                if (part instanceof ServerPlayerEntity) {
                    ServerPlayerEntity playerPart = (ServerPlayerEntity)part;
                    if (BattleRegistry.getBattle((PlayerEntity)playerPart) != null) {
                        PixelmonCommandUtils.sendMessage(sender, TextFormatting.RED, "sendpixelmon.inbattle", playerPart.func_145748_c_());
                        return;
                    }
                    if (playerNames.contains(playerPart.func_145748_c_().getString())) {
                        PixelmonCommandUtils.sendMessage(sender, TextFormatting.RED, "pixelmon.command.battle2.duplicate", new Object[0]);
                        return;
                    }
                    playerNames.add(playerPart.func_145748_c_().getString());
                    PlayerPartyStorage party = StorageProxy.getParty(playerPart);
                    List<Pokemon> availablePokemon = party.findAll(Pokemon::canBattle);
                    PixelmonEntity[] leadPokemon = numParticipants == 2 || numParticipants == 3 && i == 0 ? (availablePokemon.isEmpty() ? new PixelmonEntity[]{null, null} : (availablePokemon.size() == 1 ? new PixelmonEntity[]{availablePokemon.get(0).getOrSpawnPixelmon((Entity)playerPart)} : new PixelmonEntity[]{availablePokemon.get(0).getOrSpawnPixelmon((Entity)playerPart), availablePokemon.get(1).getOrSpawnPixelmon((Entity)playerPart)})) : new PixelmonEntity[]{party.getAndSendOutFirstAblePokemon((Entity)playerPart)};
                    if (leadPokemon.length > 0 && leadPokemon[0] != null) {
                        participants.add(new PlayerParticipant(playerPart, leadPokemon));
                        continue;
                    }
                    PixelmonCommandUtils.sendMessage(sender, TextFormatting.RED, "pixelmon.command.battle.nopokemon", playerPart.func_145748_c_());
                    return;
                }
                if (part instanceof PixelmonEntity) {
                    PixelmonEntity wildPart = (PixelmonEntity)part;
                    if (i == 0) {
                        PixelmonCommandUtils.sendMessage(sender, TextFormatting.RED, "pixelmon.command.battle2.first", new Object[0]);
                        return;
                    }
                    if (i + 1 < args.length && args[i + 1].startsWith("lvl")) {
                        int level = Integer.parseInt(RegexPatterns.LETTERS.matcher(args[i + 1]).replaceAll(""));
                        if (level > 0 && level <= PixelmonServerConfig.maxLevel) {
                            wildPart.getLvl().setLevel(level);
                        } else {
                            PixelmonCommandUtils.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.cheater", new Object[0]);
                        }
                    } else {
                        wildPart.getLvl().setLevel(((PlayerParticipant)participants.get(0)).getHighestLevel());
                    }
                    wildPixelmon.add(wildPart);
                    participants.add(new WildPixelmonParticipant(wildPart));
                    continue;
                }
                if (!(part instanceof NPCTrainer)) continue;
                NPCTrainer trainer = (NPCTrainer)((Object)part);
                if (trainer.battleController != null) {
                    PixelmonCommandUtils.sendMessage(sender, TextFormatting.RED, "sendpixelmon.inbattle", trainer.func_200200_C_());
                    return;
                }
                participants.add(new TrainerParticipant(trainer, 2));
            }
            ServerPlayerEntity player = ((PlayerParticipant)participants.get((int)0)).player;
            for (int i = 0; i < wildPixelmon.size(); ++i) {
                PixelmonEntity p = (PixelmonEntity)wildPixelmon.get(i);
                p.aggression = Aggression.PASSIVE;
                if (i == 0) {
                    p.func_70107_b(player.func_226277_ct_() + 2.0, Battle2.getTopEarthBlock(player.field_70170_p, (int)player.func_226277_ct_(), (int)player.func_226281_cx_()), player.func_226281_cx_());
                } else if (i == 1) {
                    p.func_70107_b(player.func_226277_ct_(), Battle2.getTopEarthBlock(player.field_70170_p, (int)player.func_226277_ct_(), (int)player.func_226281_cx_()), player.func_226281_cx_() + 2.0);
                } else if (i == 2) {
                    p.func_70107_b(player.func_226277_ct_() + 2.0, Battle2.getTopEarthBlock(player.field_70170_p, (int)player.func_226277_ct_(), (int)player.func_226281_cx_()), player.func_226281_cx_() + 2.0);
                }
                player.field_70170_p.func_217376_c((Entity)p);
            }
            ArrayList battleParticipants = new ArrayList();
            if (numParticipants == 2) {
                team1 = new BattleParticipant[]{(BattleParticipant)participants.get(0)};
                team2 = new BattleParticipant[]{(BattleParticipant)participants.get(1)};
            } else if (numParticipants == 3) {
                team1 = new BattleParticipant[]{(BattleParticipant)participants.get(0)};
                team2 = new BattleParticipant[]{(BattleParticipant)participants.get(1), (BattleParticipant)participants.get(2)};
                for (BattleParticipant participant : team2) {
                    if (!(participant instanceof TrainerParticipant)) continue;
                    participant.setNumControlledPokemon(1);
                }
            } else if (numParticipants == 4) {
                team1 = new BattleParticipant[]{(BattleParticipant)participants.get(0), (BattleParticipant)participants.get(1)};
                team2 = new BattleParticipant[]{(BattleParticipant)participants.get(2), (BattleParticipant)participants.get(3)};
                for (BattleParticipant participant : participants) {
                    if (!(participant instanceof TrainerParticipant)) continue;
                    participant.setNumControlledPokemon(1);
                }
            } else {
                CommandChatHandler.sendChat(sender, "pixelmon.command.battle2.cantstart", new Object[0]);
                return;
            }
            ((BattleParticipant)participants.get((int)0)).startedBattle = true;
            BattleRegistry.startBattle(team1, team2, new BattleRules(BattleType.DOUBLE));
        }
        catch (NumberFormatException e) {
            PixelmonCommandUtils.sendMessage(sender, TextFormatting.RED, "pixelmon.command.battle2.pokemonLevel", new Object[0]);
        }
        catch (ClassCastException e) {
            PixelmonCommandUtils.sendMessage(sender, TextFormatting.RED, "pixelmon.command.battle2.cantstart", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getTopEarthBlock(World world, int cpX, int cpZ) {
        Chunk chunk = world.func_175726_f(new BlockPos(cpX, 0, cpZ));
        Integer k = null;
        k = Math.max(0, Math.min(chunk.func_76625_h() + 15, 255));
        while (k > 0) {
            Block block = world.func_180495_p(new BlockPos(cpX, k.intValue(), cpZ)).func_177230_c();
            if (block != Blocks.field_150350_a && !block.func_181623_g()) {
                return k + 1;
            }
            k = k - 1;
        }
        return chunk.func_76625_h() + 15;
    }

    private Object getPart(CommandSource sender, String value) {
        ServerPlayerEntity player = PixelmonCommandUtils.getEntityPlayer(value);
        if (player != null) {
            return player;
        }
        PokemonSpecification spec = PokemonSpecificationProxy.create(value);
        RegistryValue species = spec.getValue(SpeciesRequirement.class).orElse(null);
        if (species == null || !species.isInitialized()) {
            String langCode = sender.func_197022_f() instanceof ServerPlayerEntity ? ((ServerPlayerEntity)sender.func_197022_f()).getLanguage() : "en_US";
            Optional<NPCTrainer> trainer = NPCEntity.locateNPCServer((World)sender.func_197023_e(), value, NPCTrainer.class, langCode);
            return trainer.orElse(null);
        }
        return spec.create((World)sender.func_197023_e());
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) {
        if (args.length >= 1 && args.length <= 4) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        return Collections.emptyList();
    }
}

