/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.trainerCard;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.client.gui.trainerCard.TrainerCardScreen;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.enums.EnumTrainerCardColor;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class TrainerCardPacket
extends AbstractPixelmonPacket {
    private UUID playerId;
    private EnumTrainerCardColor color;
    private BigDecimal money;
    private int caughtCount;
    private Pokemon[] party = new Pokemon[6];

    public TrainerCardPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public TrainerCardPacket(UUID playerId, EnumTrainerCardColor color, BigDecimal money, int caughtCount, Pokemon[] party) {
        super(PacketDirection.PLAY_CLIENT);
        this.playerId = playerId;
        this.color = color;
        this.money = money;
        this.caughtCount = caughtCount;
        this.party = party;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeLong(this.playerId.getMostSignificantBits());
        buf.writeLong(this.playerId.getLeastSignificantBits());
        buf.writeShort(this.color.ordinal());
        buf.func_180714_a(this.money.toString());
        buf.writeInt(this.caughtCount);
        buf.writeShort(this.party.length);
        for (Pokemon poke : this.party) {
            boolean isPresent = poke != null;
            buf.writeBoolean(isPresent);
            if (!isPresent) continue;
            poke.writeToByteBuffer(buf, EnumUpdateType.Appearance);
        }
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.playerId = buf.func_179253_g();
        this.color = EnumTrainerCardColor.values()[buf.readShort()];
        this.money = new BigDecimal(buf.func_218666_n());
        this.caughtCount = buf.readInt();
        int length = buf.readShort();
        for (int i = 0; i < length; ++i) {
            if (!buf.readBoolean()) continue;
            this.party[i] = PokemonFactory.create(UUID.randomUUID()).readFromByteBuffer(buf, EnumUpdateType.Appearance);
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        if (Minecraft.func_71410_x().field_71462_r instanceof TrainerCardScreen) {
            TrainerCardScreen gui = (TrainerCardScreen)Minecraft.func_71410_x().field_71462_r;
            if (gui.player.func_110124_au().equals(this.playerId)) {
                gui.color = this.color;
                gui.money = NumberFormat.getInstance().format(this.money);
                gui.caughtCount = this.caughtCount;
                gui.party = this.party;
            }
        }
    }
}

